/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.fwd;

import com.google.common.collect.ImmutableSet;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onlab.packet.ICMP;
import org.onlab.packet.ICMP6;
import org.onlab.packet.IPv4;
import org.onlab.packet.IPv6;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.Ip6Prefix;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TCP;
import org.onlab.packet.TpPort;
import org.onlab.packet.UDP;
import org.onlab.packet.VlanId;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.host.HostService;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.topology.TopologyEvent;
import org.onosproject.net.topology.TopologyListener;
import org.onosproject.net.topology.TopologyService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class ReactiveForwarding {
    private static final int DEFAULT_TIMEOUT = 10;
    private static final int DEFAULT_PRIORITY = 10;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    private ReactivePacketProcessor processor = new ReactivePacketProcessor();
    private ApplicationId appId;
    @Property(name="packetOutOnly", boolValue={false}, label="Enable packet-out only forwarding; default is false")
    private boolean packetOutOnly = false;
    @Property(name="packetOutOfppTable", boolValue={false}, label="Enable first packet forwarding using OFPP_TABLE port instead of PacketOut with actual port; default is false")
    private boolean packetOutOfppTable = false;
    @Property(name="flowTimeout", intValue={10}, label="Configure Flow Timeout for installed flow rules; default is 10 sec")
    private int flowTimeout = 10;
    @Property(name="flowPriority", intValue={10}, label="Configure Flow Priority for installed flow rules; default is 10")
    private int flowPriority = 10;
    @Property(name="ipv6Forwarding", boolValue={false}, label="Enable IPv6 forwarding; default is false")
    private boolean ipv6Forwarding = false;
    @Property(name="matchDstMacOnly", boolValue={false}, label="Enable matching Dst Mac Only; default is false")
    private boolean matchDstMacOnly = false;
    @Property(name="matchVlanId", boolValue={false}, label="Enable matching Vlan ID; default is false")
    private boolean matchVlanId = false;
    @Property(name="matchIpv4Address", boolValue={false}, label="Enable matching IPv4 Addresses; default is false")
    private boolean matchIpv4Address = false;
    @Property(name="matchIpv4Dscp", boolValue={false}, label="Enable matching IPv4 DSCP and ECN; default is false")
    private boolean matchIpv4Dscp = false;
    @Property(name="matchIpv6Address", boolValue={false}, label="Enable matching IPv6 Addresses; default is false")
    private boolean matchIpv6Address = false;
    @Property(name="matchIpv6FlowLabel", boolValue={false}, label="Enable matching IPv6 FlowLabel; default is false")
    private boolean matchIpv6FlowLabel = false;
    @Property(name="matchTcpUdpPorts", boolValue={false}, label="Enable matching TCP/UDP ports; default is false")
    private boolean matchTcpUdpPorts = false;
    @Property(name="matchIcmpFields", boolValue={false}, label="Enable matching ICMPv4 and ICMPv6 fields; default is false")
    private boolean matchIcmpFields = false;
    @Property(name="ignoreIPv4Multicast", boolValue={false}, label="Ignore (do not forward) IPv4 multicast packets; default is false")
    private boolean ignoreIpv4McastPackets = false;
    private final TopologyListener topologyListener = new InternalTopologyListener();

    @Activate
    public void activate(ComponentContext context) {
        this.cfgService.registerProperties(this.getClass());
        this.appId = this.coreService.registerApplication("org.onosproject.fwd");
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)2));
        this.topologyService.addListener((EventListener)this.topologyListener);
        this.readComponentConfiguration(context);
        this.requestIntercepts();
        this.log.info("Started", (Object)this.appId.id());
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.withdrawIntercepts();
        this.flowRuleService.removeFlowRulesById(this.appId);
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.topologyService.removeListener((EventListener)this.topologyListener);
        this.processor = null;
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        this.readComponentConfiguration(context);
        this.requestIntercepts();
    }

    private void requestIntercepts() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        this.packetService.requestPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
        selector.matchEthType(Ethernet.TYPE_ARP);
        this.packetService.requestPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
        selector.matchEthType(Ethernet.TYPE_IPV6);
        if (this.ipv6Forwarding) {
            this.packetService.requestPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
        } else {
            this.packetService.cancelPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
        }
    }

    private void withdrawIntercepts() {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        this.packetService.cancelPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
        selector.matchEthType(Ethernet.TYPE_ARP);
        this.packetService.cancelPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
        selector.matchEthType(Ethernet.TYPE_IPV6);
        this.packetService.cancelPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
    }

    private void readComponentConfiguration(ComponentContext context) {
        Dictionary properties = context.getProperties();
        Boolean packetOutOnlyEnabled = Tools.isPropertyEnabled((Dictionary)properties, (String)"packetOutOnly");
        if (packetOutOnlyEnabled == null) {
            this.log.info("Packet-out is not configured, using current value of {}", (Object)this.packetOutOnly);
        } else {
            this.packetOutOnly = packetOutOnlyEnabled;
            this.log.info("Configured. Packet-out only forwarding is {}", (Object)(this.packetOutOnly ? "enabled" : "disabled"));
        }
        Boolean packetOutOfppTableEnabled = Tools.isPropertyEnabled((Dictionary)properties, (String)"packetOutOfppTable");
        if (packetOutOfppTableEnabled == null) {
            this.log.info("OFPP_TABLE port is not configured, using current value of {}", (Object)this.packetOutOfppTable);
        } else {
            this.packetOutOfppTable = packetOutOfppTableEnabled;
            this.log.info("Configured. Forwarding using OFPP_TABLE port is {}", (Object)(this.packetOutOfppTable ? "enabled" : "disabled"));
        }
        Boolean ipv6ForwardingEnabled = Tools.isPropertyEnabled((Dictionary)properties, (String)"ipv6Forwarding");
        if (ipv6ForwardingEnabled == null) {
            this.log.info("IPv6 forwarding is not configured, using current value of {}", (Object)this.ipv6Forwarding);
        } else {
            this.ipv6Forwarding = ipv6ForwardingEnabled;
            this.log.info("Configured. IPv6 forwarding is {}", (Object)(this.ipv6Forwarding ? "enabled" : "disabled"));
        }
        Boolean matchDstMacOnlyEnabled = Tools.isPropertyEnabled((Dictionary)properties, (String)"matchDstMacOnly");
        if (matchDstMacOnlyEnabled == null) {
            this.log.info("Match Dst MAC is not configured, using current value of {}", (Object)this.matchDstMacOnly);
        } else {
            this.matchDstMacOnly = matchDstMacOnlyEnabled;
            this.log.info("Configured. Match Dst MAC Only is {}", (Object)(this.matchDstMacOnly ? "enabled" : "disabled"));
        }
        Boolean matchVlanIdEnabled = Tools.isPropertyEnabled((Dictionary)properties, (String)"matchVlanId");
        if (matchVlanIdEnabled == null) {
            this.log.info("Matching Vlan ID is not configured, using current value of {}", (Object)this.matchVlanId);
        } else {
            this.matchVlanId = matchVlanIdEnabled;
            this.log.info("Configured. Matching Vlan ID is {}", (Object)(this.matchVlanId ? "enabled" : "disabled"));
        }
        Boolean matchIpv4AddressEnabled = Tools.isPropertyEnabled((Dictionary)properties, (String)"matchIpv4Address");
        if (matchIpv4AddressEnabled == null) {
            this.log.info("Matching IPv4 Address is not configured, using current value of {}", (Object)this.matchIpv4Address);
        } else {
            this.matchIpv4Address = matchIpv4AddressEnabled;
            this.log.info("Configured. Matching IPv4 Addresses is {}", (Object)(this.matchIpv4Address ? "enabled" : "disabled"));
        }
        Boolean matchIpv4DscpEnabled = Tools.isPropertyEnabled((Dictionary)properties, (String)"matchIpv4Dscp");
        if (matchIpv4DscpEnabled == null) {
            this.log.info("Matching IPv4 DSCP and ECN is not configured, using current value of {}", (Object)this.matchIpv4Dscp);
        } else {
            this.matchIpv4Dscp = matchIpv4DscpEnabled;
            this.log.info("Configured. Matching IPv4 DSCP and ECN is {}", (Object)(this.matchIpv4Dscp ? "enabled" : "disabled"));
        }
        Boolean matchIpv6AddressEnabled = Tools.isPropertyEnabled((Dictionary)properties, (String)"matchIpv6Address");
        if (matchIpv6AddressEnabled == null) {
            this.log.info("Matching IPv6 Address is not configured, using current value of {}", (Object)this.matchIpv6Address);
        } else {
            this.matchIpv6Address = matchIpv6AddressEnabled;
            this.log.info("Configured. Matching IPv6 Addresses is {}", (Object)(this.matchIpv6Address ? "enabled" : "disabled"));
        }
        Boolean matchIpv6FlowLabelEnabled = Tools.isPropertyEnabled((Dictionary)properties, (String)"matchIpv6FlowLabel");
        if (matchIpv6FlowLabelEnabled == null) {
            this.log.info("Matching IPv6 FlowLabel is not configured, using current value of {}", (Object)this.matchIpv6FlowLabel);
        } else {
            this.matchIpv6FlowLabel = matchIpv6FlowLabelEnabled;
            this.log.info("Configured. Matching IPv6 FlowLabel is {}", (Object)(this.matchIpv6FlowLabel ? "enabled" : "disabled"));
        }
        Boolean matchTcpUdpPortsEnabled = Tools.isPropertyEnabled((Dictionary)properties, (String)"matchTcpUdpPorts");
        if (matchTcpUdpPortsEnabled == null) {
            this.log.info("Matching TCP/UDP fields is not configured, using current value of {}", (Object)this.matchTcpUdpPorts);
        } else {
            this.matchTcpUdpPorts = matchTcpUdpPortsEnabled;
            this.log.info("Configured. Matching TCP/UDP fields is {}", (Object)(this.matchTcpUdpPorts ? "enabled" : "disabled"));
        }
        Boolean matchIcmpFieldsEnabled = Tools.isPropertyEnabled((Dictionary)properties, (String)"matchIcmpFields");
        if (matchIcmpFieldsEnabled == null) {
            this.log.info("Matching ICMP (v4 and v6) fields is not configured, using current value of {}", (Object)this.matchIcmpFields);
        } else {
            this.matchIcmpFields = matchIcmpFieldsEnabled;
            this.log.info("Configured. Matching ICMP (v4 and v6) fields is {}", (Object)(this.matchIcmpFields ? "enabled" : "disabled"));
        }
        Boolean ignoreIpv4McastPacketsEnabled = Tools.isPropertyEnabled((Dictionary)properties, (String)"ignoreIpv4McastPackets");
        if (ignoreIpv4McastPacketsEnabled == null) {
            this.log.info("Ignore IPv4 multi-cast packet is not configured, using current value of {}", (Object)this.ignoreIpv4McastPackets);
        } else {
            this.ignoreIpv4McastPackets = ignoreIpv4McastPacketsEnabled;
            this.log.info("Configured. Ignore IPv4 multicast packets is {}", (Object)(this.ignoreIpv4McastPackets ? "enabled" : "disabled"));
        }
        this.flowTimeout = Tools.getIntegerProperty((Dictionary)properties, (String)"flowTimeout", (int)10);
        this.log.info("Configured. Flow Timeout is configured to {} seconds", (Object)this.flowTimeout);
        this.flowPriority = Tools.getIntegerProperty((Dictionary)properties, (String)"flowPriority", (int)10);
        this.log.info("Configured. Flow Priority is configured to {}", (Object)this.flowPriority);
    }

    private boolean isControlPacket(Ethernet eth) {
        short type = eth.getEtherType();
        return type == Ethernet.TYPE_LLDP || type == Ethernet.TYPE_BSN;
    }

    private boolean isIpv6Multicast(Ethernet eth) {
        return eth.getEtherType() == Ethernet.TYPE_IPV6 && eth.isMulticast();
    }

    private Path pickForwardPathIfPossible(Set<Path> paths, PortNumber notToPort) {
        Path lastPath = null;
        Iterator<Path> iterator = paths.iterator();
        while (iterator.hasNext()) {
            Path path;
            lastPath = path = iterator.next();
            if (path.src().port().equals((Object)notToPort)) continue;
            return path;
        }
        return lastPath;
    }

    private void flood(PacketContext context) {
        if (this.topologyService.isBroadcastPoint(this.topologyService.currentTopology(), context.inPacket().receivedFrom())) {
            this.packetOut(context, PortNumber.FLOOD);
        } else {
            context.block();
        }
    }

    private void packetOut(PacketContext context, PortNumber portNumber) {
        context.treatmentBuilder().setOutput(portNumber);
        context.send();
    }

    private void installRule(PacketContext context, PortNumber portNumber) {
        Ethernet inPkt = context.inPacket().parsed();
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        if (this.packetOutOnly || inPkt.getEtherType() == Ethernet.TYPE_ARP) {
            this.packetOut(context, portNumber);
            return;
        }
        if (this.matchDstMacOnly) {
            selectorBuilder.matchEthDst(inPkt.getDestinationMAC());
        } else {
            selectorBuilder.matchInPort(context.inPacket().receivedFrom().port()).matchEthSrc(inPkt.getSourceMAC()).matchEthDst(inPkt.getDestinationMAC());
            if (this.matchVlanId && inPkt.getVlanID() != -1) {
                selectorBuilder.matchVlanId(VlanId.vlanId((short)inPkt.getVlanID()));
            }
            if (this.matchIpv4Address && inPkt.getEtherType() == Ethernet.TYPE_IPV4) {
                IPv4 ipv4Packet = (IPv4)inPkt.getPayload();
                byte ipv4Protocol = ipv4Packet.getProtocol();
                Ip4Prefix matchIp4SrcPrefix = Ip4Prefix.valueOf((int)ipv4Packet.getSourceAddress(), (int)32);
                Ip4Prefix matchIp4DstPrefix = Ip4Prefix.valueOf((int)ipv4Packet.getDestinationAddress(), (int)32);
                selectorBuilder.matchEthType(Ethernet.TYPE_IPV4).matchIPSrc((IpPrefix)matchIp4SrcPrefix).matchIPDst((IpPrefix)matchIp4DstPrefix);
                if (this.matchIpv4Dscp) {
                    byte dscp = ipv4Packet.getDscp();
                    byte ecn = ipv4Packet.getEcn();
                    selectorBuilder.matchIPDscp(dscp).matchIPEcn(ecn);
                }
                if (this.matchTcpUdpPorts && ipv4Protocol == 6) {
                    TCP tcpPacket = (TCP)ipv4Packet.getPayload();
                    selectorBuilder.matchIPProtocol(ipv4Protocol).matchTcpSrc(TpPort.tpPort((int)tcpPacket.getSourcePort())).matchTcpDst(TpPort.tpPort((int)tcpPacket.getDestinationPort()));
                }
                if (this.matchTcpUdpPorts && ipv4Protocol == 17) {
                    UDP udpPacket = (UDP)ipv4Packet.getPayload();
                    selectorBuilder.matchIPProtocol(ipv4Protocol).matchUdpSrc(TpPort.tpPort((int)udpPacket.getSourcePort())).matchUdpDst(TpPort.tpPort((int)udpPacket.getDestinationPort()));
                }
                if (this.matchIcmpFields && ipv4Protocol == 1) {
                    ICMP icmpPacket = (ICMP)ipv4Packet.getPayload();
                    selectorBuilder.matchIPProtocol(ipv4Protocol).matchIcmpType(icmpPacket.getIcmpType()).matchIcmpCode(icmpPacket.getIcmpCode());
                }
            }
            if (this.matchIpv6Address && inPkt.getEtherType() == Ethernet.TYPE_IPV6) {
                IPv6 ipv6Packet = (IPv6)inPkt.getPayload();
                byte ipv6NextHeader = ipv6Packet.getNextHeader();
                Ip6Prefix matchIp6SrcPrefix = Ip6Prefix.valueOf((byte[])ipv6Packet.getSourceAddress(), (int)128);
                Ip6Prefix matchIp6DstPrefix = Ip6Prefix.valueOf((byte[])ipv6Packet.getDestinationAddress(), (int)128);
                selectorBuilder.matchEthType(Ethernet.TYPE_IPV6).matchIPv6Src((IpPrefix)matchIp6SrcPrefix).matchIPv6Dst((IpPrefix)matchIp6DstPrefix);
                if (this.matchIpv6FlowLabel) {
                    selectorBuilder.matchIPv6FlowLabel(ipv6Packet.getFlowLabel());
                }
                if (this.matchTcpUdpPorts && ipv6NextHeader == 6) {
                    TCP tcpPacket = (TCP)ipv6Packet.getPayload();
                    selectorBuilder.matchIPProtocol(ipv6NextHeader).matchTcpSrc(TpPort.tpPort((int)tcpPacket.getSourcePort())).matchTcpDst(TpPort.tpPort((int)tcpPacket.getDestinationPort()));
                }
                if (this.matchTcpUdpPorts && ipv6NextHeader == 17) {
                    UDP udpPacket = (UDP)ipv6Packet.getPayload();
                    selectorBuilder.matchIPProtocol(ipv6NextHeader).matchUdpSrc(TpPort.tpPort((int)udpPacket.getSourcePort())).matchUdpDst(TpPort.tpPort((int)udpPacket.getDestinationPort()));
                }
                if (this.matchIcmpFields && ipv6NextHeader == 58) {
                    ICMP6 icmp6Packet = (ICMP6)ipv6Packet.getPayload();
                    selectorBuilder.matchIPProtocol(ipv6NextHeader).matchIcmpv6Type(icmp6Packet.getIcmpType()).matchIcmpv6Code(icmp6Packet.getIcmpCode());
                }
            }
        }
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().setOutput(portNumber).build();
        ForwardingObjective forwardingObjective = DefaultForwardingObjective.builder().withSelector(selectorBuilder.build()).withTreatment(treatment).withPriority(this.flowPriority).withFlag(ForwardingObjective.Flag.VERSATILE).fromApp(this.appId).makeTemporary(this.flowTimeout).add();
        this.flowObjectiveService.forward(context.inPacket().receivedFrom().deviceId(), forwardingObjective);
        if (this.packetOutOfppTable) {
            this.packetOut(context, PortNumber.TABLE);
        } else {
            this.packetOut(context, portNumber);
        }
    }

    private void fixBlackhole(ConnectPoint egress) {
        Set<FlowEntry> rules = this.getFlowRulesFrom(egress);
        Set<SrcDstPair> pairs = this.findSrcDstPairs(rules);
        HashMap<DeviceId, Set> srcPaths = new HashMap<DeviceId, Set>();
        for (SrcDstPair sd : pairs) {
            Host srcHost = this.hostService.getHost(HostId.hostId((MacAddress)sd.src));
            Host dstHost = this.hostService.getHost(HostId.hostId((MacAddress)sd.dst));
            if (srcHost == null || dstHost == null) continue;
            DeviceId srcId = srcHost.location().deviceId();
            DeviceId dstId = dstHost.location().deviceId();
            this.log.trace("SRC ID is " + srcId + ", DST ID is " + dstId);
            this.cleanFlowRules(sd, egress.deviceId());
            Set shortestPaths = (Set)srcPaths.get(srcId);
            if (shortestPaths == null) {
                shortestPaths = this.topologyService.getPaths(this.topologyService.currentTopology(), egress.deviceId(), srcId);
                srcPaths.put(srcId, shortestPaths);
            }
            this.backTrackBadNodes(shortestPaths, dstId, sd);
        }
    }

    private void backTrackBadNodes(Set<Path> shortestPaths, DeviceId dstId, SrcDstPair sd) {
        block0: for (Path p : shortestPaths) {
            List pathLinks = p.links();
            for (int i = 0; i < pathLinks.size(); ++i) {
                Set pathsFromCurDevice;
                Link curLink = (Link)pathLinks.get(i);
                DeviceId curDevice = curLink.src().deviceId();
                if (i != 0) {
                    this.cleanFlowRules(sd, curDevice);
                }
                if (this.pickForwardPathIfPossible(pathsFromCurDevice = this.topologyService.getPaths(this.topologyService.currentTopology(), curDevice, dstId), curLink.src().port()) != null) continue block0;
                if (i + 1 != pathLinks.size()) continue;
                this.cleanFlowRules(sd, curLink.dst().deviceId());
            }
        }
    }

    private void cleanFlowRules(SrcDstPair pair, DeviceId id) {
        this.log.trace("Searching for flow rules to remove from: " + id);
        this.log.trace("Removing flows w/ SRC=" + pair.src + ", DST=" + pair.dst);
        for (FlowEntry r : this.flowRuleService.getFlowEntries(id)) {
            boolean matchesSrc = false;
            boolean matchesDst = false;
            for (Instruction i : r.treatment().allInstructions()) {
                if (i.type() != Instruction.Type.OUTPUT) continue;
                for (Criterion cr : r.selector().criteria()) {
                    if (cr.type() == Criterion.Type.ETH_DST) {
                        if (!((EthCriterion)cr).mac().equals((Object)pair.dst)) continue;
                        matchesDst = true;
                        continue;
                    }
                    if (cr.type() != Criterion.Type.ETH_SRC || !((EthCriterion)cr).mac().equals((Object)pair.src)) continue;
                    matchesSrc = true;
                }
            }
            if (!matchesDst || !matchesSrc) continue;
            this.log.trace("Removed flow rule from device: " + id);
            this.flowRuleService.removeFlowRules(new FlowRule[]{r});
        }
    }

    private Set<SrcDstPair> findSrcDstPairs(Set<FlowEntry> rules) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (FlowEntry r : rules) {
            MacAddress src = null;
            MacAddress dst = null;
            for (Criterion cr : r.selector().criteria()) {
                if (cr.type() == Criterion.Type.ETH_DST) {
                    dst = ((EthCriterion)cr).mac();
                    continue;
                }
                if (cr.type() != Criterion.Type.ETH_SRC) continue;
                src = ((EthCriterion)cr).mac();
            }
            builder.add((Object)new SrcDstPair(src, dst));
        }
        return builder.build();
    }

    private Set<FlowEntry> getFlowRulesFrom(ConnectPoint egress) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.flowRuleService.getFlowEntries(egress.deviceId()).forEach(r -> {
            if (r.appId() == this.appId.id()) {
                r.treatment().allInstructions().forEach(i -> {
                    if (i.type() == Instruction.Type.OUTPUT && ((Instructions.OutputInstruction)i).port().equals((Object)egress.port())) {
                        builder.add(r);
                    }
                });
            }
        });
        return builder.build();
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindFlowRuleService(FlowRuleService flowRuleService) {
        this.flowRuleService = flowRuleService;
    }

    protected void unbindFlowRuleService(FlowRuleService flowRuleService) {
        if (this.flowRuleService == flowRuleService) {
            this.flowRuleService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    private final class SrcDstPair {
        final MacAddress src;
        final MacAddress dst;

        private SrcDstPair(MacAddress src, MacAddress dst) {
            this.src = src;
            this.dst = dst;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SrcDstPair that = (SrcDstPair)o;
            return Objects.equals(this.src, that.src) && Objects.equals(this.dst, that.dst);
        }

        public int hashCode() {
            return Objects.hash(this.src, this.dst);
        }
    }

    private class InternalTopologyListener
    implements TopologyListener {
        private InternalTopologyListener() {
        }

        public void event(TopologyEvent event) {
            List reasons = event.reasons();
            if (reasons != null) {
                reasons.forEach(re -> {
                    LinkEvent le;
                    if (re instanceof LinkEvent && (le = (LinkEvent)re).type() == LinkEvent.Type.LINK_REMOVED) {
                        ReactiveForwarding.this.fixBlackhole(((Link)le.subject()).src());
                    }
                });
            }
        }
    }

    private class ReactivePacketProcessor
    implements PacketProcessor {
        private ReactivePacketProcessor() {
        }

        public void process(PacketContext context) {
            if (context.isHandled()) {
                return;
            }
            InboundPacket pkt = context.inPacket();
            Ethernet ethPkt = pkt.parsed();
            if (ethPkt == null) {
                return;
            }
            if (ReactiveForwarding.this.isControlPacket(ethPkt)) {
                return;
            }
            if (!ReactiveForwarding.this.ipv6Forwarding && ReactiveForwarding.this.isIpv6Multicast(ethPkt)) {
                return;
            }
            HostId id = HostId.hostId((MacAddress)ethPkt.getDestinationMAC());
            if (id.mac().isLinkLocal()) {
                return;
            }
            if (ReactiveForwarding.this.ignoreIpv4McastPackets && ethPkt.getEtherType() == Ethernet.TYPE_IPV4 && id.mac().isMulticast()) {
                return;
            }
            Host dst = ReactiveForwarding.this.hostService.getHost(id);
            if (dst == null) {
                ReactiveForwarding.this.flood(context);
                return;
            }
            if (pkt.receivedFrom().deviceId().equals((Object)dst.location().deviceId())) {
                if (!context.inPacket().receivedFrom().port().equals((Object)dst.location().port())) {
                    ReactiveForwarding.this.installRule(context, dst.location().port());
                }
                return;
            }
            Set paths = ReactiveForwarding.this.topologyService.getPaths(ReactiveForwarding.this.topologyService.currentTopology(), pkt.receivedFrom().deviceId(), dst.location().deviceId());
            if (paths.isEmpty()) {
                ReactiveForwarding.this.flood(context);
                return;
            }
            Path path = ReactiveForwarding.this.pickForwardPathIfPossible(paths, pkt.receivedFrom().port());
            if (path == null) {
                ReactiveForwarding.this.log.warn("Don't know where to go from here {} for {} -> {}", new Object[]{pkt.receivedFrom(), ethPkt.getSourceMAC(), ethPkt.getDestinationMAC()});
                ReactiveForwarding.this.flood(context);
                return;
            }
            ReactiveForwarding.this.installRule(context, path.src().port());
        }
    }
}

