/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.gangliametrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ganglia.GangliaReporter;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.IOException;
import java.util.Dictionary;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.metrics.MetricsReporter;
import org.onlab.metrics.MetricsService;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.CoreService;
import org.onosproject.gangliametrics.GangliaMetricsReporter;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class DefaultGangliaMetricsReporter
implements GangliaMetricsReporter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final GMetric.UDPAddressingMode GANGLIA_MODE = GMetric.UDPAddressingMode.UNICAST;
    private static final int REPORT_PERIOD = 1;
    private static final TimeUnit REPORT_TIME_UNIT = TimeUnit.MINUTES;
    private static final String DEFAULT_ADDRESS = "localhost";
    private static final int DEFAULT_PORT = 8649;
    private static final int DEFAULT_TTL = 1;
    private static final String DEFAULT_METRIC_NAMES = "default";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MetricsService metricsService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Property(name="monitorAll", boolValue={true}, label="Enable to monitor all of metrics stored in metric registry default is true")
    protected boolean monitorAll = true;
    @Property(name="metricNames", value={"default"}, label="Names of metric to be monitored; default metric names are 'default'")
    protected String metricNames = "default";
    @Property(name="address", value={"localhost"}, label="IP address of ganglia monitoring server; default is localhost")
    protected String address = "localhost";
    @Property(name="port", intValue={8649}, label="Port number of ganglia monitoring server; default is 8649")
    protected int port = 8649;
    @Property(name="ttl", intValue={1}, label="TTL value of ganglia monitoring server; default is 1")
    protected int ttl = 1;
    private GMetric ganglia;
    private GangliaReporter gangliaReporter;

    @Activate
    public void activate() {
        this.cfgService.registerProperties(this.getClass());
        this.coreService.registerApplication("org.onosproject.gangliametrics");
        this.metricsService.registerReporter((MetricsReporter)this);
        this.startReport();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.stopReport();
        this.metricsService.unregisterReporter((MetricsReporter)this);
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        this.readComponentConfiguration(context);
        this.stopReport();
        this.startReport();
    }

    public void startReport() {
        this.configGMetric();
        this.gangliaReporter = this.buildReporter(this.ganglia);
        try {
            this.gangliaReporter.start(1L, REPORT_TIME_UNIT);
        }
        catch (Exception e) {
            this.log.error("Errors during reporting to ganglia, msg: {}" + e.getMessage());
        }
        this.log.info("Start to report metrics to ganglia server.");
    }

    public void stopReport() {
        this.gangliaReporter.stop();
        this.ganglia = null;
        this.gangliaReporter = null;
        this.log.info("Stop reporting metrics to ganglia server.");
    }

    public void restartReport() {
        this.stopReport();
        this.startReport();
    }

    public void notifyMetricsChange() {
        this.gangliaReporter.stop();
        this.gangliaReporter = this.buildReporter(this.ganglia);
        try {
            this.gangliaReporter.start(1L, REPORT_TIME_UNIT);
        }
        catch (Exception e) {
            this.log.error("Errors during reporting to ganglia, msg: {}" + e.getMessage());
        }
        this.log.info("Metric registry has been changed, apply changes.");
    }

    protected MetricRegistry filter(MetricRegistry metricRegistry) {
        if (!this.monitorAll) {
            MetricRegistry filtered = new MetricRegistry();
            metricRegistry.getNames().stream().filter((? super T name) -> this.containsName((String)name, this.metricNames)).forEach(name -> filtered.register(name, (Metric)metricRegistry.getMetrics().get(name)));
            return filtered;
        }
        return metricRegistry;
    }

    protected boolean containsName(String full, String prefixes) {
        String[] prefixArray;
        for (String prefix : prefixArray = StringUtils.split((String)prefixes, (String)",")) {
            if (!StringUtils.startsWith((String)full, (String)StringUtils.trimToEmpty((String)prefix))) continue;
            return true;
        }
        return false;
    }

    private void readComponentConfiguration(ComponentContext context) {
        Dictionary properties = context.getProperties();
        String addressStr = Tools.get((Dictionary)properties, (String)"address");
        this.address = addressStr != null ? addressStr : DEFAULT_ADDRESS;
        this.log.info("Configured. Ganglia server address is {}", (Object)this.address);
        String metricNameStr = Tools.get((Dictionary)properties, (String)"metricNames");
        this.metricNames = metricNameStr != null ? metricNameStr : DEFAULT_METRIC_NAMES;
        this.log.info("Configured. Metric name is {}", (Object)this.metricNames);
        Integer portConfigured = Tools.getIntegerProperty((Dictionary)properties, (String)"port");
        if (portConfigured == null) {
            this.port = 8649;
            this.log.info("Ganglia port is not configured, default value is {}", (Object)this.port);
        } else {
            this.port = portConfigured;
            this.log.info("Configured. Ganglia port is configured to {}", (Object)this.port);
        }
        Integer ttlConfigured = Tools.getIntegerProperty((Dictionary)properties, (String)"ttl");
        if (ttlConfigured == null) {
            this.ttl = 1;
            this.log.info("Ganglia TTL is not configured, default value is {}", (Object)this.ttl);
        } else {
            this.ttl = ttlConfigured;
            this.log.info("Configured. Ganglia TTL is configured to {}", (Object)this.ttl);
        }
        Boolean monitorAllEnabled = Tools.isPropertyEnabled((Dictionary)properties, (String)"monitorAll");
        if (monitorAllEnabled == null) {
            this.log.info("Monitor all metrics is not configured, using current value of {}", (Object)this.monitorAll);
        } else {
            this.monitorAll = monitorAllEnabled;
            this.log.info("Configured. Monitor all metrics is {}", (Object)(this.monitorAll ? "enabled" : "disabled"));
        }
    }

    private void configGMetric() {
        try {
            this.ganglia = new GMetric(this.address, this.port, GANGLIA_MODE, this.ttl);
        }
        catch (IOException e) {
            this.log.error("Fail to connect to given ganglia server!");
        }
    }

    private GangliaReporter buildReporter(GMetric gMetric) {
        MetricRegistry mr = this.metricsService.getMetricRegistry();
        return GangliaReporter.forRegistry((MetricRegistry)this.filter(mr)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(gMetric);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    protected void unbindMetricsService(MetricsService metricsService) {
        if (this.metricsService == metricsService) {
            this.metricsService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }
}

