/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.graphitemetrics;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.graphitemetrics.DefaultGraphiteMetricsReporter;

public class GraphiteMetricsReporterTest {
    private DefaultGraphiteMetricsReporter gmr;
    private static final String METRIC_NAME1 = "consistentMap.onos-app-ids.putIfAbsent";
    private static final String METRIC_NAME2 = "consistentMap.onos-hosts.entrySet";
    private static final String METRIC_NAME3 = "clusterCommunication.endpoint.*";
    private static final String METRIC_NAME4 = "atomicCounter.onos-app-id-counter.*";
    private static final String PREFIXES1 = "consistentMap";
    private static final String PREFIXES2 = "topology";
    private static final String PREFIXES3 = "consistentMap.onos-app-ids";
    private static final String PREFIXES4 = "consistentMap, clusterCommunication, atomicCounter";

    @Before
    public void setUp() {
        this.gmr = new DefaultGraphiteMetricsReporter();
    }

    public void tearDown() {
        this.gmr.deactivate();
    }

    @Test
    public void testContainsName() {
        Assert.assertTrue((boolean)this.gmr.containsName(METRIC_NAME1, PREFIXES1));
        Assert.assertTrue((boolean)this.gmr.containsName(METRIC_NAME1, PREFIXES3));
        Assert.assertTrue((boolean)this.gmr.containsName(METRIC_NAME1, PREFIXES4));
        Assert.assertTrue((boolean)this.gmr.containsName(METRIC_NAME2, PREFIXES4));
        Assert.assertTrue((boolean)this.gmr.containsName(METRIC_NAME3, PREFIXES4));
        Assert.assertTrue((boolean)this.gmr.containsName(METRIC_NAME4, PREFIXES4));
        Assert.assertFalse((boolean)this.gmr.containsName(METRIC_NAME1, PREFIXES2));
    }

    @Test
    public void testFilter() {
        MetricRegistry full = new MetricRegistry();
        full.meter(METRIC_NAME1);
        full.meter(METRIC_NAME2);
        full.meter(METRIC_NAME3);
        full.meter(METRIC_NAME4);
        this.gmr.monitorAll = true;
        MetricRegistry filtered = this.gmr.filter(full);
        Assert.assertTrue((boolean)filtered.getNames().containsAll((Collection<?>)ImmutableSet.of((Object)METRIC_NAME1, (Object)METRIC_NAME2, (Object)METRIC_NAME3, (Object)METRIC_NAME4)));
        this.gmr.monitorAll = false;
        this.gmr.metricNames = PREFIXES1;
        filtered = this.gmr.filter(full);
        Assert.assertTrue((boolean)filtered.getNames().containsAll((Collection<?>)ImmutableSet.of((Object)METRIC_NAME1, (Object)METRIC_NAME2)));
        Assert.assertFalse((boolean)filtered.getNames().containsAll((Collection<?>)ImmutableSet.of((Object)METRIC_NAME3, (Object)METRIC_NAME4)));
        this.gmr.metricNames = PREFIXES2;
        filtered = this.gmr.filter(full);
        Assert.assertFalse((boolean)filtered.getNames().containsAll((Collection<?>)ImmutableSet.of((Object)METRIC_NAME1)));
        this.gmr.metricNames = PREFIXES3;
        filtered = this.gmr.filter(full);
        Assert.assertTrue((boolean)filtered.getNames().containsAll((Collection<?>)ImmutableSet.of((Object)METRIC_NAME1)));
        Assert.assertFalse((boolean)filtered.getNames().containsAll((Collection<?>)ImmutableSet.of((Object)METRIC_NAME2)));
        this.gmr.metricNames = PREFIXES4;
        filtered = this.gmr.filter(full);
        Assert.assertTrue((boolean)filtered.getNames().containsAll((Collection<?>)ImmutableSet.of((Object)METRIC_NAME1, (Object)METRIC_NAME2, (Object)METRIC_NAME3, (Object)METRIC_NAME4)));
    }
}

