/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.graphitemetrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import java.net.InetSocketAddress;
import java.util.Dictionary;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.metrics.MetricsReporter;
import org.onlab.metrics.MetricsService;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.CoreService;
import org.onosproject.graphitemetrics.GraphiteMetricsReporter;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class DefaultGraphiteMetricsReporter
implements GraphiteMetricsReporter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final TimeUnit REPORT_TIME_UNIT = TimeUnit.MINUTES;
    private static final int DEFAULT_REPORT_PERIOD = 1;
    private static final String DEFAULT_METRIC_NAMES = "default";
    private static final String DEFAULT_ADDRESS = "localhost";
    private static final int DEFAULT_PORT = 2003;
    private static final String DEFAULT_METRIC_NAME_PREFIX = "onos";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MetricsService metricsService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Property(name="monitorAll", boolValue={true}, label="Enable to monitor all of metrics stored in metric registry default is true")
    protected boolean monitorAll = true;
    @Property(name="metricNames", value={"default"}, label="Names of metric to be monitored; default metric names are 'default'")
    protected String metricNames = "default";
    @Property(name="address", value={"localhost"}, label="IP address of graphite monitoring server; default is localhost")
    protected String address = "localhost";
    @Property(name="port", intValue={2003}, label="Port number of graphite monitoring server; default is 2003")
    protected int port = 2003;
    @Property(name="reportPeriod", intValue={1}, label="Reporting period of graphite monitoring server; default is 1")
    protected int reportPeriod = 1;
    @Property(name="metricNamePrefix", value={"onos"}, label="Prefix of metric name for graphite back-end server; default is 'onos'")
    protected String metricNamePrefix = "onos";
    private Graphite graphite;
    private GraphiteReporter graphiteReporter;

    @Activate
    public void activate() {
        this.cfgService.registerProperties(this.getClass());
        this.coreService.registerApplication("org.onosproject.graphitemetrics");
        this.metricsService.registerReporter((MetricsReporter)this);
        this.startReport();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.unregisterProperties(this.getClass(), false);
        this.stopReport();
        this.metricsService.unregisterReporter((MetricsReporter)this);
        this.log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        this.readComponentConfiguration(context);
        this.stopReport();
        this.startReport();
    }

    public void startReport() {
        this.configGraphite();
        this.graphiteReporter = this.buildReporter(this.graphite);
        try {
            this.graphiteReporter.start((long)this.reportPeriod, REPORT_TIME_UNIT);
        }
        catch (Exception e) {
            this.log.error("Errors during reporting to graphite, msg: {}" + e.getMessage());
        }
        this.log.info("Start to report metrics to graphite server.");
    }

    public void stopReport() {
        this.graphiteReporter.stop();
        this.graphite = null;
        this.graphiteReporter = null;
        this.log.info("Stop reporting metrics to graphite server.");
    }

    public void restartReport() {
        this.stopReport();
        this.startReport();
    }

    public void notifyMetricsChange() {
        this.graphiteReporter.stop();
        this.graphiteReporter = this.buildReporter(this.graphite);
        try {
            this.graphiteReporter.start((long)this.reportPeriod, REPORT_TIME_UNIT);
        }
        catch (Exception e) {
            this.log.error("Errors during reporting to graphite, msg: {}" + e.getMessage());
        }
        this.log.info("Metric registry has been changed, apply changes.");
    }

    protected MetricRegistry filter(MetricRegistry metricRegistry) {
        if (!this.monitorAll) {
            MetricRegistry filtered = new MetricRegistry();
            metricRegistry.getNames().stream().filter((? super T name) -> this.containsName((String)name, this.metricNames)).forEach(name -> filtered.register(name, (Metric)metricRegistry.getMetrics().get(name)));
            return filtered;
        }
        return metricRegistry;
    }

    protected boolean containsName(String full, String prefixes) {
        String[] prefixArray;
        for (String prefix : prefixArray = StringUtils.split((String)prefixes, (String)",")) {
            if (!StringUtils.startsWith((String)full, (String)StringUtils.trimToEmpty((String)prefix))) continue;
            return true;
        }
        return false;
    }

    private void readComponentConfiguration(ComponentContext context) {
        Dictionary properties = context.getProperties();
        Boolean newMonitorAll = Tools.isPropertyEnabled((Dictionary)properties, (String)"monitorAll");
        if (newMonitorAll == null) {
            this.log.info("Monitor all metrics is not configured, using current value of {}", (Object)this.monitorAll);
        } else {
            this.monitorAll = newMonitorAll;
            this.log.info("Configured. Monitor all metrics is {}, ", (Object)(this.monitorAll ? "enabled" : "disabled"));
        }
        String newMetricNames = Tools.get((Dictionary)properties, (String)"metricNames");
        this.metricNames = newMetricNames != null ? newMetricNames : DEFAULT_METRIC_NAMES;
        this.log.info("Configured. Metric name is {}", (Object)this.metricNames);
        String newAddress = Tools.get((Dictionary)properties, (String)"address");
        this.address = newAddress != null ? newAddress : DEFAULT_ADDRESS;
        this.log.info("Configured. Graphite monitoring server address is {}", (Object)this.address);
        Integer newPort = Tools.getIntegerProperty((Dictionary)properties, (String)"port");
        if (newPort == null) {
            this.port = 2003;
            this.log.info("Graphite port is not configured, default value is {}", (Object)this.port);
        } else {
            this.port = newPort;
            this.log.info("Configured. Graphite port is configured to {}", (Object)this.port);
        }
        Integer newReportPeriod = Tools.getIntegerProperty((Dictionary)properties, (String)"reportPeriod");
        if (newReportPeriod == null) {
            this.reportPeriod = 1;
            this.log.info("Report period of graphite server is not configured, default value is {}", (Object)this.reportPeriod);
        } else {
            this.reportPeriod = newReportPeriod;
            this.log.info("Configured. Report period of graphite server is configured to {}", (Object)this.reportPeriod);
        }
        String newMetricNamePrefix = Tools.get((Dictionary)properties, (String)"metricNamePrefix");
        this.metricNamePrefix = newMetricNamePrefix != null ? newMetricNamePrefix : DEFAULT_METRIC_NAME_PREFIX;
    }

    private void configGraphite() {
        try {
            this.graphite = new Graphite(new InetSocketAddress(this.address, this.port));
        }
        catch (Exception e) {
            this.log.error("Fail to connect to given graphite server! : " + e.getMessage());
        }
    }

    private GraphiteReporter buildReporter(Graphite graphiteCfg) {
        MetricRegistry metricRegistry = this.metricsService.getMetricRegistry();
        return GraphiteReporter.forRegistry((MetricRegistry)this.filter(metricRegistry)).prefixedWith(this.metricNamePrefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(graphiteCfg);
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    protected void unbindMetricsService(MetricsService metricsService) {
        if (this.metricsService == metricsService) {
            this.metricsService = null;
        }
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }
}

