/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mcast.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.mcast.api.McastRoute;
import org.onosproject.mcast.api.MulticastRouteService;
import org.onosproject.mcast.cli.McastGroupCompleter;

@Service
@Command(scope="onos", name="mcast-host-show", description="Displays the source, multicast group flows")
public class McastShowHostCommand
extends AbstractShellCommand {
    private static final String FORMAT_MAPPING = "origin=%s, group=%s, source IP=%s, sources=%s, sinks=%s\n";
    private StringBuilder routesBuilder = new StringBuilder();
    private ArrayNode routesNode = this.mapper().createArrayNode();
    @Option(name="-gAddr", aliases={"--groupAddress"}, description="IP Address of the multicast group", valueToShowInHelp="224.0.0.0", required=false, multiValued=false)
    @Completion(value=McastGroupCompleter.class)
    String gAddr = null;

    protected void doExecute() {
        MulticastRouteService mcastService = (MulticastRouteService)McastShowHostCommand.get(MulticastRouteService.class);
        Set routes = mcastService.getRoutes();
        if (!Strings.isNullOrEmpty((String)this.gAddr)) {
            IpAddress mcastGroup = IpAddress.valueOf((String)this.gAddr);
            McastRoute mcastRoute2 = routes.stream().filter(route -> route.group().equals((Object)mcastGroup)).findAny().orElse(null);
            if (mcastRoute2 != null) {
                this.prepareResult(mcastService, mcastRoute2);
            }
        } else {
            routes.stream().filter(mcastRoute -> mcastRoute.group().isIp4()).sorted(Comparator.comparing(McastRoute::group)).forEach(route -> this.prepareResult(mcastService, (McastRoute)route));
            routes.stream().filter(mcastRoute -> mcastRoute.group().isIp6()).sorted(Comparator.comparing(McastRoute::group)).forEach(route -> this.prepareResult(mcastService, (McastRoute)route));
        }
        if (this.outputJson()) {
            this.print("%s", new Object[]{this.routesNode});
        } else {
            this.print("%s", new Object[]{this.routesBuilder.toString()});
        }
    }

    private void prepareResult(MulticastRouteService mcastService, McastRoute route) {
        if (this.outputJson()) {
            ObjectNode routeNode = this.jsonForEntity(route, McastRoute.class);
            this.routesNode.add((JsonNode)routeNode);
        } else {
            Map sinks = mcastService.routeData(route).sinks();
            Map sources = mcastService.routeData(route).sources();
            String srcIp = "*";
            if (route.source().isPresent()) {
                srcIp = ((IpAddress)route.source().get()).toString();
            }
            this.routesBuilder.append(String.format(FORMAT_MAPPING, route.type(), route.group(), srcIp, sources, sinks));
        }
    }
}

