/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mcast.cli;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.HostIdCompleter;
import org.onosproject.mcast.api.McastRoute;
import org.onosproject.mcast.api.MulticastRouteService;
import org.onosproject.mcast.cli.McastGroupCompleter;
import org.onosproject.net.HostId;

@Service
@Command(scope="onos", name="mcast-host-join", description="Installs a source, multicast group flow")
public class McastHostJoinCommand
extends AbstractShellCommand {
    private static final String FORMAT_MAPPING = "Added the mcast route: origin=%s, group=%s, source=%s";
    @Option(name="-sAddr", aliases={"--sourceAddress"}, description="IP Address of the multicast source. '*' can be used for any source (*, G) entry", valueToShowInHelp="1.1.1.1", required=true, multiValued=false)
    String sAddr = null;
    @Option(name="-gAddr", aliases={"--groupAddress"}, description="IP Address of the multicast group", valueToShowInHelp="224.0.0.0", required=true, multiValued=false)
    @Completion(value=McastGroupCompleter.class)
    String gAddr = null;
    @Option(name="-srcs", aliases={"--sources"}, description="Host sink format: MAC/VLAN", valueToShowInHelp="00:00:00:00:00:00/None", multiValued=true)
    @Completion(value=HostIdCompleter.class)
    String[] sources = null;
    @Option(name="-sinks", aliases={"--hostsinks"}, description="Host sink format: MAC/VLAN", valueToShowInHelp="00:00:00:00:00:00/None", multiValued=true)
    @Completion(value=HostIdCompleter.class)
    String[] sinks = null;

    protected void doExecute() {
        MulticastRouteService mcastRouteManager = (MulticastRouteService)McastHostJoinCommand.get(MulticastRouteService.class);
        IpAddress sAddrIp = null;
        if (!this.sAddr.equals("*")) {
            sAddrIp = IpAddress.valueOf((String)this.sAddr);
        }
        McastRoute mRoute = new McastRoute(sAddrIp, IpAddress.valueOf((String)this.gAddr), McastRoute.Type.STATIC);
        mcastRouteManager.add(mRoute);
        if (this.sources != null) {
            for (String hostId : this.sources) {
                mcastRouteManager.addSource(mRoute, HostId.hostId((String)hostId));
            }
        }
        if (this.sinks != null) {
            for (String hostId : this.sinks) {
                mcastRouteManager.addSink(mRoute, HostId.hostId((String)hostId));
            }
        }
        this.printMcastRoute(mRoute);
    }

    private void printMcastRoute(McastRoute mcastRoute) {
        this.print(FORMAT_MAPPING, new Object[]{mcastRoute.type(), mcastRoute.group(), mcastRoute.source().isPresent() ? mcastRoute.source().get() : "*"});
    }
}

