/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mcast.cli;

import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.HostIdCompleter;
import org.onosproject.mcast.api.McastRoute;
import org.onosproject.mcast.api.MulticastRouteService;
import org.onosproject.mcast.cli.McastGroupCompleter;
import org.onosproject.net.HostId;

@Service
@Command(scope="onos", name="mcast-source-delete", description="Delete a multicast route flow")
public class McastSourceDeleteCommand
extends AbstractShellCommand {
    private static final String D_FORMAT_MAPPING = "Deleted the mcast route: origin=%s, group=%s, source=%s";
    private static final String U_FORMAT_MAPPING = "Updated the mcast route: origin=%s, group=%s, source=%s";
    @Option(name="-sAddr", aliases={"--sourceAddress"}, description="IP Address of the multicast source. '*' can be used for any source (*, G) entry", valueToShowInHelp="1.1.1.1", required=true, multiValued=false)
    String sAddr = null;
    @Option(name="-gAddr", aliases={"--groupAddress"}, description="IP Address of the multicast group", valueToShowInHelp="224.0.0.0", required=true, multiValued=false)
    @Completion(value=McastGroupCompleter.class)
    String gAddr = null;
    @Option(name="-src", aliases={"--connectPoint"}, description="Host sink format: MAC/VLAN", valueToShowInHelp="00:00:00:00:00:00/None", multiValued=true)
    @Completion(value=HostIdCompleter.class)
    String[] sourceList = null;

    protected void doExecute() {
        MulticastRouteService mcastRouteManager = (MulticastRouteService)McastSourceDeleteCommand.get(MulticastRouteService.class);
        if ("*".equals(this.sAddr) && "*".equals(this.gAddr)) {
            mcastRouteManager.getRoutes().forEach(arg_0 -> ((MulticastRouteService)mcastRouteManager).remove(arg_0));
            return;
        }
        IpAddress sAddrIp = null;
        if (!this.sAddr.equals("*")) {
            sAddrIp = IpAddress.valueOf((String)this.sAddr);
        }
        McastRoute mRoute = new McastRoute(sAddrIp, IpAddress.valueOf((String)this.gAddr), McastRoute.Type.STATIC);
        if (this.sourceList == null) {
            mcastRouteManager.remove(mRoute);
            this.printMcastRoute(D_FORMAT_MAPPING, mRoute);
            return;
        }
        if (!mcastRouteManager.getRoutes().contains(mRoute)) {
            this.print("Route is not present, store it first", new Object[0]);
            return;
        }
        for (String hostId : this.sourceList) {
            mcastRouteManager.removeSource(mRoute, HostId.hostId((String)hostId));
        }
        this.printMcastRoute(U_FORMAT_MAPPING, mRoute);
    }

    private void printMcastRoute(String format, McastRoute mcastRoute) {
        this.print(format, new Object[]{mcastRoute.type(), mcastRoute.group(), mcastRoute.source().isPresent() ? mcastRoute.source().get() : "*"});
    }
}

