/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mcast.cli;

import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.mcast.api.McastRoute;
import org.onosproject.mcast.api.MulticastRouteService;

@Service
@Command(scope="onos", name="mcast-host-routes", description="Lists routes in the mcast route store")
public class McastRoutesListCommand
extends AbstractShellCommand {
    private static final String FORMAT_TOTAL = "   Total: %d";
    private static final String FORMAT_ROUTE = "%-1s   %-18s %-15s %s   %s    %s";
    private static final String FORMAT_ROUTE6 = "%-1s   %-40s %-36s %s   %s    %s";
    private static final String FORMAT_TABLE = "Table: %s";
    private static final String GROUP = "Group";
    private static final String SOURCE = "Source";
    private static final String ORIGIN = "Origin";
    private static final String SOURCES = "Sources";
    private static final String SINKS = "Sinks";

    protected void doExecute() {
        MulticastRouteService mcastService = (MulticastRouteService)McastRoutesListCommand.get(MulticastRouteService.class);
        Set routes = mcastService.getRoutes();
        Set ipv4Routes = routes.stream().filter(mcastRoute -> mcastRoute.group().isIp4()).collect(Collectors.toSet());
        Set ipv6Routes = routes.stream().filter(mcastRoute -> mcastRoute.group().isIp6()).collect(Collectors.toSet());
        this.print(FORMAT_TABLE, new Object[]{"ipv4"});
        this.print(FORMAT_ROUTE, new Object[]{"", GROUP, SOURCE, ORIGIN, SOURCES, SINKS});
        ipv4Routes.stream().sorted(Comparator.comparing(McastRoute::group)).forEach(route -> {
            Set sources = mcastService.sources(route);
            Set sinks = mcastService.sinks(route);
            Optional sourceIp = route.source();
            String src = "*      ";
            if (sourceIp.isPresent()) {
                src = ((IpAddress)sourceIp.get()).toString();
            }
            this.print(FORMAT_ROUTE, new Object[]{"", route.group(), src, route.type(), sources.size(), "       " + sinks.size()});
        });
        this.print(FORMAT_TOTAL, new Object[]{ipv4Routes.size()});
        this.print("", new Object[0]);
        this.print(FORMAT_TABLE, new Object[]{"ipv6"});
        this.print(FORMAT_ROUTE6, new Object[]{"", GROUP, SOURCE, ORIGIN, SOURCES, SINKS});
        ipv6Routes.stream().sorted(Comparator.comparing(McastRoute::group)).forEach(route -> {
            Set sources = mcastService.sources(route);
            Set sinks = mcastService.sinks(route);
            Optional sourceIp = route.source();
            String src = "*      ";
            if (sourceIp.isPresent()) {
                src = ((IpAddress)sourceIp.get()).toString();
            }
            this.print(FORMAT_ROUTE6, new Object[]{"", route.group(), src, route.type(), sources.size(), "       " + sinks.size()});
        });
        this.print(FORMAT_TOTAL, new Object[]{ipv6Routes.size()});
        this.print("", new Object[0]);
    }
}

