/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.metrics.intent.cli;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.metrics.intent.IntentMetricsService;
import org.onosproject.net.intent.IntentEvent;

@Command(scope="onos", name="intents-events", description="Lists the last intent events")
public class IntentEventsListCommand
extends AbstractShellCommand {
    private static final String FORMAT_EVENT = "Event=%s";

    protected void execute() {
        IntentMetricsService service = (IntentMetricsService)IntentEventsListCommand.get(IntentMetricsService.class);
        if (this.outputJson()) {
            this.print("%s", new Object[]{this.json(service.getEvents())});
        } else {
            for (IntentEvent event : service.getEvents()) {
                this.print(FORMAT_EVENT, new Object[]{event});
                this.print("", new Object[0]);
            }
        }
    }

    private JsonNode json(List<IntentEvent> intentEvents) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode result = mapper.createArrayNode();
        for (IntentEvent event : intentEvents) {
            result.add((JsonNode)this.json(mapper, event));
        }
        return result;
    }

    private ObjectNode json(ObjectMapper mapper, IntentEvent intentEvent) {
        ObjectNode result = mapper.createObjectNode();
        result.put("time", intentEvent.time()).put("type", ((IntentEvent.Type)intentEvent.type()).toString()).put("event", intentEvent.toString());
        return result;
    }
}

