/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.newoptical.cli;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.LinkKey;
import org.onosproject.newoptical.OpticalConnectivity;
import org.onosproject.newoptical.api.OpticalPathService;

@Command(scope="onos", name="list-optical-connectivity", description="List optical domain connectivity")
public class ListOpticalConnectivityCommand
extends AbstractShellCommand {
    protected void execute() {
        OpticalPathService opticalPathService = (OpticalPathService)ListOpticalConnectivityCommand.get(OpticalPathService.class);
        Collection<OpticalConnectivity> connectivities = opticalPathService.listConnectivity();
        for (OpticalConnectivity connectivity : connectivities) {
            this.print("Optical connectivity ID: %s", new Object[]{connectivity.id().id()});
            this.print(" links: %s", new Object[]{connectivity.links().stream().map(LinkKey::linkKey).map(lk -> lk.src() + "-" + lk.dst()).collect(Collectors.joining(", "))});
            this.print(" Bandwidth: %s, Latency: %s", new Object[]{connectivity.bandwidth(), connectivity.latency()});
            this.print(" Intent Keys: %s", new Object[]{opticalPathService.listIntents(connectivity.id())});
        }
    }
}

