/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.newoptical;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.onlab.util.Bandwidth;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.OpticalCircuitIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;

@Beta
public class PacketLinkRealizedByOptical {
    private final ConnectPoint src;
    private final ConnectPoint dst;
    private final Bandwidth bandwidth;
    private final Key realizingIntentKey;

    public PacketLinkRealizedByOptical(ConnectPoint src, ConnectPoint dst, Key realizingIntentKey, Bandwidth bandwidth) {
        this.src = src;
        this.dst = dst;
        this.realizingIntentKey = realizingIntentKey;
        this.bandwidth = bandwidth;
    }

    public static PacketLinkRealizedByOptical create(ConnectPoint src, ConnectPoint dst, OpticalCircuitIntent intent) {
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)dst);
        Preconditions.checkNotNull((Object)intent);
        long rate = intent.getSignalType().bitRate();
        return new PacketLinkRealizedByOptical(src, dst, intent.key(), Bandwidth.bps((long)rate));
    }

    public static PacketLinkRealizedByOptical create(ConnectPoint src, ConnectPoint dst, OpticalConnectivityIntent intent) {
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)dst);
        Preconditions.checkNotNull((Object)intent);
        long rate = intent.getSignalType().bitRate();
        return new PacketLinkRealizedByOptical(src, dst, intent.key(), Bandwidth.bps((long)rate));
    }

    public ConnectPoint src() {
        return this.src;
    }

    public ConnectPoint dst() {
        return this.dst;
    }

    public Bandwidth bandwidth() {
        return this.bandwidth;
    }

    public Key realizingIntentKey() {
        return this.realizingIntentKey;
    }

    public boolean isBetween(ConnectPoint src, ConnectPoint dst) {
        return this.src.equals((Object)src) && this.dst.equals((Object)dst);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PacketLinkRealizedByOptical that = (PacketLinkRealizedByOptical)o;
        if (!this.src.equals((Object)that.src)) {
            return false;
        }
        if (!this.dst.equals((Object)that.dst)) {
            return false;
        }
        if (!this.bandwidth.equals(that.bandwidth)) {
            return false;
        }
        return this.realizingIntentKey.equals((Object)that.realizingIntentKey);
    }

    public int hashCode() {
        int result = this.src.hashCode();
        result = 31 * result + this.dst.hashCode();
        result = 31 * result + this.bandwidth.hashCode();
        result = 31 * result + this.realizingIntentKey.hashCode();
        return result;
    }
}

