/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.newoptical;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.graph.DefaultEdgeWeigher;
import org.onlab.graph.ScalarWeight;
import org.onlab.graph.Weight;
import org.onlab.util.Bandwidth;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.event.ListenerService;
import org.onosproject.event.ListenerTracker;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.Path;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BandwidthCapacity;
import org.onosproject.net.config.basics.BasicLinkConfig;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.OpticalCircuitIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkListener;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.optical.OchPort;
import org.onosproject.net.optical.OduCltPort;
import org.onosproject.net.optical.device.OpticalDeviceServiceView;
import org.onosproject.net.resource.ContinuousResource;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.Resources;
import org.onosproject.net.topology.LinkWeigher;
import org.onosproject.net.topology.TopologyEdge;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.net.topology.TopologyVertex;
import org.onosproject.newoptical.OpticalConnectivity;
import org.onosproject.newoptical.PacketLinkRealizedByOptical;
import org.onosproject.newoptical.api.OpticalConnectivityId;
import org.onosproject.newoptical.api.OpticalPathEvent;
import org.onosproject.newoptical.api.OpticalPathListener;
import org.onosproject.newoptical.api.OpticalPathService;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Service
@Component(immediate=true)
public class OpticalPathProvisioner
extends AbstractListenerManager<OpticalPathEvent, OpticalPathListener>
implements OpticalPathService {
    protected static final Logger log = LoggerFactory.getLogger(OpticalPathProvisioner.class);
    private static final Bandwidth NO_BW_REQUIREMENT = Bandwidth.bps((long)0L);
    private static final String OPTICAL_CONNECTIVITY_ID_COUNTER = "optical-connectivity-id";
    private static final String LINKPATH_MAP_NAME = "newoptical-linkpath";
    private static final String CONNECTIVITY_MAP_NAME = "newoptical-connectivity";
    private static final String CROSSCONNECTLINK_SET_NAME = "newoptical-crossconnectlink";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService networkConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceService resourceService;
    private static final String MAX_PATHS = "maxPaths";
    private static final int DEFAULT_MAX_PATHS = 10;
    @Property(name="maxPaths", intValue={10}, label="Maximum number of paths to consider for path provisioning")
    private int maxPaths = 10;
    private ApplicationId appId;
    private AtomicCounter idCounter;
    private ListenerTracker listeners;
    private InternalStoreListener storeListener = new InternalStoreListener();
    private ConsistentMap<PacketLinkRealizedByOptical, OpticalConnectivity> linkPathMap;
    private ConsistentMap<OpticalConnectivityId, OpticalConnectivity> connectivityMap;
    private DistributedSet<Link> usedCrossConnectLinkSet;
    private static final KryoNamespace.Builder LINKPATH_SERIALIZER = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{PacketLinkRealizedByOptical.class}).register(new Class[]{OpticalConnectivityId.class}).register(new Class[]{OpticalConnectivity.class});
    private static final KryoNamespace.Builder CONNECTIVITY_SERIALIZER = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{PacketLinkRealizedByOptical.class}).register(new Class[]{OpticalConnectivityId.class}).register(new Class[]{OpticalConnectivity.class});
    private static final KryoNamespace.Builder CROSSCONNECTLINKS_SERIALIZER = KryoNamespace.newBuilder().register(KryoNamespaces.API);

    @Activate
    protected void activate(ComponentContext context) {
        this.deviceService = OpticalDeviceServiceView.opticalView((DeviceService)this.deviceService);
        this.appId = this.coreService.registerApplication("org.onosproject.newoptical");
        this.idCounter = this.storageService.getAtomicCounter(OPTICAL_CONNECTIVITY_ID_COUNTER);
        this.linkPathMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)LINKPATH_SERIALIZER.build()))).withName(LINKPATH_MAP_NAME)).withApplicationId(this.appId)).build();
        this.connectivityMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)CONNECTIVITY_SERIALIZER.build()))).withName(CONNECTIVITY_MAP_NAME)).withApplicationId(this.appId)).build();
        this.usedCrossConnectLinkSet = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withSerializer(Serializer.using((KryoNamespace)CROSSCONNECTLINKS_SERIALIZER.build()))).withName(CROSSCONNECTLINK_SET_NAME)).withApplicationId(this.appId)).build()).asDistributedSet();
        this.eventDispatcher.addSink(OpticalPathEvent.class, (EventSink)this.listenerRegistry);
        this.listeners = new ListenerTracker();
        this.listeners.addListener((ListenerService)this.linkService, (EventListener)new InternalLinkListener()).addListener((ListenerService)this.intentService, (EventListener)new InternalIntentListener());
        this.linkPathMap.addListener((MapEventListener)this.storeListener);
        this.readComponentConfiguration(context);
        log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.linkPathMap.removeListener((MapEventListener)this.storeListener);
        this.listeners.removeListeners();
        this.eventDispatcher.removeSink(OpticalPathEvent.class);
        log.info("Stopped");
    }

    @Modified
    public void modified(ComponentContext context) {
        this.readComponentConfiguration(context);
    }

    private void readComponentConfiguration(ComponentContext context) {
        Dictionary properties = context.getProperties();
        this.maxPaths = Tools.getIntegerProperty((Dictionary)properties, (String)MAX_PATHS, (int)10);
        log.info("Configured. Maximum paths to consider is configured to {}", (Object)this.maxPaths);
    }

    @Override
    public Collection<OpticalConnectivity> listConnectivity() {
        return (Collection)this.connectivityMap.values().stream().map(Versioned::value).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Set<Key> listIntents(OpticalConnectivityId id) {
        return this.linkPathMap.entrySet().stream().filter(ent -> id.equals((Object)((OpticalConnectivity)((Versioned)ent.getValue()).value()).id())).map(Map.Entry::getKey).map(PacketLinkRealizedByOptical::realizingIntentKey).collect(Collectors.toSet());
    }

    @Override
    public OpticalConnectivityId setupConnectivity(ConnectPoint ingress, ConnectPoint egress, Bandwidth bandwidth, Duration latency) {
        Preconditions.checkNotNull((Object)ingress);
        Preconditions.checkNotNull((Object)egress);
        log.info("setupConnectivity({}, {}, {}, {})", new Object[]{ingress, egress, bandwidth, latency});
        Bandwidth bw = bandwidth == null ? NO_BW_REQUIREMENT : bandwidth;
        Stream paths = this.topologyService.getKShortestPaths(this.topologyService.currentTopology(), ingress.deviceId(), egress.deviceId(), (LinkWeigher)new BandwidthLinkWeight(bandwidth));
        Optional<OpticalConnectivityId> id = paths.filter(p -> p.src().equals((Object)ingress) && p.dst().equals((Object)egress)).limit(this.maxPaths).map(p -> this.setupPath((Path)p, bw, latency)).filter(Objects::nonNull).findFirst();
        if (id.isPresent()) {
            log.info("Assigned OpticalConnectivityId: {}", id);
        } else {
            log.error("setupConnectivity({}, {}, {}, {}) failed.", new Object[]{ingress, egress, bandwidth, latency});
        }
        return id.orElse(null);
    }

    @Override
    public OpticalConnectivityId setupPath(Path path, Bandwidth bandwidth, Duration latency) {
        Preconditions.checkNotNull((Object)path);
        log.debug("setupPath({}, {}, {})", new Object[]{path, bandwidth, latency});
        HashMap<ConnectPoint, ConnectPoint> crossConnectPointMap = new HashMap<ConnectPoint, ConnectPoint>();
        ArrayList<Pair<ConnectPoint, ConnectPoint>> crossConnectPoints = new ArrayList<Pair<ConnectPoint, ConnectPoint>>();
        ConnectPoint opticalSrcPort = null;
        for (Link link : path.links()) {
            if (!this.isCrossConnectLink(link)) continue;
            if (opticalSrcPort != null) {
                Device srcDevice = (Device)Preconditions.checkNotNull((Object)this.deviceService.getDevice(opticalSrcPort.deviceId()), (Object)"Unknown device ID");
                Device dstDevice = (Device)Preconditions.checkNotNull((Object)this.deviceService.getDevice(link.src().deviceId()), (Object)"Unknown device ID");
                if (srcDevice.type() != dstDevice.type()) {
                    log.error("Unsupported mix of cross connect points : {}, {}", (Object)srcDevice.type(), (Object)dstDevice.type());
                    return null;
                }
                crossConnectPointMap.put(link.src(), link.dst());
                crossConnectPoints.add((Pair<ConnectPoint, ConnectPoint>)Pair.of((Object)opticalSrcPort, (Object)link.src()));
                opticalSrcPort = null;
                continue;
            }
            crossConnectPointMap.put(link.dst(), link.src());
            opticalSrcPort = link.dst();
        }
        List<Intent> intents = this.createIntents(crossConnectPoints);
        if (intents.isEmpty()) {
            log.error("No intents produced from {}", crossConnectPoints);
            return null;
        }
        Set<PacketLinkRealizedByOptical> packetLinks = this.createPacketLinkSet(crossConnectPoints, intents, crossConnectPointMap);
        OpticalConnectivity connectivity = this.createConnectivity(path, bandwidth, latency, packetLinks);
        path.links().stream().filter(this::isCrossConnectLink).forEach(arg_0 -> this.usedCrossConnectLinkSet.add(arg_0));
        for (Intent i : intents) {
            this.intentService.submit(i);
            log.debug("Submitted an intent: {}", (Object)i);
        }
        return connectivity.id();
    }

    private OpticalConnectivity createConnectivity(Path path, Bandwidth bandwidth, Duration latency, Set<PacketLinkRealizedByOptical> links) {
        OpticalConnectivityId id = OpticalConnectivityId.of(this.idCounter.getAndIncrement());
        OpticalConnectivity connectivity = new OpticalConnectivity(id, path.links(), bandwidth, latency, links, Collections.emptySet());
        links.forEach(l -> this.linkPathMap.put(l, (Object)connectivity));
        this.connectivityMap.put((Object)connectivity.id(), (Object)connectivity);
        return connectivity;
    }

    @Override
    public boolean removeConnectivity(OpticalConnectivityId id) {
        log.info("removeConnectivity({})", (Object)id);
        Versioned connectivity = this.connectivityMap.remove((Object)id);
        if (connectivity == null) {
            log.info("OpticalConnectivity with id {} not found.", (Object)id);
            return false;
        }
        ((OpticalConnectivity)connectivity.value()).getRealizingLinks().forEach(l -> {
            Intent intent = this.intentService.getIntent(l.realizingIntentKey());
            this.intentService.withdraw(intent);
        });
        return true;
    }

    @Override
    public Optional<List<Link>> getPath(OpticalConnectivityId id) {
        Versioned connectivity = this.connectivityMap.get((Object)id);
        if (connectivity == null) {
            log.info("OpticalConnectivity with id {} not found.", (Object)id);
            return Optional.empty();
        }
        return Optional.of(ImmutableList.copyOf(((OpticalConnectivity)connectivity.value()).links()));
    }

    private List<Intent> createIntents(List<Pair<ConnectPoint, ConnectPoint>> crossConnectPoints) {
        LinkedList<Intent> intents = new LinkedList<Intent>();
        for (Pair<ConnectPoint, ConnectPoint> next : crossConnectPoints) {
            ConnectPoint src = (ConnectPoint)next.getLeft();
            ConnectPoint dst = (ConnectPoint)next.getRight();
            Port srcPort = this.deviceService.getPort(src.deviceId(), src.port());
            Port dstPort = this.deviceService.getPort(dst.deviceId(), dst.port());
            if (srcPort instanceof OduCltPort && dstPort instanceof OduCltPort) {
                OduCltPort srcOCPort = (OduCltPort)srcPort;
                OduCltPort dstOCPort = (OduCltPort)dstPort;
                if (!srcOCPort.signalType().equals((Object)dstOCPort.signalType())) continue;
                OpticalCircuitIntent circuitIntent = OpticalCircuitIntent.builder().appId(this.appId).src(src).dst(dst).signalType(srcOCPort.signalType()).bidirectional(false).build();
                intents.add((Intent)circuitIntent);
                continue;
            }
            if (srcPort instanceof OchPort && dstPort instanceof OchPort) {
                OchPort srcOchPort = (OchPort)srcPort;
                OchPort dstOchPort = (OchPort)dstPort;
                if (!srcOchPort.signalType().equals((Object)dstOchPort.signalType())) continue;
                OpticalConnectivityIntent opticalIntent = OpticalConnectivityIntent.builder().appId(this.appId).src(src).dst(dst).signalType(srcOchPort.signalType()).bidirectional(false).build();
                intents.add((Intent)opticalIntent);
                continue;
            }
            log.warn("Unsupported cross connect point types {} {}", (Object)srcPort.type(), (Object)dstPort.type());
            return Collections.emptyList();
        }
        return intents;
    }

    private Set<PacketLinkRealizedByOptical> createPacketLinkSet(List<Pair<ConnectPoint, ConnectPoint>> connectPoints, List<Intent> intents, Map<ConnectPoint, ConnectPoint> crossConnectPoints) {
        Preconditions.checkArgument((connectPoints.size() == intents.size() ? 1 : 0) != 0);
        HashSet<PacketLinkRealizedByOptical> pLinks = new HashSet<PacketLinkRealizedByOptical>();
        Iterator<Pair<ConnectPoint, ConnectPoint>> xcPointsItr = connectPoints.iterator();
        Iterator<Intent> intentItr = intents.iterator();
        while (xcPointsItr.hasNext()) {
            Pair<ConnectPoint, ConnectPoint> xcPoints = xcPointsItr.next();
            Intent intent = intentItr.next();
            ConnectPoint packetSrc = (ConnectPoint)Preconditions.checkNotNull((Object)crossConnectPoints.get(xcPoints.getLeft()));
            ConnectPoint packetDst = (ConnectPoint)Preconditions.checkNotNull((Object)crossConnectPoints.get(xcPoints.getRight()));
            if (intent instanceof OpticalConnectivityIntent) {
                pLinks.add(PacketLinkRealizedByOptical.create(packetSrc, packetDst, (OpticalConnectivityIntent)intent));
                continue;
            }
            if (intent instanceof OpticalCircuitIntent) {
                pLinks.add(PacketLinkRealizedByOptical.create(packetSrc, packetDst, (OpticalCircuitIntent)intent));
                continue;
            }
            log.warn("Unexpected intent type: {}", intent.getClass());
        }
        return pLinks;
    }

    private boolean isPacketLayer(Device.Type type) {
        return type == Device.Type.SWITCH || type == Device.Type.ROUTER || type == Device.Type.VIRTUAL;
    }

    private boolean isTransportLayer(Device.Type type) {
        return type == Device.Type.ROADM || type == Device.Type.OTN || type == Device.Type.ROADM_OTN;
    }

    private boolean isCrossConnectLink(Link link) {
        Device.Type dst;
        if (link.type() != Link.Type.OPTICAL) {
            return false;
        }
        Device.Type src = this.deviceService.getDevice(link.src().deviceId()).type();
        return src != (dst = this.deviceService.getDevice(link.dst().deviceId()).type()) && (this.isPacketLayer(src) && this.isTransportLayer(dst) || this.isPacketLayer(dst) && this.isTransportLayer(src));
    }

    private void setPortBandwidth(ConnectPoint cp, Bandwidth bandwidth) {
        log.debug("update Port {} Bandwidth {}", (Object)cp, (Object)bandwidth);
        BandwidthCapacity bwCapacity = (BandwidthCapacity)this.networkConfigService.addConfig((Object)cp, BandwidthCapacity.class);
        bwCapacity.capacity(bandwidth).apply();
    }

    private void updateBandwidthUsage(OpticalConnectivity connectivity) {
        if (NO_BW_REQUIREMENT.equals(connectivity.bandwidth())) {
            return;
        }
        OpticalConnectivityId connectivityId = connectivity.id();
        List<Link> links = connectivity.links();
        List resources = links.stream().flatMap(l -> Stream.of(l.src(), l.dst())).filter(cp -> !this.isTransportLayer(this.deviceService.getDevice(cp.deviceId()).type())).map(cp -> Resources.continuous((DeviceId)cp.deviceId(), (PortNumber)cp.port(), Bandwidth.class).resource(connectivity.bandwidth().bps())).collect(Collectors.toList());
        log.debug("allocating bandwidth for {} : {}", (Object)connectivityId, resources);
        List allocations = this.resourceService.allocate((ResourceConsumer)connectivityId, resources);
        if (allocations.isEmpty()) {
            log.warn("Failed to allocate bandwidth {} to {}", (Object)connectivity.bandwidth().bps(), resources);
        }
        log.debug("Done allocating bandwidth for {}", (Object)connectivityId);
    }

    private void releaseBandwidthUsage(OpticalConnectivity connectivity) {
        if (connectivity.links().isEmpty()) {
            return;
        }
        if (NO_BW_REQUIREMENT.equals(connectivity.bandwidth())) {
            return;
        }
        if (this.mastershipService.isLocalMaster(connectivity.links().get(0).src().deviceId())) {
            OpticalConnectivityId connectivityId = connectivity.id();
            log.debug("releasing bandwidth allocated to {}", (Object)connectivityId);
            if (!this.resourceService.release((ResourceConsumer)connectivityId)) {
                log.warn("Failed to release bandwidth allocated to {}", (Object)connectivityId);
            }
            log.debug("DONE releasing bandwidth for {}", (Object)connectivityId);
        }
    }

    private boolean linkDiscoveryEnabled(ConnectPoint cp) {
        return "of".equals(cp.deviceId().uri().getScheme());
    }

    private boolean linkDiscoveryEnabled(ConnectPoint cp1, ConnectPoint cp2) {
        return this.linkDiscoveryEnabled(cp1) && this.linkDiscoveryEnabled(cp2);
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindNetworkConfigService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    protected void unbindNetworkConfigService(NetworkConfigService networkConfigService) {
        if (this.networkConfigService == networkConfigService) {
            this.networkConfigService = null;
        }
    }

    protected void bindResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }

    private class InternalStoreListener
    implements MapEventListener<PacketLinkRealizedByOptical, OpticalConnectivity> {
        private InternalStoreListener() {
        }

        public void event(MapEvent<PacketLinkRealizedByOptical, OpticalConnectivity> event) {
            switch (event.type()) {
                case UPDATE: {
                    OpticalConnectivity oldConnectivity = (OpticalConnectivity)event.oldValue().value();
                    OpticalConnectivity newConnectivity = (OpticalConnectivity)event.newValue().value();
                    if (!oldConnectivity.isAllRealizingLinkEstablished() && newConnectivity.isAllRealizingLinkEstablished()) {
                        OpticalPathProvisioner.this.updateBandwidthUsage(newConnectivity);
                        OpticalPathProvisioner.this.post((Event)new OpticalPathEvent(OpticalPathEvent.Type.PATH_INSTALLED, newConnectivity.id()));
                        break;
                    }
                    if (oldConnectivity.isAllRealizingLinkNotEstablished() || !newConnectivity.isAllRealizingLinkNotEstablished()) break;
                    OpticalPathProvisioner.this.releaseBandwidthUsage(newConnectivity);
                    OpticalPathProvisioner.this.post((Event)new OpticalPathEvent(OpticalPathEvent.Type.PATH_REMOVED, newConnectivity.id()));
                    break;
                }
            }
        }
    }

    private class InternalLinkListener
    implements LinkListener {
        private InternalLinkListener() {
        }

        public void event(LinkEvent event) {
            switch ((LinkEvent.Type)event.type()) {
                case LINK_REMOVED: {
                    Link link = (Link)event.subject();
                    if (!OpticalPathProvisioner.this.mastershipService.isLocalMaster(link.src().deviceId())) {
                        return;
                    }
                    Set<PacketLinkRealizedByOptical> pLinks = OpticalPathProvisioner.this.linkPathMap.keySet().stream().filter(l -> l.isBetween(link.src(), link.dst()) || l.isBetween(link.dst(), link.src())).collect(Collectors.toSet());
                    pLinks.forEach(l -> OpticalPathProvisioner.this.linkPathMap.computeIfPresent(l, (plink, conn) -> {
                        if (conn.isAllRealizingLinkNotEstablished()) {
                            OpticalPathProvisioner.this.post((Event)new OpticalPathEvent(OpticalPathEvent.Type.PATH_REMOVED, conn.id()));
                        }
                        return null;
                    }));
                }
            }
        }
    }

    public class InternalIntentListener
    implements IntentListener {
        public void event(IntentEvent event) {
            switch ((IntentEvent.Type)event.type()) {
                case INSTALLED: {
                    log.debug("Intent {} installed.", event.subject());
                    this.updateCrossConnectLink((Intent)event.subject());
                    break;
                }
                case WITHDRAWN: {
                    log.debug("Intent {} withdrawn.", event.subject());
                    this.removeCrossConnectLinks((Intent)event.subject());
                    break;
                }
                case FAILED: {
                    log.debug("Intent {} failed.", event.subject());
                    break;
                }
            }
        }

        private void updateCrossConnectLink(Intent intent) {
            OpticalPathProvisioner.this.linkPathMap.entrySet().stream().filter(e -> ((PacketLinkRealizedByOptical)e.getKey()).realizingIntentKey().equals((Object)intent.key())).forEach(e -> {
                ConnectPoint packetSrc = ((PacketLinkRealizedByOptical)e.getKey()).src();
                ConnectPoint packetDst = ((PacketLinkRealizedByOptical)e.getKey()).dst();
                Bandwidth bw = ((PacketLinkRealizedByOptical)e.getKey()).bandwidth();
                if (OpticalPathProvisioner.this.mastershipService.isLocalMaster(packetSrc.deviceId())) {
                    OpticalPathProvisioner.this.setPortBandwidth(packetSrc, bw);
                    OpticalPathProvisioner.this.setPortBandwidth(packetDst, bw);
                    OpticalPathProvisioner.this.linkPathMap.computeIfPresent(e.getKey(), (link, connectivity) -> ((OpticalConnectivity)((Versioned)e.getValue()).value()).setLinkEstablished(packetSrc, packetDst, true));
                    if (!OpticalPathProvisioner.this.linkDiscoveryEnabled(packetSrc, packetDst)) {
                        this.injectLink(packetSrc, packetDst);
                    }
                }
            });
        }

        private void removeCrossConnectLinks(Intent intent) {
            ConnectPoint dst;
            ConnectPoint src;
            if (intent instanceof OpticalCircuitIntent) {
                OpticalCircuitIntent circuit = (OpticalCircuitIntent)intent;
                src = circuit.getSrc();
                dst = circuit.getDst();
            } else if (intent instanceof OpticalConnectivityIntent) {
                OpticalConnectivityIntent conn = (OpticalConnectivityIntent)intent;
                src = conn.getSrc();
                dst = conn.getDst();
            } else {
                return;
            }
            this.removeXcLinkUsage(src);
            this.removeXcLinkUsage(dst);
            Bandwidth bw = Bandwidth.bps((long)0L);
            OpticalPathProvisioner.this.linkPathMap.entrySet().stream().filter(e -> ((PacketLinkRealizedByOptical)e.getKey()).realizingIntentKey().equals((Object)intent.key())).forEach(e -> {
                ConnectPoint packetSrc = ((PacketLinkRealizedByOptical)e.getKey()).src();
                ConnectPoint packetDst = ((PacketLinkRealizedByOptical)e.getKey()).dst();
                if (OpticalPathProvisioner.this.mastershipService.isLocalMaster(packetSrc.deviceId())) {
                    OpticalPathProvisioner.this.setPortBandwidth(packetSrc, bw);
                    OpticalPathProvisioner.this.setPortBandwidth(packetDst, bw);
                    OpticalPathProvisioner.this.linkPathMap.computeIfPresent(e.getKey(), (link, connectivity) -> ((OpticalConnectivity)((Versioned)e.getValue()).value()).setLinkEstablished(packetSrc, packetDst, false));
                    if (!OpticalPathProvisioner.this.linkDiscoveryEnabled(packetSrc, packetDst)) {
                        this.removeInjectedLink(packetSrc, packetDst);
                    }
                }
            });
        }

        private void removeXcLinkUsage(ConnectPoint cp) {
            Optional<Link> link = OpticalPathProvisioner.this.linkService.getLinks(cp).stream().filter(arg_0 -> OpticalPathProvisioner.this.usedCrossConnectLinkSet.contains(arg_0)).findAny();
            if (!link.isPresent()) {
                log.warn("Cross connect point {} has no cross connect link to release.", (Object)cp);
                return;
            }
            OpticalPathProvisioner.this.usedCrossConnectLinkSet.remove((Object)link.get());
        }

        private void injectLink(ConnectPoint packetSrc, ConnectPoint packetDst) {
            try {
                LinkKey lnkKey = LinkKey.linkKey((ConnectPoint)packetSrc, (ConnectPoint)packetDst);
                BasicLinkConfig lnkCfg = (BasicLinkConfig)OpticalPathProvisioner.this.networkConfigService.getConfig((Object)lnkKey, BasicLinkConfig.class);
                if (lnkCfg == null) {
                    lnkCfg = new BasicLinkConfig(lnkKey);
                }
                lnkCfg.isAllowed(Boolean.valueOf(true));
                lnkCfg.isDurable(Boolean.valueOf(true));
                lnkCfg.type(Link.Type.INDIRECT);
                lnkCfg.isBidirectional(Boolean.valueOf(false));
                OpticalPathProvisioner.this.networkConfigService.applyConfig((Object)lnkKey, BasicLinkConfig.class, lnkCfg.node());
            }
            catch (Exception ex) {
                log.error("Applying BasicLinkConfig failed", (Throwable)ex);
            }
        }

        private void removeInjectedLink(ConnectPoint packetSrc, ConnectPoint packetDst) {
            try {
                BasicLinkConfig lnkCfg = (BasicLinkConfig)OpticalPathProvisioner.this.networkConfigService.getConfig((Object)LinkKey.linkKey((ConnectPoint)packetSrc, (ConnectPoint)packetDst), BasicLinkConfig.class);
                lnkCfg.isAllowed(Boolean.valueOf(false));
                lnkCfg.apply();
            }
            catch (Exception ex) {
                log.error("Applying BasicLinkConfig failed", (Throwable)ex);
            }
            OpticalPathProvisioner.this.networkConfigService.removeConfig((Object)LinkKey.linkKey((ConnectPoint)packetSrc, (ConnectPoint)packetDst), BasicLinkConfig.class);
        }
    }

    private class BandwidthLinkWeight
    extends DefaultEdgeWeigher<TopologyVertex, TopologyEdge>
    implements LinkWeigher {
        private Bandwidth bandwidth = null;

        public BandwidthLinkWeight(Bandwidth bandwidth) {
            this.bandwidth = bandwidth;
        }

        public Weight weight(TopologyEdge edge) {
            Link l = edge.link();
            if (l.state() == Link.State.INACTIVE) {
                log.trace("{} is not active", (Object)l);
                return ScalarWeight.NON_VIABLE_WEIGHT;
            }
            if (OpticalPathProvisioner.this.isCrossConnectLink(l) && OpticalPathProvisioner.this.usedCrossConnectLinkSet.contains((Object)l)) {
                log.trace("Cross connect {} in use", (Object)l);
                return ScalarWeight.NON_VIABLE_WEIGHT;
            }
            if (this.bandwidth != null && !NO_BW_REQUIREMENT.equals(this.bandwidth)) {
                if (this.hasEnoughBandwidth(l.src()) && this.hasEnoughBandwidth(l.dst())) {
                    return new ScalarWeight(1.0);
                }
                log.trace("Not enough bandwidth on {}", (Object)l);
                return ScalarWeight.NON_VIABLE_WEIGHT;
            }
            return new ScalarWeight(1.0);
        }

        private boolean hasEnoughBandwidth(ConnectPoint cp) {
            if (cp.elementId() instanceof DeviceId) {
                Device device = OpticalPathProvisioner.this.deviceService.getDevice(cp.deviceId());
                Device.Type type = device.type();
                if (OpticalPathProvisioner.this.isTransportLayer(type)) {
                    Port port = OpticalPathProvisioner.this.deviceService.getPort(cp.deviceId(), cp.port());
                    if (port instanceof OduCltPort || port instanceof OchPort) {
                        return this.bandwidth.bps() < (double)port.portSpeed() * 1000000.0;
                    }
                    return true;
                }
                ContinuousResource resource = Resources.continuous((DeviceId)cp.deviceId(), (PortNumber)cp.port(), Bandwidth.class).resource(this.bandwidth.bps());
                try {
                    return OpticalPathProvisioner.this.resourceService.isAvailable((Resource)resource);
                }
                catch (Exception e) {
                    log.error("Resource service failed checking availability of {}", (Object)resource, (Object)e);
                    throw e;
                }
            }
            return false;
        }
    }
}

