/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.newoptical.cli;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onlab.util.Bandwidth;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cli.net.ConnectPointCompleter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;
import org.onosproject.newoptical.api.OpticalConnectivityId;
import org.onosproject.newoptical.api.OpticalPathService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="onos", name="add-optical-connectivity", description="Configure optical domain connectivity")
public class AddOpticalConnectivityCommand
extends AbstractShellCommand {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    ConnectPointCompleter portCompleter;
    @Argument(index=0, name="ingress", description="Ingress connect point", required=true, multiValued=false)
    String ingressStr = null;
    @Argument(index=1, name="egress", description="Egress connect point", required=true, multiValued=false)
    String egressStr = null;
    @Argument(index=2, name="bandwidth", description="Bandwidth", required=false, multiValued=false)
    String bandwidthStr = null;
    @Argument(index=3, name="latency", description="Latency", required=false, multiValued=false)
    String latencyStr = null;

    protected void execute() {
        OpticalPathService opticalPathService = (OpticalPathService)AddOpticalConnectivityCommand.get(OpticalPathService.class);
        ConnectPoint ingress = this.readConnectPoint(this.ingressStr);
        ConnectPoint egress = this.readConnectPoint(this.egressStr);
        if (ingress == null || egress == null) {
            this.print("Invalid connect points: %s, %s", new Object[]{this.ingressStr, this.egressStr});
            return;
        }
        Bandwidth bandwidth = this.bandwidthStr == null || this.bandwidthStr.isEmpty() ? null : Bandwidth.bps((long)Long.valueOf(this.bandwidthStr));
        this.print("Trying to setup connectivity between %s and %s.", new Object[]{ingress, egress});
        OpticalConnectivityId id = opticalPathService.setupConnectivity(ingress, egress, bandwidth, null);
        if (id == null) {
            this.print("Failed. See ONOS log for more details.", new Object[0]);
            this.print(" log:set TRACE org.onosproject.newoptical.OpticalPathProvisioner", new Object[0]);
            return;
        }
        this.print("Optical path ID : %s", new Object[]{id.id()});
        this.log.info("Optical path ID {} for connectivity between {} and {}", new Object[]{id.id(), ingress, egress});
    }

    private ConnectPoint readConnectPoint(String str) {
        String[] strings = str.split("/");
        if (strings.length != 2) {
            return null;
        }
        DeviceId devId = DeviceId.deviceId((String)strings[0]);
        PortNumber port = PortNumber.portNumber((String)strings[1]);
        return new ConnectPoint((ElementId)devId, port);
    }
}

