/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.newoptical;

import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.util.Bandwidth;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.core.IdGenerator;
import org.onosproject.net.Annotations;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.OpticalCircuitIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.newoptical.OpticalConnectivity;
import org.onosproject.newoptical.PacketLinkRealizedByOptical;
import org.onosproject.newoptical.api.OpticalConnectivityId;

public class OpticalConnectivityTest {
    private final ApplicationId appId = new DefaultApplicationId(0, "PacketLinkRealizedByOpticalTest");
    private ProviderId providerId = new ProviderId("of", "foo");
    private IdGenerator idGenerator;

    @Before
    public void setUp() {
        this.idGenerator = new IdGenerator(){
            int counter = 1;

            public long getNewId() {
                return this.counter++;
            }
        };
        Intent.bindIdGenerator((IdGenerator)this.idGenerator);
    }

    @After
    public void tearDown() {
        Intent.unbindIdGenerator((IdGenerator)this.idGenerator);
    }

    @Test
    public void testCreate() {
        Bandwidth bandwidth = Bandwidth.bps((long)100L);
        Duration latency = Duration.ofMillis(10L);
        ConnectPoint cp12 = this.createConnectPoint(1L, 2L);
        ConnectPoint cp21 = this.createConnectPoint(2L, 1L);
        ConnectPoint cp22 = this.createConnectPoint(2L, 2L);
        ConnectPoint cp31 = this.createConnectPoint(3L, 1L);
        Link link1 = this.createLink(cp12, cp21);
        Link link2 = this.createLink(cp22, cp31);
        List links = Stream.of(link1, link2).collect(Collectors.toList());
        OpticalConnectivityId cid = OpticalConnectivityId.of((long)1L);
        OpticalConnectivity oc = new OpticalConnectivity(cid, links, bandwidth, latency, Collections.emptySet(), Collections.emptySet());
        Assert.assertNotNull((Object)oc);
        Assert.assertEquals((Object)oc.id(), (Object)cid);
        Assert.assertEquals((Object)oc.links(), links);
        Assert.assertEquals((Object)oc.bandwidth(), (Object)bandwidth);
        Assert.assertEquals((Object)oc.latency(), (Object)latency);
    }

    @Test
    public void testLinkEstablishedByConnectivityIntent() {
        ConnectPoint cp12 = this.createConnectPoint(1L, 2L);
        ConnectPoint cp21 = this.createConnectPoint(2L, 1L);
        ConnectPoint cp22 = this.createConnectPoint(2L, 2L);
        ConnectPoint cp31 = this.createConnectPoint(3L, 1L);
        ConnectPoint cp32 = this.createConnectPoint(3L, 2L);
        ConnectPoint cp41 = this.createConnectPoint(4L, 1L);
        ConnectPoint cp42 = this.createConnectPoint(4L, 2L);
        ConnectPoint cp51 = this.createConnectPoint(5L, 1L);
        ConnectPoint cp52 = this.createConnectPoint(5L, 2L);
        ConnectPoint cp61 = this.createConnectPoint(6L, 1L);
        ConnectPoint cp62 = this.createConnectPoint(6L, 2L);
        ConnectPoint cp71 = this.createConnectPoint(7L, 1L);
        Link link1 = this.createLink(cp12, cp21);
        Link link2 = this.createLink(cp22, cp31);
        Link link3 = this.createLink(cp32, cp41);
        Link link4 = this.createLink(cp42, cp51);
        Link link5 = this.createLink(cp52, cp61);
        Link link6 = this.createLink(cp62, cp71);
        List links = Stream.of(link1, link2, link3, link4, link5, link6).collect(Collectors.toList());
        OpticalConnectivityIntent connIntent1 = this.createConnectivityIntent(cp21, cp32);
        PacketLinkRealizedByOptical oduLink1 = PacketLinkRealizedByOptical.create((ConnectPoint)cp12, (ConnectPoint)cp41, (OpticalConnectivityIntent)connIntent1);
        OpticalConnectivityIntent connIntent2 = this.createConnectivityIntent(cp51, cp62);
        PacketLinkRealizedByOptical oduLink2 = PacketLinkRealizedByOptical.create((ConnectPoint)cp42, (ConnectPoint)cp71, (OpticalConnectivityIntent)connIntent2);
        ImmutableSet plinks = ImmutableSet.of((Object)oduLink1, (Object)oduLink2);
        Bandwidth bandwidth = Bandwidth.bps((long)100L);
        Duration latency = Duration.ofMillis(10L);
        OpticalConnectivityId cid = OpticalConnectivityId.of((long)1L);
        OpticalConnectivity oc1 = new OpticalConnectivity(cid, links, bandwidth, latency, (Set)plinks, Collections.emptySet());
        Assert.assertTrue((boolean)oc1.isAllRealizingLinkNotEstablished());
        Assert.assertFalse((boolean)oc1.isAllRealizingLinkEstablished());
        OpticalConnectivity oc2 = oc1.setLinkEstablished(cp12, cp41, true);
        Assert.assertFalse((boolean)oc2.isAllRealizingLinkNotEstablished());
        Assert.assertFalse((boolean)oc2.isAllRealizingLinkEstablished());
        OpticalConnectivity oc3 = oc2.setLinkEstablished(cp42, cp71, true);
        Assert.assertFalse((boolean)oc3.isAllRealizingLinkNotEstablished());
        Assert.assertTrue((boolean)oc3.isAllRealizingLinkEstablished());
    }

    @Test
    public void testLinkEstablishedByCircuitIntent() {
        ConnectPoint cp12 = this.createConnectPoint(1L, 2L);
        ConnectPoint cp21 = this.createConnectPoint(2L, 1L);
        ConnectPoint cp22 = this.createConnectPoint(2L, 2L);
        ConnectPoint cp31 = this.createConnectPoint(3L, 1L);
        ConnectPoint cp32 = this.createConnectPoint(3L, 2L);
        ConnectPoint cp41 = this.createConnectPoint(4L, 1L);
        ConnectPoint cp42 = this.createConnectPoint(4L, 2L);
        ConnectPoint cp51 = this.createConnectPoint(5L, 1L);
        ConnectPoint cp52 = this.createConnectPoint(5L, 2L);
        ConnectPoint cp61 = this.createConnectPoint(6L, 1L);
        ConnectPoint cp62 = this.createConnectPoint(6L, 2L);
        ConnectPoint cp71 = this.createConnectPoint(7L, 1L);
        Link link1 = this.createLink(cp12, cp21);
        Link link2 = this.createLink(cp22, cp31);
        Link link3 = this.createLink(cp32, cp41);
        Link link4 = this.createLink(cp42, cp51);
        Link link5 = this.createLink(cp52, cp61);
        Link link6 = this.createLink(cp62, cp71);
        List links = Stream.of(link1, link2, link3, link4, link5, link6).collect(Collectors.toList());
        OpticalCircuitIntent circuitIntent1 = this.createCircuitIntent(cp21, cp32);
        PacketLinkRealizedByOptical ochLink1 = PacketLinkRealizedByOptical.create((ConnectPoint)cp12, (ConnectPoint)cp41, (OpticalCircuitIntent)circuitIntent1);
        OpticalCircuitIntent circuitIntent2 = this.createCircuitIntent(cp51, cp62);
        PacketLinkRealizedByOptical ochLink2 = PacketLinkRealizedByOptical.create((ConnectPoint)cp42, (ConnectPoint)cp71, (OpticalCircuitIntent)circuitIntent2);
        ImmutableSet plinks = ImmutableSet.of((Object)ochLink1, (Object)ochLink2);
        Bandwidth bandwidth = Bandwidth.bps((long)100L);
        Duration latency = Duration.ofMillis(10L);
        OpticalConnectivityId cid = OpticalConnectivityId.of((long)1L);
        OpticalConnectivity oc1 = new OpticalConnectivity(cid, links, bandwidth, latency, (Set)plinks, Collections.emptySet());
        Assert.assertTrue((boolean)oc1.isAllRealizingLinkNotEstablished());
        Assert.assertFalse((boolean)oc1.isAllRealizingLinkEstablished());
        OpticalConnectivity oc2 = oc1.setLinkEstablished(cp12, cp41, true);
        Assert.assertFalse((boolean)oc2.isAllRealizingLinkNotEstablished());
        Assert.assertFalse((boolean)oc2.isAllRealizingLinkEstablished());
        OpticalConnectivity oc3 = oc2.setLinkEstablished(cp42, cp71, true);
        Assert.assertFalse((boolean)oc3.isAllRealizingLinkNotEstablished());
        Assert.assertTrue((boolean)oc3.isAllRealizingLinkEstablished());
    }

    private ConnectPoint createConnectPoint(long devIdNum, long portIdNum) {
        return new ConnectPoint((ElementId)DeviceId.deviceId((String)String.format("of:%016d", devIdNum)), PortNumber.portNumber((long)portIdNum));
    }

    private Link createLink(ConnectPoint src, ConnectPoint dst) {
        return DefaultLink.builder().providerId(this.providerId).src(src).dst(dst).type(Link.Type.DIRECT).annotations((Annotations)DefaultAnnotations.EMPTY).build();
    }

    private OpticalCircuitIntent createCircuitIntent(ConnectPoint src, ConnectPoint dst) {
        OpticalCircuitIntent intent = OpticalCircuitIntent.builder().appId(this.appId).bidirectional(true).src(src).dst(dst).signalType(CltSignalType.CLT_100GBE).build();
        return intent;
    }

    private OpticalConnectivityIntent createConnectivityIntent(ConnectPoint src, ConnectPoint dst) {
        OpticalConnectivityIntent intent = OpticalConnectivityIntent.builder().appId(this.appId).bidirectional(true).src(src).dst(dst).signalType(OduSignalType.ODU4).build();
        return intent;
    }

    private class MockPath
    extends DefaultLink
    implements Path {
        List<Link> links;

        protected MockPath(ConnectPoint src, ConnectPoint dst, List<Link> links) {
            super(OpticalConnectivityTest.this.providerId, src, dst, Link.Type.INDIRECT, Link.State.ACTIVE, new Annotations[0]);
            this.links = links;
        }

        public List<Link> links() {
            return this.links;
        }

        public double cost() {
            return 0.0;
        }
    }
}

