/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.newoptical;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onlab.packet.IpAddress;
import org.onlab.util.Bandwidth;
import org.onlab.util.Frequency;
import org.onosproject.cluster.ClusterServiceAdapter;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreServiceAdapter;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.DefaultEventSinkRegistry;
import org.onosproject.event.Event;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.net.Annotations;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.Path;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.NetworkConfigServiceAdapter;
import org.onosproject.net.config.basics.BandwidthCapacity;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentServiceAdapter;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.link.LinkServiceAdapter;
import org.onosproject.net.optical.impl.DefaultOchPort;
import org.onosproject.net.optical.impl.DefaultOduCltPort;
import org.onosproject.net.optical.impl.DefaultOmsPort;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceId;
import org.onosproject.net.resource.ResourceListener;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.PathServiceAdapter;
import org.onosproject.newoptical.OpticalPathProvisioner;
import org.onosproject.newoptical.api.OpticalConnectivityId;
import org.onosproject.newoptical.api.OpticalPathEvent;
import org.onosproject.newoptical.api.OpticalPathListener;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapAdapter;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetAdapter;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.SetEventListener;
import org.onosproject.store.service.StorageServiceAdapter;
import org.onosproject.store.service.Versioned;

public class OpticalPathProvisionerTest {
    private static final ProviderId PROVIDER_ID = new ProviderId("of", "foo");
    private static final ConnectPoint CP11 = OpticalPathProvisionerTest.createConnectPoint(1L, 1L);
    private static final ConnectPoint CP12 = OpticalPathProvisionerTest.createConnectPoint(1L, 2L);
    private static final ConnectPoint CP21 = OpticalPathProvisionerTest.createConnectPoint(2L, 1L);
    private static final ConnectPoint CP22 = OpticalPathProvisionerTest.createConnectPoint(2L, 2L);
    private static final ConnectPoint CP31 = OpticalPathProvisionerTest.createConnectPoint(3L, 1L);
    private static final ConnectPoint CP32 = OpticalPathProvisionerTest.createConnectPoint(3L, 2L);
    private static final ConnectPoint CP41 = OpticalPathProvisionerTest.createConnectPoint(4L, 1L);
    private static final ConnectPoint CP42 = OpticalPathProvisionerTest.createConnectPoint(4L, 2L);
    private static final ConnectPoint CP51 = OpticalPathProvisionerTest.createConnectPoint(5L, 1L);
    private static final ConnectPoint CP52 = OpticalPathProvisionerTest.createConnectPoint(5L, 2L);
    private static final ConnectPoint CP61 = OpticalPathProvisionerTest.createConnectPoint(6L, 1L);
    private static final ConnectPoint CP62 = OpticalPathProvisionerTest.createConnectPoint(6L, 2L);
    private static final ConnectPoint CP71 = OpticalPathProvisionerTest.createConnectPoint(7L, 1L);
    private static final ConnectPoint CP72 = OpticalPathProvisionerTest.createConnectPoint(7L, 2L);
    private static final Link LINK1 = OpticalPathProvisionerTest.createLink(CP12, CP21, Link.Type.DIRECT);
    private static final Link LINK2 = OpticalPathProvisionerTest.createLink(CP22, CP31, Link.Type.OPTICAL);
    private static final Link LINK3 = OpticalPathProvisionerTest.createLink(CP32, CP41, Link.Type.OPTICAL);
    private static final Link LINK4 = OpticalPathProvisionerTest.createLink(CP42, CP51, Link.Type.OPTICAL);
    private static final Link LINK5 = OpticalPathProvisionerTest.createLink(CP52, CP61, Link.Type.OPTICAL);
    private static final Link LINK6 = OpticalPathProvisionerTest.createLink(CP62, CP71, Link.Type.DIRECT);
    private static final Device DEVICE1 = OpticalPathProvisionerTest.createDevice(1L, Device.Type.SWITCH);
    private static final Device DEVICE2 = OpticalPathProvisionerTest.createDevice(2L, Device.Type.SWITCH);
    private static final Device DEVICE3 = OpticalPathProvisionerTest.createDevice(3L, Device.Type.ROADM);
    private static final Device DEVICE4 = OpticalPathProvisionerTest.createDevice(4L, Device.Type.ROADM);
    private static final Device DEVICE5 = OpticalPathProvisionerTest.createDevice(5L, Device.Type.ROADM);
    private static final Device DEVICE6 = OpticalPathProvisionerTest.createDevice(6L, Device.Type.SWITCH);
    private static final Device DEVICE7 = OpticalPathProvisionerTest.createDevice(7L, Device.Type.SWITCH);
    private static final Port PORT11 = OpticalPathProvisionerTest.createPacketPort(DEVICE1, CP11);
    private static final Port PORT12 = OpticalPathProvisionerTest.createPacketPort(DEVICE1, CP12);
    private static final Port PORT21 = OpticalPathProvisionerTest.createPacketPort(DEVICE2, CP21);
    private static final Port PORT22 = OpticalPathProvisionerTest.createOduCltPort(DEVICE2, CP22);
    private static final Port PORT31 = OpticalPathProvisionerTest.createOchPort(DEVICE3, CP31);
    private static final Port PORT32 = OpticalPathProvisionerTest.createOmsPort(DEVICE3, CP32);
    private static final Port PORT41 = OpticalPathProvisionerTest.createOmsPort(DEVICE4, CP41);
    private static final Port PORT42 = OpticalPathProvisionerTest.createOmsPort(DEVICE4, CP42);
    private static final Port PORT51 = OpticalPathProvisionerTest.createOmsPort(DEVICE5, CP51);
    private static final Port PORT52 = OpticalPathProvisionerTest.createOchPort(DEVICE5, CP52);
    private static final Port PORT61 = OpticalPathProvisionerTest.createOduCltPort(DEVICE6, CP61);
    private static final Port PORT62 = OpticalPathProvisionerTest.createPacketPort(DEVICE6, CP62);
    private static final Port PORT71 = OpticalPathProvisionerTest.createPacketPort(DEVICE7, CP71);
    private static final Port PORT72 = OpticalPathProvisionerTest.createPacketPort(DEVICE7, CP72);
    protected OpticalPathProvisioner target;
    protected TestListener listener = new TestListener();
    protected TestDeviceService deviceService;
    protected TestLinkService linkService;
    protected TestPathService pathService;
    protected TestIntentService intentService;
    protected TestMastershipService mastershipService;
    protected TestClusterService clusterService;
    protected IdGenerator idGenerator;

    @Before
    public void setUp() {
        this.deviceService = new TestDeviceService();
        this.deviceService.devMap.put(OpticalPathProvisionerTest.deviceIdOf(1L), DEVICE1);
        this.deviceService.devMap.put(OpticalPathProvisionerTest.deviceIdOf(2L), DEVICE2);
        this.deviceService.devMap.put(OpticalPathProvisionerTest.deviceIdOf(3L), DEVICE3);
        this.deviceService.devMap.put(OpticalPathProvisionerTest.deviceIdOf(4L), DEVICE4);
        this.deviceService.devMap.put(OpticalPathProvisionerTest.deviceIdOf(5L), DEVICE5);
        this.deviceService.devMap.put(OpticalPathProvisionerTest.deviceIdOf(6L), DEVICE6);
        this.deviceService.devMap.put(OpticalPathProvisionerTest.deviceIdOf(7L), DEVICE7);
        this.deviceService.portMap.put(CP11, PORT11);
        this.deviceService.portMap.put(CP12, PORT12);
        this.deviceService.portMap.put(CP21, PORT21);
        this.deviceService.portMap.put(CP22, PORT22);
        this.deviceService.portMap.put(CP31, PORT31);
        this.deviceService.portMap.put(CP32, PORT32);
        this.deviceService.portMap.put(CP41, PORT41);
        this.deviceService.portMap.put(CP42, PORT42);
        this.deviceService.portMap.put(CP51, PORT51);
        this.deviceService.portMap.put(CP52, PORT52);
        this.deviceService.portMap.put(CP61, PORT61);
        this.deviceService.portMap.put(CP62, PORT62);
        this.deviceService.portMap.put(CP71, PORT71);
        this.deviceService.portMap.put(CP72, PORT72);
        this.linkService = new TestLinkService();
        this.linkService.links.addAll(Stream.of(LINK1, LINK2, LINK3, LINK4, LINK5, LINK6).collect(Collectors.toList()));
        this.pathService = new TestPathService();
        this.intentService = new TestIntentService();
        this.mastershipService = new TestMastershipService();
        this.clusterService = new TestClusterService();
        this.mastershipService.setMastership(DEVICE1.id(), MastershipRole.MASTER);
        this.mastershipService.setMastership(DEVICE2.id(), MastershipRole.MASTER);
        this.mastershipService.setMastership(DEVICE3.id(), MastershipRole.MASTER);
        this.mastershipService.setMastership(DEVICE4.id(), MastershipRole.MASTER);
        this.mastershipService.setMastership(DEVICE5.id(), MastershipRole.MASTER);
        this.mastershipService.setMastership(DEVICE6.id(), MastershipRole.MASTER);
        this.mastershipService.setMastership(DEVICE7.id(), MastershipRole.MASTER);
        this.target = new OpticalPathProvisioner();
        this.target.coreService = new TestCoreService();
        this.target.intentService = this.intentService;
        this.target.pathService = this.pathService;
        this.target.linkService = this.linkService;
        this.target.mastershipService = this.mastershipService;
        this.target.clusterService = this.clusterService;
        this.target.storageService = new TestStorageService();
        this.target.deviceService = this.deviceService;
        this.target.networkConfigService = new TestNetworkConfigService();
        this.target.resourceService = new TestResourceService();
        NetTestTools.injectEventDispatcher((Object)this.target, (EventDeliveryService)new TestEventDispatcher());
        this.target.addListener((EventListener)this.listener);
        this.target.activate();
        this.target.deviceService = this.deviceService;
        this.idGenerator = new IdGenerator(){
            int counter = 1;

            public long getNewId() {
                return this.counter++;
            }
        };
        Intent.bindIdGenerator((IdGenerator)this.idGenerator);
    }

    @After
    public void tearDown() {
        Intent.unbindIdGenerator((IdGenerator)this.idGenerator);
        this.target.removeListener((EventListener)this.listener);
        this.target = null;
    }

    @Test
    public void testSetupConnectivity() {
        Bandwidth bandwidth = Bandwidth.bps((long)100L);
        Duration latency = Duration.ofMillis(10L);
        OpticalConnectivityId cid = this.target.setupConnectivity(CP12, CP71, bandwidth, latency);
        Assert.assertNotNull((Object)cid);
        Assert.assertEquals((long)1L, (long)this.pathService.edges.size());
        Assert.assertEquals((Object)CP12.deviceId(), (Object)this.pathService.edges.get(0).getKey());
        Assert.assertEquals((Object)CP71.deviceId(), (Object)this.pathService.edges.get(0).getValue());
        Assert.assertEquals((long)1L, (long)this.intentService.submitted.size());
        Assert.assertEquals(OpticalConnectivityIntent.class, this.intentService.submitted.get(0).getClass());
        OpticalConnectivityIntent connIntent = (OpticalConnectivityIntent)this.intentService.submitted.get(0);
        Assert.assertEquals((Object)CP31, (Object)connIntent.getSrc());
        Assert.assertEquals((Object)CP52, (Object)connIntent.getDst());
    }

    @Test
    public void testSetupPath() {
        Bandwidth bandwidth = Bandwidth.bps((long)100L);
        Duration latency = Duration.ofMillis(10L);
        List links = Stream.of(LINK1, LINK2, LINK3, LINK4, LINK5, LINK6).collect(Collectors.toList());
        DefaultPath path = new DefaultPath(PROVIDER_ID, links, 0.0, new Annotations[0]);
        OpticalConnectivityId cid = this.target.setupPath((Path)path, bandwidth, latency);
        Assert.assertNotNull((Object)cid);
        Assert.assertEquals((long)1L, (long)this.intentService.submitted.size());
        Assert.assertEquals(OpticalConnectivityIntent.class, this.intentService.submitted.get(0).getClass());
        OpticalConnectivityIntent connIntent = (OpticalConnectivityIntent)this.intentService.submitted.get(0);
        Assert.assertEquals((Object)CP31, (Object)connIntent.getSrc());
        Assert.assertEquals((Object)CP52, (Object)connIntent.getDst());
    }

    @Test
    public void testRemoveConnectivity() {
        Bandwidth bandwidth = Bandwidth.bps((long)100L);
        Duration latency = Duration.ofMillis(10L);
        OpticalConnectivityId cid = this.target.setupConnectivity(CP12, CP71, bandwidth, latency);
        Assert.assertTrue((boolean)this.target.removeConnectivity(cid));
        Assert.assertEquals((long)1L, (long)this.intentService.withdrawn.size());
        Assert.assertEquals(OpticalConnectivityIntent.class, this.intentService.withdrawn.get(0).getClass());
        OpticalConnectivityIntent connIntent = (OpticalConnectivityIntent)this.intentService.withdrawn.get(0);
        Assert.assertEquals((Object)CP31, (Object)connIntent.getSrc());
        Assert.assertEquals((Object)CP52, (Object)connIntent.getDst());
    }

    @Test
    public void testGetPath() {
        Bandwidth bandwidth = Bandwidth.bps((long)100L);
        Duration latency = Duration.ofMillis(10L);
        List links = Stream.of(LINK1, LINK2, LINK3, LINK4, LINK5, LINK6).collect(Collectors.toList());
        OpticalConnectivityId cid = this.target.setupConnectivity(CP12, CP71, bandwidth, latency);
        Optional path = this.target.getPath(cid);
        Assert.assertTrue((boolean)path.isPresent());
        Assert.assertEquals(links, path.get());
    }

    @Test
    public void testInstalledEventLocal() {
        Bandwidth bandwidth = Bandwidth.bps((long)100L);
        Duration latency = Duration.ofMillis(10L);
        OpticalConnectivityId cid = this.target.setupConnectivity(CP12, CP71, bandwidth, latency);
        this.intentService.notifyInstalled();
        Assert.assertEquals((long)1L, (long)this.listener.events.size());
        Assert.assertEquals((Object)OpticalPathEvent.Type.PATH_INSTALLED, (Object)this.listener.events.get(0).type());
        Assert.assertEquals((Object)cid, (Object)this.listener.events.get(0).subject());
    }

    @Test
    public void testInstalledEventRemote() {
        this.mastershipService.setMastership(DEVICE2.id(), MastershipRole.NONE);
        Bandwidth bandwidth = Bandwidth.bps((long)100L);
        Duration latency = Duration.ofMillis(10L);
        OpticalConnectivityId cid = this.target.setupConnectivity(CP12, CP71, bandwidth, latency);
        this.intentService.notifyInstalled();
        Assert.assertEquals((long)0L, (long)this.listener.events.size());
    }

    @Test
    public void testRemovedEventLocal() {
        Bandwidth bandwidth = Bandwidth.bps((long)100L);
        Duration latency = Duration.ofMillis(10L);
        OpticalConnectivityId cid = this.target.setupConnectivity(CP12, CP71, bandwidth, latency);
        this.intentService.notifyInstalled();
        this.target.removeConnectivity(cid);
        this.intentService.notifyWithdrawn();
        Assert.assertEquals((long)2L, (long)this.listener.events.size());
        Assert.assertEquals((Object)OpticalPathEvent.Type.PATH_INSTALLED, (Object)this.listener.events.get(0).type());
        Assert.assertEquals((Object)cid, (Object)this.listener.events.get(0).subject());
        Assert.assertEquals((Object)OpticalPathEvent.Type.PATH_REMOVED, (Object)this.listener.events.get(1).type());
        Assert.assertEquals((Object)cid, (Object)this.listener.events.get(1).subject());
    }

    @Test
    public void testRemovedEventRemote() {
        this.mastershipService.setMastership(DEVICE2.id(), MastershipRole.NONE);
        Bandwidth bandwidth = Bandwidth.bps((long)100L);
        Duration latency = Duration.ofMillis(10L);
        OpticalConnectivityId cid = this.target.setupConnectivity(CP12, CP71, bandwidth, latency);
        this.intentService.notifyInstalled();
        this.target.removeConnectivity(cid);
        this.intentService.notifyWithdrawn();
        Assert.assertEquals((long)0L, (long)this.listener.events.size());
    }

    private static ConnectPoint createConnectPoint(long devIdNum, long portIdNum) {
        return new ConnectPoint((ElementId)OpticalPathProvisionerTest.deviceIdOf(devIdNum), PortNumber.portNumber((long)portIdNum));
    }

    private static Link createLink(ConnectPoint src, ConnectPoint dst, Link.Type type) {
        return DefaultLink.builder().providerId(PROVIDER_ID).src(src).dst(dst).state(Link.State.ACTIVE).type(type).build();
    }

    private static Device createDevice(long devIdNum, Device.Type type) {
        return new DefaultDevice(PROVIDER_ID, OpticalPathProvisionerTest.deviceIdOf(devIdNum), type, "manufacturer", "hwVersion", "swVersion", "serialNumber", new ChassisId(1L), new Annotations[0]);
    }

    private static Port createPacketPort(Device device, ConnectPoint cp) {
        return new DefaultPort((Element)device, cp.port(), true, new Annotations[0]);
    }

    private static Port createOchPort(Device device, ConnectPoint cp) {
        return new DefaultOchPort((Port)new DefaultPort((Element)device, cp.port(), true, new Annotations[0]), OduSignalType.ODU4, true, OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_50GHZ, (int)1));
    }

    private static Port createOduCltPort(Device device, ConnectPoint cp) {
        return new DefaultOduCltPort((Port)new DefaultPort((Element)device, cp.port(), true, new Annotations[0]), CltSignalType.CLT_100GBE);
    }

    private static Port createOmsPort(Device device, ConnectPoint cp) {
        return new DefaultOmsPort((Port)new DefaultPort((Element)device, cp.port(), true, new Annotations[0]), Frequency.ofKHz((long)3L), Frequency.ofKHz((long)33L), Frequency.ofKHz((long)2L));
    }

    private static DeviceId deviceIdOf(long devIdNum) {
        return DeviceId.deviceId((String)String.format("of:%016d", devIdNum));
    }

    public class TestEventDispatcher
    extends DefaultEventSinkRegistry
    implements EventDeliveryService {
        public synchronized void post(Event event) {
            EventSink sink = this.getSink(event.getClass());
            Preconditions.checkState((sink != null ? 1 : 0) != 0, (String)"No sink for event %s", (Object[])new Object[]{event});
            sink.process(event);
        }

        public void setDispatchTimeLimit(long millis) {
        }

        public long getDispatchTimeLimit() {
            return 0L;
        }
    }

    private static class MockAtomicCounter
    implements AtomicCounter {
        long id = 0L;

        private MockAtomicCounter() {
        }

        public long incrementAndGet() {
            return ++this.id;
        }

        public long getAndIncrement() {
            return this.id++;
        }

        public long getAndAdd(long delta) {
            long oldId = this.id;
            this.id += delta;
            return oldId;
        }

        public long addAndGet(long delta) {
            this.id += delta;
            return this.id;
        }

        public void set(long value) {
            this.id = value;
        }

        public boolean compareAndSet(long expectedValue, long updateValue) {
            if (this.id == expectedValue) {
                this.id = updateValue;
                return true;
            }
            return false;
        }

        public long get() {
            return this.id;
        }

        public String name() {
            return "MockAtomicCounter";
        }
    }

    private static class TestResourceService
    implements ResourceService {
        private TestResourceService() {
        }

        public List<ResourceAllocation> allocate(ResourceConsumer consumer, List<? extends Resource> resources) {
            ArrayList<ResourceAllocation> allocations = new ArrayList<ResourceAllocation>();
            resources.forEach(r -> allocations.add(new ResourceAllocation(r, consumer.consumerId())));
            return allocations;
        }

        public boolean release(List<ResourceAllocation> allocations) {
            return false;
        }

        public boolean release(ResourceConsumer consumer) {
            return true;
        }

        public void addListener(ResourceListener listener) {
        }

        public void removeListener(ResourceListener listener) {
        }

        public List<ResourceAllocation> getResourceAllocations(ResourceId id) {
            return null;
        }

        public <T> Collection<ResourceAllocation> getResourceAllocations(DiscreteResourceId parent, Class<T> cls) {
            return null;
        }

        public Collection<ResourceAllocation> getResourceAllocations(ResourceConsumer consumer) {
            return null;
        }

        public Set<Resource> getAvailableResources(DiscreteResourceId parent) {
            return null;
        }

        public <T> Set<Resource> getAvailableResources(DiscreteResourceId parent, Class<T> cls) {
            return null;
        }

        public <T> Set<T> getAvailableResourceValues(DiscreteResourceId parent, Class<T> cls) {
            return null;
        }

        public Set<Resource> getRegisteredResources(DiscreteResourceId parent) {
            return null;
        }

        public boolean isAvailable(Resource resource) {
            return true;
        }
    }

    private static class TestNetworkConfigService
    extends NetworkConfigServiceAdapter {
        private TestNetworkConfigService() {
        }

        public <S, C extends Config<S>> C addConfig(S subject, Class<C> configClass) {
            if (BandwidthCapacity.class.equals(configClass)) {
                return (C)new BandwidthCapacity(){

                    public void apply() {
                    }

                    public BandwidthCapacity capacity(Bandwidth bandwidth) {
                        return this;
                    }
                };
            }
            return null;
        }
    }

    private static class TestDeviceService
    extends DeviceServiceAdapter {
        Map<DeviceId, Device> devMap = new HashMap<DeviceId, Device>();
        Map<ConnectPoint, Port> portMap = new HashMap<ConnectPoint, Port>();

        private TestDeviceService() {
        }

        public Device getDevice(DeviceId deviceId) {
            return this.devMap.get(deviceId);
        }

        public Port getPort(DeviceId deviceId, PortNumber portNumber) {
            return this.portMap.get(new ConnectPoint((ElementId)deviceId, portNumber));
        }
    }

    private static class TestStorageService
    extends StorageServiceAdapter {
        private TestStorageService() {
        }

        public <K, V> ConsistentMapBuilder<K, V> consistentMapBuilder() {
            ConsistentMapBuilder builder = new ConsistentMapBuilder<K, V>(){

                public AsyncConsistentMap<K, V> buildAsyncMap() {
                    return null;
                }

                public ConsistentMap<K, V> build() {
                    return new TestConsistentMap();
                }
            };
            return builder;
        }

        public <E> DistributedSetBuilder<E> setBuilder() {
            DistributedSetBuilder builder = new DistributedSetBuilder<E>(){

                public AsyncDistributedSet<E> build() {
                    return new DistributedSetAdapter<E>(){

                        public DistributedSet<E> asDistributedSet() {
                            return new TestDistributedSet();
                        }
                    };
                }
            };
            return builder;
        }

        public AtomicCounter getAtomicCounter(String name) {
            return new MockAtomicCounter();
        }

        class TestDistributedSet<E>
        extends HashSet<E>
        implements DistributedSet<E> {
            TestDistributedSet() {
            }

            public void addListener(SetEventListener<E> listener) {
            }

            public void removeListener(SetEventListener<E> listener) {
            }

            public String name() {
                return null;
            }

            public DistributedPrimitive.Type primitiveType() {
                return null;
            }
        }

        class TestConsistentMap<K, V>
        extends ConsistentMapAdapter<K, V> {
            private Map<K, Versioned<V>> map = new HashMap<K, Versioned<V>>();
            private Map<MapEventListener<K, V>, Executor> listeners = new HashMap<MapEventListener<K, V>, Executor>();

            TestConsistentMap() {
            }

            public void notifyListeners(MapEvent<K, V> event) {
                this.listeners.forEach((c, e) -> e.execute(() -> c.event(event)));
            }

            public int size() {
                return this.map.size();
            }

            public Versioned<V> put(K key, V value) {
                Versioned<V> oldValue = this.map.get(key);
                Versioned newValue = new Versioned(value, oldValue == null ? 0L : oldValue.version() + 1L);
                this.map.put(key, newValue);
                this.notifyListeners(new MapEvent(this.name(), key, newValue, oldValue));
                return newValue;
            }

            public Versioned<V> get(K key) {
                return this.map.get(key);
            }

            public Versioned<V> remove(K key) {
                Versioned<V> oldValue = this.map.remove(key);
                this.notifyListeners(new MapEvent(this.name(), key, oldValue, null));
                return oldValue;
            }

            public Versioned<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
                Versioned<V> oldValue = this.map.get(key);
                Versioned newValue = new Versioned(remappingFunction.apply(key, oldValue.value()), oldValue == null ? 0L : oldValue.version() + 1L);
                this.map.put(key, newValue);
                this.notifyListeners(new MapEvent(this.name(), key, newValue, oldValue));
                return newValue;
            }

            public Set<Map.Entry<K, Versioned<V>>> entrySet() {
                return this.map.entrySet();
            }

            public Set<K> keySet() {
                return this.map.keySet();
            }

            public Collection<Versioned<V>> values() {
                return this.map.values();
            }

            public void clear() {
                this.map.clear();
            }

            public void addListener(MapEventListener<K, V> listener, Executor executor) {
                this.listeners.put(listener, executor);
            }

            public void removeListener(MapEventListener<K, V> listener) {
                this.listeners.remove(listener);
            }
        }
    }

    private static class TestClusterService
    extends ClusterServiceAdapter {
        private NodeId nodeId;

        private TestClusterService() {
        }

        public void setLocalNode(String nodeIdStr) {
            this.nodeId = NodeId.nodeId((String)nodeIdStr);
        }

        public ControllerNode getLocalNode() {
            return new ControllerNode(){

                public NodeId id() {
                    return nodeId;
                }

                public IpAddress ip() {
                    return null;
                }

                public int tcpPort() {
                    return 0;
                }
            };
        }
    }

    private static class TestMastershipService
    extends MastershipServiceAdapter {
        private Map<DeviceId, MastershipRole> mastershipMap = new HashMap<DeviceId, MastershipRole>();

        private TestMastershipService() {
        }

        public void setMastership(DeviceId deviceId, MastershipRole role) {
            this.mastershipMap.put(deviceId, role);
        }

        public void clear() {
            this.mastershipMap.clear();
        }

        public MastershipRole getLocalRole(DeviceId deviceId) {
            return this.mastershipMap.get(deviceId);
        }
    }

    private static class TestCoreService
    extends CoreServiceAdapter {
        private TestCoreService() {
        }

        public ApplicationId registerApplication(String name) {
            return new DefaultApplicationId(0, name);
        }
    }

    private static class TestLinkService
    extends LinkServiceAdapter {
        List<Link> links = new ArrayList<Link>();

        private TestLinkService() {
        }

        public Set<Link> getLinks(ConnectPoint connectPoint) {
            return this.links.stream().filter(l -> l.src().equals((Object)connectPoint) || l.dst().equals((Object)connectPoint)).collect(Collectors.toSet());
        }
    }

    private static class TestIntentService
    extends IntentServiceAdapter {
        List<Intent> submitted = new ArrayList<Intent>();
        List<Intent> withdrawn = new ArrayList<Intent>();
        List<IntentListener> listeners = new ArrayList<IntentListener>();

        private TestIntentService() {
        }

        public void submit(Intent intent) {
            this.submitted.add(intent);
        }

        public void withdraw(Intent intent) {
            this.withdrawn.add(intent);
        }

        public void addListener(IntentListener listener) {
            this.listeners.add(listener);
        }

        public Intent getIntent(Key intentKey) {
            Intent intent = this.submitted.stream().filter(i -> i.key().equals((Object)intentKey)).findAny().get();
            return intent;
        }

        void notifyInstalled() {
            this.submitted.forEach(i -> {
                IntentEvent event = new IntentEvent(IntentEvent.Type.INSTALLED, i);
                this.listeners.forEach(l -> l.event((Event)event));
            });
        }

        void notifyWithdrawn() {
            this.withdrawn.forEach(i -> {
                IntentEvent event = new IntentEvent(IntentEvent.Type.WITHDRAWN, i);
                this.listeners.forEach(l -> l.event((Event)event));
            });
        }
    }

    private static class TestPathService
    extends PathServiceAdapter {
        List<Pair<DeviceId, DeviceId>> edges = new ArrayList<Pair<DeviceId, DeviceId>>();

        private TestPathService() {
        }

        public Set<Path> getPaths(ElementId src, ElementId dst, LinkWeight weight) {
            if (!(src instanceof DeviceId) || !(dst instanceof DeviceId)) {
                return Collections.emptySet();
            }
            this.edges.add((Pair<DeviceId, DeviceId>)Pair.of((Object)((DeviceId)src), (Object)((DeviceId)dst)));
            HashSet<Path> paths = new HashSet<Path>();
            List links = Stream.of(LINK1, LINK2, LINK3, LINK4, LINK5, LINK6).collect(Collectors.toList());
            paths.add((Path)new DefaultPath(PROVIDER_ID, links, 0.0, new Annotations[0]));
            return paths;
        }
    }

    private static class TestListener
    implements OpticalPathListener {
        final List<OpticalPathEvent> events = new ArrayList<OpticalPathEvent>();

        private TestListener() {
        }

        public void event(OpticalPathEvent event) {
            this.events.add(event);
        }
    }
}

