/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.newoptical;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.util.Bandwidth;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.newoptical.PacketLinkRealizedByOptical;
import org.onosproject.newoptical.api.OpticalConnectivityId;

@Beta
public class OpticalConnectivity {
    private final OpticalConnectivityId id;
    private final List<Link> links;
    private final Bandwidth requestBandwidth;
    private final Duration requestLatency;
    private final ImmutableSet<PacketLinkRealizedByOptical> unestablishedLinks;
    private final ImmutableSet<PacketLinkRealizedByOptical> establishedLinks;

    public OpticalConnectivity(OpticalConnectivityId id, List<Link> links, Bandwidth requestBandwidth, Duration requestLatency, Set<PacketLinkRealizedByOptical> unestablishedLinks, Set<PacketLinkRealizedByOptical> establishedLinks) {
        this.id = id;
        this.links = ImmutableList.copyOf(links);
        this.requestBandwidth = requestBandwidth;
        this.requestLatency = requestLatency;
        this.unestablishedLinks = ImmutableSet.copyOf(unestablishedLinks);
        this.establishedLinks = ImmutableSet.copyOf(establishedLinks);
    }

    private OpticalConnectivity(OpticalConnectivity connectivity) {
        this.id = connectivity.id;
        this.links = ImmutableList.copyOf(connectivity.links);
        this.requestBandwidth = connectivity.requestBandwidth;
        this.requestLatency = connectivity.requestLatency;
        this.unestablishedLinks = ImmutableSet.copyOf(connectivity.unestablishedLinks);
        this.establishedLinks = ImmutableSet.copyOf(connectivity.establishedLinks);
    }

    public boolean isAllRealizingLinkEstablished() {
        return this.unestablishedLinks.isEmpty();
    }

    public boolean isAllRealizingLinkNotEstablished() {
        return this.establishedLinks.isEmpty();
    }

    public OpticalConnectivityId id() {
        return this.id;
    }

    public List<Link> links() {
        return this.links;
    }

    public Bandwidth bandwidth() {
        return this.requestBandwidth;
    }

    public Duration latency() {
        return this.requestLatency;
    }

    public Set<PacketLinkRealizedByOptical> getEstablishedLinks() {
        return this.establishedLinks;
    }

    public Set<PacketLinkRealizedByOptical> getUnestablishedLinks() {
        return this.unestablishedLinks;
    }

    public OpticalConnectivity setLinkEstablished(ConnectPoint src, ConnectPoint dst, boolean established) {
        ImmutableSet newEstablishedLinks;
        ImmutableSet newUnestablishedLinks;
        if (established) {
            Optional<PacketLinkRealizedByOptical> link = this.unestablishedLinks.stream().filter(l -> l.isBetween(src, dst)).findAny();
            Preconditions.checkState((boolean)link.isPresent());
            newUnestablishedLinks = this.unestablishedLinks.stream().filter(l -> !l.isBetween(src, dst)).collect(Collectors.toSet());
            newEstablishedLinks = ImmutableSet.builder().addAll(this.establishedLinks).add((Object)link.get()).build();
        } else {
            Optional<PacketLinkRealizedByOptical> link = this.establishedLinks.stream().filter(l -> l.isBetween(src, dst)).findAny();
            Preconditions.checkState((boolean)link.isPresent());
            newEstablishedLinks = this.establishedLinks.stream().filter(l -> !l.isBetween(src, dst)).collect(Collectors.toSet());
            newUnestablishedLinks = ImmutableSet.builder().addAll(this.unestablishedLinks).add((Object)link.get()).build();
        }
        return new OpticalConnectivity(this.id, this.links, this.requestBandwidth, this.requestLatency, (Set<PacketLinkRealizedByOptical>)newUnestablishedLinks, (Set<PacketLinkRealizedByOptical>)newEstablishedLinks);
    }

    public Set<PacketLinkRealizedByOptical> getRealizingLinks() {
        return ImmutableSet.builder().addAll(this.unestablishedLinks).addAll(this.establishedLinks).build();
    }

    public static OpticalConnectivity copyOf(OpticalConnectivity connectivity) {
        return new OpticalConnectivity(connectivity);
    }
}

