/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.newoptical;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.util.Bandwidth;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.core.IdGenerator;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.OpticalCircuitIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.newoptical.PacketLinkRealizedByOptical;

public class PacketLinkRealizedByOpticalTest {
    private final ApplicationId appId = new DefaultApplicationId(0, "PacketLinkRealizedByOpticalTest");
    private IdGenerator idGenerator;

    @Before
    public void setUp() {
        this.idGenerator = new IdGenerator(){
            int counter = 1;

            public long getNewId() {
                return this.counter++;
            }
        };
        Intent.bindIdGenerator((IdGenerator)this.idGenerator);
    }

    @After
    public void tearDown() {
        Intent.unbindIdGenerator((IdGenerator)this.idGenerator);
    }

    @Test
    public void testCreate() {
        ConnectPoint cp1 = new ConnectPoint((ElementId)DeviceId.deviceId((String)"of:0000000000000001"), PortNumber.portNumber((long)1L));
        ConnectPoint cp2 = new ConnectPoint((ElementId)DeviceId.deviceId((String)"of:0000000000000002"), PortNumber.portNumber((long)2L));
        Key key = Key.of((long)10L, (ApplicationId)this.appId);
        Bandwidth bandwidth = Bandwidth.bps((long)100L);
        PacketLinkRealizedByOptical plink = new PacketLinkRealizedByOptical(cp1, cp2, key, bandwidth);
        Assert.assertNotNull((Object)plink);
        Assert.assertEquals((Object)plink.src(), (Object)cp1);
        Assert.assertEquals((Object)plink.dst(), (Object)cp2);
        Assert.assertEquals((long)((long)plink.bandwidth().bps()), (long)100L);
    }

    @Test
    public void testCreateWithCircuitIntent() {
        ConnectPoint cp1 = new ConnectPoint((ElementId)DeviceId.deviceId((String)"of:0000000000000001"), PortNumber.portNumber((long)1L));
        ConnectPoint cp2 = new ConnectPoint((ElementId)DeviceId.deviceId((String)"of:0000000000000002"), PortNumber.portNumber((long)2L));
        OpticalCircuitIntent circuitIntent = OpticalCircuitIntent.builder().appId(this.appId).src(cp1).dst(cp2).bidirectional(true).key(Key.of((long)0L, (ApplicationId)this.appId)).signalType(CltSignalType.CLT_1GBE).build();
        PacketLinkRealizedByOptical plink = PacketLinkRealizedByOptical.create((ConnectPoint)cp1, (ConnectPoint)cp2, (OpticalCircuitIntent)circuitIntent);
        Assert.assertNotNull((Object)plink);
        Assert.assertEquals((Object)plink.src(), (Object)cp1);
        Assert.assertEquals((Object)plink.dst(), (Object)cp2);
        Assert.assertEquals((long)((long)plink.bandwidth().bps()), (long)CltSignalType.CLT_1GBE.bitRate());
    }

    @Test
    public void testCreateWithConnectivityIntent() {
        ConnectPoint cp1 = new ConnectPoint((ElementId)DeviceId.deviceId((String)"of:0000000000000001"), PortNumber.portNumber((long)1L));
        ConnectPoint cp2 = new ConnectPoint((ElementId)DeviceId.deviceId((String)"of:0000000000000002"), PortNumber.portNumber((long)2L));
        OpticalConnectivityIntent connIntent = OpticalConnectivityIntent.builder().appId(this.appId).src(cp1).dst(cp2).bidirectional(true).key(Key.of((long)0L, (ApplicationId)this.appId)).signalType(OduSignalType.ODU4).build();
        PacketLinkRealizedByOptical plink = PacketLinkRealizedByOptical.create((ConnectPoint)cp1, (ConnectPoint)cp2, (OpticalConnectivityIntent)connIntent);
        Assert.assertNotNull((Object)plink);
        Assert.assertEquals((Object)plink.src(), (Object)cp1);
        Assert.assertEquals((Object)plink.dst(), (Object)cp2);
        Assert.assertEquals((long)((long)plink.bandwidth().bps()), (long)OduSignalType.ODU4.bitRate());
    }

    @Test
    public void testIsBetween() {
        ConnectPoint cp1 = new ConnectPoint((ElementId)DeviceId.deviceId((String)"of:0000000000000001"), PortNumber.portNumber((long)1L));
        ConnectPoint cp2 = new ConnectPoint((ElementId)DeviceId.deviceId((String)"of:0000000000000002"), PortNumber.portNumber((long)2L));
        ConnectPoint cp3 = new ConnectPoint((ElementId)DeviceId.deviceId((String)"of:0000000000000003"), PortNumber.portNumber((long)3L));
        OpticalCircuitIntent ochIntent = OpticalCircuitIntent.builder().appId(this.appId).src(cp1).dst(cp2).bidirectional(true).key(Key.of((long)0L, (ApplicationId)this.appId)).signalType(CltSignalType.CLT_1GBE).build();
        PacketLinkRealizedByOptical plink = PacketLinkRealizedByOptical.create((ConnectPoint)cp1, (ConnectPoint)cp2, (OpticalCircuitIntent)ochIntent);
        Assert.assertTrue((boolean)plink.isBetween(cp1, cp2));
        Assert.assertFalse((boolean)plink.isBetween(cp1, cp3));
    }
}

