/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.intent.impl.compiler;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Lambda;
import org.onosproject.net.Link;
import org.onosproject.net.OchSignalType;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.OpticalPathIntent;
import org.onosproject.net.intent.PathIntent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpticalPathIntentCompiler
implements IntentCompiler<OpticalPathIntent> {
    private static final Logger log = LoggerFactory.getLogger(OpticalPathIntentCompiler.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentExtensionService intentManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService = new DeviceServiceAdapter();
    private ApplicationId appId;
    private static final Set<Device.Type> TRANSPARENT_DEVICES = ImmutableSet.of((Object)Device.Type.OPTICAL_AMPLIFIER, (Object)Device.Type.FIBER_SWITCH);
    private static final Set<Device.Type> NO_FLOWRULE_DEVICES = ImmutableSet.of((Object)Device.Type.OPTICAL_AMPLIFIER);

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.net.intent");
        this.intentManager.registerCompiler(OpticalPathIntent.class, (IntentCompiler)this);
    }

    @Deactivate
    public void deactivate() {
        this.intentManager.unregisterCompiler(OpticalPathIntent.class);
    }

    public List<Intent> compile(OpticalPathIntent intent, List<Intent> installable) {
        log.debug("Compiling optical path intent between {} and {}", (Object)intent.src(), (Object)intent.dst());
        List<FlowRule> rules = this.createRules(intent);
        if (intent.isBidirectional()) {
            rules.addAll(this.createReverseRules(intent));
        }
        return Collections.singletonList(new FlowRuleIntent(this.appId, intent.key(), rules, intent.resources(), PathIntent.ProtectionType.PRIMARY, intent.resourceGroup()));
    }

    private List<FlowRule> createRules(OpticalPathIntent intent) {
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchInPort(intent.src().port());
        LinkedList<FlowRule> rules = new LinkedList<FlowRule>();
        ConnectPoint current = intent.src();
        for (Link link : intent.path().links()) {
            TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
            if (!this.isTransparent(current.deviceId())) {
                treatmentBuilder.add((Instruction)Instructions.modL0Lambda((Lambda)intent.lambda()));
            }
            treatmentBuilder.setOutput(link.src().port());
            FlowRule rule = DefaultFlowRule.builder().forDevice(current.deviceId()).withSelector(selectorBuilder.build()).withTreatment(treatmentBuilder.build()).withPriority(intent.priority()).fromApp(this.appId).makePermanent().build();
            selectorBuilder = DefaultTrafficSelector.builder();
            if (!this.isNoFlowRule(current.deviceId())) {
                rules.add(rule);
            }
            current = link.dst();
            selectorBuilder.matchInPort(link.dst().port());
            if (this.isTransparent(current.deviceId())) continue;
            selectorBuilder.add(Criteria.matchLambda((Lambda)intent.lambda()));
            selectorBuilder.add(Criteria.matchOchSignalType((OchSignalType)intent.signalType()));
        }
        TrafficTreatment.Builder treatmentLast = DefaultTrafficTreatment.builder();
        treatmentLast.setOutput(intent.dst().port());
        FlowRule rule = new DefaultFlowRule.Builder().forDevice(intent.dst().deviceId()).withSelector(selectorBuilder.build()).withTreatment(treatmentLast.build()).withPriority(intent.priority()).fromApp(this.appId).makePermanent().build();
        if (!this.isNoFlowRule(intent.dst().deviceId())) {
            rules.add(rule);
        }
        return rules;
    }

    private List<FlowRule> createReverseRules(OpticalPathIntent intent) {
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchInPort(intent.dst().port());
        LinkedList<FlowRule> rules = new LinkedList<FlowRule>();
        ConnectPoint current = intent.dst();
        for (Link link : Lists.reverse((List)intent.path().links())) {
            TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
            if (!this.isTransparent(current.deviceId())) {
                treatmentBuilder.add((Instruction)Instructions.modL0Lambda((Lambda)intent.lambda()));
            }
            treatmentBuilder.setOutput(link.dst().port());
            FlowRule rule = DefaultFlowRule.builder().forDevice(current.deviceId()).withSelector(selectorBuilder.build()).withTreatment(treatmentBuilder.build()).withPriority(intent.priority()).fromApp(this.appId).makePermanent().build();
            selectorBuilder = DefaultTrafficSelector.builder();
            if (!this.isNoFlowRule(current.deviceId())) {
                rules.add(rule);
            }
            current = link.src();
            selectorBuilder.matchInPort(link.src().port());
            if (this.isTransparent(current.deviceId())) continue;
            selectorBuilder.add(Criteria.matchLambda((Lambda)intent.lambda()));
            selectorBuilder.add(Criteria.matchOchSignalType((OchSignalType)intent.signalType()));
        }
        TrafficTreatment.Builder treatmentLast = DefaultTrafficTreatment.builder();
        treatmentLast.setOutput(intent.src().port());
        FlowRule rule = new DefaultFlowRule.Builder().forDevice(intent.src().deviceId()).withSelector(selectorBuilder.build()).withTreatment(treatmentLast.build()).withPriority(intent.priority()).fromApp(this.appId).makePermanent().build();
        if (!this.isNoFlowRule(intent.src().deviceId())) {
            rules.add(rule);
        }
        return rules;
    }

    private boolean isNoFlowRule(DeviceId deviceId) {
        return NO_FLOWRULE_DEVICES.contains(Optional.ofNullable(this.deviceService.getDevice(deviceId)).map(Device::type).orElse(Device.Type.OTHER));
    }

    private boolean isTransparent(DeviceId deviceId) {
        return TRANSPARENT_DEVICES.contains(Optional.ofNullable(this.deviceService.getDevice(deviceId)).map(Device::type).orElse(Device.Type.OTHER));
    }

    protected void bindIntentManager(IntentExtensionService intentExtensionService) {
        this.intentManager = intentExtensionService;
    }

    protected void unbindIntentManager(IntentExtensionService intentExtensionService) {
        if (this.intentManager == intentExtensionService) {
            this.intentManager = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }
}

