/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onosproject.net.Device;
import org.onosproject.net.Port;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.AbstractBehaviour;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.optical.OchPort;
import org.onosproject.net.optical.OduCltPort;
import org.onosproject.net.optical.OmsPort;
import org.onosproject.net.optical.OpticalDevice;
import org.onosproject.net.optical.OtuPort;
import org.onosproject.net.optical.device.port.OchPortMapper;
import org.onosproject.net.optical.device.port.OduCltPortMapper;
import org.onosproject.net.optical.device.port.OmsPortMapper;
import org.onosproject.net.optical.device.port.OtuPortMapper;
import org.onosproject.net.optical.device.port.PortMapper;
import org.onosproject.net.utils.ForwardingDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class DefaultOpticalDevice
extends AbstractBehaviour
implements OpticalDevice,
ForwardingDevice {
    private static final Logger log = LoggerFactory.getLogger(DefaultOpticalDevice.class);
    private static final Map<Class<? extends Port>, PortMapper<? extends Port>> MAPPERS = ImmutableMap.builder().put(OchPort.class, (Object)new OchPortMapper()).put(OmsPort.class, (Object)new OmsPortMapper()).put(OduCltPort.class, (Object)new OduCltPortMapper()).put(OtuPort.class, (Object)new OtuPortMapper()).build();
    private Device delegate;

    public Device delegate() {
        if (this.delegate == null) {
            Preconditions.checkState((this.data() != null ? 1 : 0) != 0, (Object)"DriverData must exist");
            DriverData data = this.data();
            DeviceService service = (DeviceService)DefaultServiceDirectory.getService(DeviceService.class);
            this.delegate = (Device)Preconditions.checkNotNull((Object)service.getDevice(data.deviceId()), (String)"No Device found for %s", (Object)data.deviceId());
        }
        return this.delegate;
    }

    @Override
    public <T extends Port> boolean portIs(Port port, Class<T> portClass) {
        PortMapper<? extends Port> mapper = MAPPERS.get(portClass);
        if (mapper != null) {
            return mapper.is(port);
        }
        return false;
    }

    @Override
    public <T extends Port> Optional<T> portAs(Port port, Class<T> portClass) {
        PortMapper<? extends Port> mapper = MAPPERS.get(portClass);
        if (mapper != null) {
            return mapper.as(port);
        }
        return Optional.empty();
    }

    @Override
    public Port port(Port port) {
        for (PortMapper<? extends Port> mapper : MAPPERS.values()) {
            if (!mapper.is(port)) continue;
            return mapper.as(port).map(Port.class::cast).orElse(port);
        }
        return port;
    }

    public boolean equals(Object obj) {
        return this.delegate().equals(obj);
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("delegate", (Object)this.delegate).toString();
    }
}

