/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.internal;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.PortConfigOperator;
import org.onosproject.net.config.PortConfigOperatorRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.optical.config.OpticalPortConfig;
import org.onosproject.net.optical.config.OpticalPortOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpticalModelLoader {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PortConfigOperatorRegistry portOperatorRegistry;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry netcfgRegistry;
    private OpticalPortOperator opticalPortOp;
    private ConfigFactory<ConnectPoint, OpticalPortConfig> opticalPortConfigFactory = new ConfigFactory<ConnectPoint, OpticalPortConfig>(SubjectFactories.CONNECT_POINT_SUBJECT_FACTORY, OpticalPortConfig.class, "optical"){

        public OpticalPortConfig createConfig() {
            return new OpticalPortConfig();
        }
    };

    @Activate
    protected void activate() {
        this.netcfgRegistry.registerConfigFactory(this.opticalPortConfigFactory);
        this.opticalPortOp = new OpticalPortOperator();
        this.portOperatorRegistry.registerPortConfigOperator((PortConfigOperator)this.opticalPortOp, new Class[]{OpticalPortConfig.class});
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.portOperatorRegistry.unregisterPortConfigOperator((PortConfigOperator)this.opticalPortOp);
        this.netcfgRegistry.unregisterConfigFactory(this.opticalPortConfigFactory);
        this.log.info("Stopped");
    }

    protected void bindPortOperatorRegistry(PortConfigOperatorRegistry portConfigOperatorRegistry) {
        this.portOperatorRegistry = portConfigOperatorRegistry;
    }

    protected void unbindPortOperatorRegistry(PortConfigOperatorRegistry portConfigOperatorRegistry) {
        if (this.portOperatorRegistry == portConfigOperatorRegistry) {
            this.portOperatorRegistry = null;
        }
    }

    protected void bindNetcfgRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.netcfgRegistry = networkConfigRegistry;
    }

    protected void unbindNetcfgRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.netcfgRegistry == networkConfigRegistry) {
            this.netcfgRegistry = null;
        }
    }
}

