/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.device;

import com.google.common.annotations.Beta;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.onosproject.event.Event;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.optical.OpticalDevice;
import org.onosproject.net.utils.ForwardingDeviceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class OpticalDeviceServiceView
extends ForwardingDeviceService
implements DeviceService {
    private static final Logger log = LoggerFactory.getLogger(OpticalDeviceServiceView.class);
    private final Map<DeviceListener, DeviceListener> wrapped = Maps.newIdentityHashMap();
    private final LoadingCache<Element, Optional<OpticalDevice>> optdev = CacheBuilder.newBuilder().weakKeys().maximumSize(100L).build(CacheLoader.from(elm -> {
        if (elm.is(OpticalDevice.class)) {
            return Optional.of(elm.as(OpticalDevice.class));
        }
        return Optional.empty();
    }));

    protected OpticalDeviceServiceView(DeviceService base) {
        super(base);
    }

    public static OpticalDeviceServiceView opticalView(DeviceService base) {
        return new OpticalDeviceServiceView(base);
    }

    public DeviceEvent augment(DeviceEvent event) {
        Port port = this.augment(event.port());
        if (port == event.port()) {
            return event;
        }
        return new DeviceEvent((DeviceEvent.Type)event.type(), (Device)event.subject(), port, event.time());
    }

    public Port augment(Port port) {
        if (port == null) {
            return null;
        }
        return ((Optional)this.optdev.getUnchecked((Object)port.element())).map(odev -> odev.port(port)).orElse(port);
    }

    public void addListener(DeviceListener listener) {
        super.addListener(this.wrapped.computeIfAbsent(listener, x$0 -> new OpticalDeviceListener((DeviceListener)x$0)));
    }

    public void removeListener(DeviceListener listener) {
        DeviceListener wrappedListener = this.wrapped.remove(listener);
        if (wrappedListener != null) {
            super.removeListener(wrappedListener);
        }
    }

    public List<Port> getPorts(DeviceId deviceId) {
        return Lists.transform((List)super.getPorts(deviceId), this::augment);
    }

    public PortStatistics getStatisticsForPort(DeviceId deviceId, PortNumber portNumber) {
        return null;
    }

    public PortStatistics getDeltaStatisticsForPort(DeviceId deviceId, PortNumber portNumber) {
        return null;
    }

    public Port getPort(DeviceId deviceId, PortNumber portNumber) {
        return this.augment(super.getPort(deviceId, portNumber));
    }

    class OpticalDeviceListener
    implements DeviceListener {
        private final DeviceListener listener;
        private Pair<DeviceEvent, DeviceEvent> cache;

        public OpticalDeviceListener(DeviceListener listener) {
            this.listener = listener;
        }

        private DeviceEvent opticalEvent(DeviceEvent event) {
            Pair<DeviceEvent, DeviceEvent> entry = this.cache;
            if (entry != null && entry.getLeft() == event) {
                return (DeviceEvent)entry.getRight();
            }
            DeviceEvent opticalEvent = OpticalDeviceServiceView.this.augment(event);
            this.cache = Pair.of((Object)event, (Object)opticalEvent);
            return opticalEvent;
        }

        public boolean isRelevant(DeviceEvent event) {
            return this.listener.isRelevant((Event)this.opticalEvent(event));
        }

        public void event(DeviceEvent event) {
            this.listener.event((Event)this.opticalEvent(event));
        }
    }
}

