/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.device.port;

import com.google.common.annotations.Beta;
import java.util.Optional;
import org.onosproject.net.Port;
import org.onosproject.net.optical.OtuPort;
import org.onosproject.net.optical.device.OtuPortHelper;
import org.onosproject.net.optical.device.port.AbstractPortMapper;

@Beta
public class OtuPortMapper
extends AbstractPortMapper<OtuPort> {
    @Override
    public boolean is(Port port) {
        return port != null && port.type() == Port.Type.OTU && super.is(port);
    }

    @Override
    public Optional<OtuPort> as(Port port) {
        if (port instanceof OtuPort) {
            return Optional.of((OtuPort)port);
        }
        return super.as(port);
    }

    @Override
    protected Optional<OtuPort> mapPort(Port port) {
        if (port instanceof OtuPort) {
            return Optional.of((OtuPort)port);
        }
        return OtuPortHelper.asOtuPort(port);
    }
}

