/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.intent.impl.compiler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.graph.ScalarWeight;
import org.onlab.graph.Weight;
import org.onosproject.net.Annotations;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultOchSignalComparator;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.GridType;
import org.onosproject.net.Link;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OchSignalType;
import org.onosproject.net.Path;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.intent.OpticalPathIntent;
import org.onosproject.net.optical.OchPort;
import org.onosproject.net.optical.device.OpticalDeviceServiceView;
import org.onosproject.net.optical.intent.impl.compiler.OpticalIntentCompilationException;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.Resources;
import org.onosproject.net.topology.LinkWeigher;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyEdge;
import org.onosproject.net.topology.TopologyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpticalConnectivityIntentCompiler
implements IntentCompiler<OpticalConnectivityIntent> {
    private static final Logger log = LoggerFactory.getLogger(OpticalConnectivityIntentCompiler.class);
    private static final int SLOT_COUNT = 4;
    private static final ProviderId PROVIDER_ID = new ProviderId("opticalConnectivityIntent", "org.onosproject.net.optical.intent");
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentExtensionService intentManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceService resourceService;

    @Activate
    public void activate() {
        this.deviceService = OpticalDeviceServiceView.opticalView(this.deviceService);
        this.intentManager.registerCompiler(OpticalConnectivityIntent.class, (IntentCompiler)this);
    }

    @Deactivate
    public void deactivate() {
        this.intentManager.unregisterCompiler(OpticalConnectivityIntent.class);
    }

    public List<Intent> compile(OpticalConnectivityIntent intent, List<Intent> installable) {
        ConnectPoint src = intent.getSrc();
        ConnectPoint dst = intent.getDst();
        Preconditions.checkArgument((boolean)(this.deviceService.getPort(src.deviceId(), src.port()) instanceof OchPort));
        Preconditions.checkArgument((boolean)(this.deviceService.getPort(dst.deviceId(), dst.port()) instanceof OchPort));
        LinkedList<Resource> resources = new LinkedList<Resource>();
        log.debug("Compiling optical connectivity intent between {} and {}", (Object)src, (Object)dst);
        this.resourceService.release((ResourceConsumer)intent.key());
        DiscreteResource srcPortResource = Resources.discrete((DeviceId)src.deviceId(), (PortNumber)src.port(), (Object[])new Object[0]).resource();
        DiscreteResource dstPortResource = Resources.discrete((DeviceId)dst.deviceId(), (PortNumber)dst.port(), (Object[])new Object[0]).resource();
        if (!Stream.of(srcPortResource, dstPortResource).allMatch(arg_0 -> ((ResourceService)this.resourceService).isAvailable(arg_0))) {
            log.error("Ports for the intent are not available. Intent: {}", (Object)intent);
            throw new OpticalIntentCompilationException("Ports for the intent are not available. Intent: " + intent);
        }
        resources.add((Resource)srcPortResource);
        resources.add((Resource)dstPortResource);
        Stream<Path> paths = this.getOpticalPaths(intent);
        Optional<Map.Entry> found = paths.map(path -> Maps.immutableEntry((Object)path, this.findFirstAvailableLambda(intent, (Path)path))).filter(entry -> !((List)entry.getValue()).isEmpty()).filter(entry -> this.convertToResources((Path)entry.getKey(), (Collection)entry.getValue()).stream().allMatch(arg_0 -> ((ResourceService)this.resourceService).isAvailable(arg_0))).findFirst();
        if (found.isPresent()) {
            resources.addAll(this.convertToResources((Path)found.get().getKey(), (Collection)found.get().getValue()));
            this.allocateResources((Intent)intent, resources);
            OchSignal ochSignal = OchSignal.toFixedGrid((List)((List)found.get().getValue()), (ChannelSpacing)ChannelSpacing.CHL_50GHZ);
            return ImmutableList.of((Object)this.createIntent(intent, (Path)found.get().getKey(), ochSignal));
        }
        log.error("Unable to find suitable lightpath for intent {}", (Object)intent);
        throw new OpticalIntentCompilationException("Unable to find suitable lightpath for intent " + intent);
    }

    private Intent createIntent(OpticalConnectivityIntent parentIntent, Path path, OchSignal lambda) {
        OchSignalType signalType = OchSignalType.FIXED_GRID;
        return OpticalPathIntent.builder().appId(parentIntent.appId()).key(parentIntent.key()).src(parentIntent.getSrc()).dst(parentIntent.getDst()).path(path).lambda(lambda).signalType(signalType).bidirectional(parentIntent.isBidirectional()).resourceGroup(parentIntent.resourceGroup()).build();
    }

    private List<Resource> convertToResources(Path path, Collection<OchSignal> lambda) {
        return path.links().stream().flatMap(x -> Stream.of(Resources.discrete((DeviceId)x.src().deviceId(), (PortNumber)x.src().port(), (Object[])new Object[0]).resource(), Resources.discrete((DeviceId)x.dst().deviceId(), (PortNumber)x.dst().port(), (Object[])new Object[0]).resource())).flatMap(x -> lambda.stream().map(arg_0 -> ((DiscreteResource)x).child(arg_0))).collect(Collectors.toList());
    }

    private void allocateResources(Intent intent, List<Resource> resources) {
        List allocations = this.resourceService.allocate((ResourceConsumer)intent.key(), resources);
        if (allocations.isEmpty()) {
            log.error("Resource allocation for {} failed (resource request: {})", (Object)intent.key(), resources);
            if (log.isDebugEnabled()) {
                log.debug("requested resources:\n\t{}", (Object)resources.stream().map(Object::toString).collect(Collectors.joining("\n\t")));
            }
            throw new OpticalIntentCompilationException("Unable to allocate resources: " + resources);
        }
    }

    private List<OchSignal> findFirstAvailableLambda(OpticalConnectivityIntent intent, Path path) {
        if (intent.ochSignal().isPresent()) {
            OchSignal ochSignal = (OchSignal)intent.ochSignal().get();
            if (ochSignal.gridType() == GridType.FLEX) {
                int startMultiplier = ochSignal.spacingMultiplier() - ochSignal.slotGranularity() / 2;
                return IntStream.range(0, ochSignal.slotGranularity()).mapToObj(x -> OchSignal.newFlexGridSlot((int)(startMultiplier + 2 * x))).collect(Collectors.toList());
            }
            if (ochSignal.gridType() == GridType.DWDM) {
                int startMultiplier = (int)((long)(1 - ochSignal.slotGranularity()) + (long)ochSignal.spacingMultiplier() * ochSignal.channelSpacing().frequency().asHz() / ChannelSpacing.CHL_6P25GHZ.frequency().asHz());
                return IntStream.range(0, ochSignal.slotGranularity()).mapToObj(x -> OchSignal.newFlexGridSlot((int)(startMultiplier + 2 * x))).collect(Collectors.toList());
            }
            log.error("Grid type: {} not supported for user defined signal intents", (Object)ochSignal.gridType());
            return Collections.emptyList();
        }
        Set<OchSignal> lambdas = this.findCommonLambdas(path);
        if (lambdas.isEmpty()) {
            return Collections.emptyList();
        }
        return this.findFirstLambda(lambdas, this.slotCount());
    }

    private int slotCount() {
        return 4;
    }

    private Set<OchSignal> findCommonLambdas(Path path) {
        return path.links().stream().flatMap(x -> Stream.of(Resources.discrete((DeviceId)x.src().deviceId(), (PortNumber)x.src().port(), (Object[])new Object[0]).id(), Resources.discrete((DeviceId)x.dst().deviceId(), (PortNumber)x.dst().port(), (Object[])new Object[0]).id())).map(x -> this.resourceService.getAvailableResourceValues(x, OchSignal.class)).map(x -> ImmutableSet.copyOf((Collection)x)).reduce(Sets::intersection).orElse(Collections.emptySet());
    }

    private List<OchSignal> findFirstLambda(Set<OchSignal> lambdas, int count) {
        ArrayList<OchSignal> lambdaList = new ArrayList<OchSignal>(lambdas);
        lambdaList.sort((Comparator<OchSignal>)new DefaultOchSignalComparator());
        for (int i = 0; i < lambdaList.size() - count; ++i) {
            if (((OchSignal)lambdaList.get(i)).spacingMultiplier() + 2 * count != ((OchSignal)lambdaList.get(i + count)).spacingMultiplier()) continue;
            return lambdaList.subList(i, i + count);
        }
        return Collections.emptyList();
    }

    private ConnectPoint staticPort(ConnectPoint connectPoint) {
        Port port = this.deviceService.getPort(connectPoint.deviceId(), connectPoint.port());
        String staticPort = port.annotations().value("staticPort");
        if (staticPort != null) {
            for (Port p : this.deviceService.getPorts(connectPoint.deviceId())) {
                if (!staticPort.equals(p.number().name())) continue;
                return new ConnectPoint(p.element().id(), p.number());
            }
        }
        return null;
    }

    private Stream<Path> getOpticalPaths(final OpticalConnectivityIntent intent) {
        Topology topology = this.topologyService.currentTopology();
        LinkWeigher weight = new LinkWeigher(){

            public Weight getInitialWeight() {
                return ScalarWeight.toWeight((double)0.0);
            }

            public Weight getNonViableWeight() {
                return ScalarWeight.NON_VIABLE_WEIGHT;
            }

            public Weight weight(TopologyEdge edge) {
                ConnectPoint dstStaticPort;
                ConnectPoint srcStaticPort;
                if (edge.link().state() == Link.State.INACTIVE) {
                    return ScalarWeight.toWeight((double)-1.0);
                }
                if (edge.link().type() != Link.Type.OPTICAL) {
                    return ScalarWeight.toWeight((double)-1.0);
                }
                DeviceId srcDeviceId = edge.link().src().deviceId();
                if (srcDeviceId.equals((Object)intent.getSrc().deviceId()) && (srcStaticPort = OpticalConnectivityIntentCompiler.this.staticPort(intent.getSrc())) != null) {
                    return ScalarWeight.toWeight((double)(srcStaticPort.equals((Object)edge.link().src()) ? 1.0 : -1.0));
                }
                DeviceId dstDeviceId = edge.link().dst().deviceId();
                if (dstDeviceId.equals((Object)intent.getDst().deviceId()) && (dstStaticPort = OpticalConnectivityIntentCompiler.this.staticPort(intent.getDst())) != null) {
                    return ScalarWeight.toWeight((double)(dstStaticPort.equals((Object)edge.link().dst()) ? 1.0 : -1.0));
                }
                return ScalarWeight.toWeight((double)1.0);
            }
        };
        ConnectPoint start = intent.getSrc();
        ConnectPoint end = intent.getDst();
        if (start.deviceId().equals((Object)end.deviceId())) {
            log.debug("install optical intent for 0 hop i.e srcDeviceId=dstDeviceId");
            DefaultLink defaultLink = DefaultLink.builder().providerId(PROVIDER_ID).src(start).dst(end).state(Link.State.ACTIVE).type(Link.Type.DIRECT).isExpected(true).build();
            ImmutableList links = ImmutableList.builder().add((Object)defaultLink).build();
            DefaultAnnotations annotations = DefaultAnnotations.builder().build();
            DefaultPath defaultPath = new DefaultPath(PROVIDER_ID, (List)links, null, new Annotations[]{annotations});
            return ImmutableList.builder().add((Object)defaultPath).build().stream();
        }
        Stream<Path> paths = this.topologyService.getKShortestPaths(topology, start.deviceId(), end.deviceId(), weight).filter(p -> ((Link)p.links().get(0)).src().port().equals((Object)start.port()) && ((Link)p.links().get(p.links().size() - 1)).dst().port().equals((Object)end.port()));
        if (log.isDebugEnabled()) {
            return paths.map(path -> {
                log.debug("Candidate path: {}", path.links().stream().map(lk -> lk.src() + "-" + lk.dst()).collect(Collectors.toList()));
                return path;
            });
        }
        return paths;
    }

    protected void bindIntentManager(IntentExtensionService intentExtensionService) {
        this.intentManager = intentExtensionService;
    }

    protected void unbindIntentManager(IntentExtensionService intentExtensionService) {
        if (this.intentManager == intentExtensionService) {
            this.intentManager = null;
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }
}

