/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.util.Frequency;
import org.onosproject.net.Annotations;
import org.onosproject.net.Port;
import org.onosproject.net.optical.OmsPort;
import org.onosproject.net.optical.device.OmsPortHelper;
import org.onosproject.net.utils.ForwardingPort;

@Beta
public class DefaultOmsPort
extends ForwardingPort
implements OmsPort {
    private final Frequency minFrequency;
    private final Frequency maxFrequency;
    private final Frequency grid;

    public DefaultOmsPort(Port delegate, Frequency minFrequency, Frequency maxFrequency, Frequency grid) {
        super(delegate);
        this.minFrequency = (Frequency)Preconditions.checkNotNull((Object)minFrequency);
        this.maxFrequency = (Frequency)Preconditions.checkNotNull((Object)maxFrequency);
        this.grid = (Frequency)Preconditions.checkNotNull((Object)grid);
    }

    public Port.Type type() {
        return Port.Type.OMS;
    }

    public long portSpeed() {
        return 0L;
    }

    @Override
    public Annotations unhandledAnnotations() {
        return OmsPortHelper.stripHandledAnnotations(super.annotations());
    }

    @Override
    public Frequency minFrequency() {
        return this.minFrequency;
    }

    @Override
    public Frequency maxFrequency() {
        return this.maxFrequency;
    }

    @Override
    public Frequency grid() {
        return this.grid;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minFrequency(), this.maxFrequency(), this.grid());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            DefaultOmsPort that = (DefaultOmsPort)obj;
            return super.toEqualsBuilder((Port)that).append((Object)this.minFrequency(), (Object)that.minFrequency()).append((Object)this.maxFrequency(), (Object)that.maxFrequency()).append((Object)this.grid(), (Object)that.grid()).isEquals();
        }
        return false;
    }

    public String toString() {
        return super.toStringHelper().add("minFrequency", (Object)this.minFrequency()).add("maxFrequency", (Object)this.maxFrequency()).add("grid", (Object)this.grid()).add("annotations", (Object)this.unhandledAnnotations()).toString();
    }
}

