/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.device;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.OtuSignalType;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.optical.OtuPort;
import org.onosproject.net.optical.device.FilteredAnnotation;
import org.onosproject.net.optical.impl.DefaultOtuPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class OtuPortHelper {
    private static final Logger log = LoggerFactory.getLogger(OtuPortHelper.class);
    private static final String SIGNAL_TYPE = "signalType";

    public static PortDescription otuPortDescription(PortNumber number, boolean isEnabled, OtuSignalType signalType) {
        return OtuPortHelper.otuPortDescription(number, isEnabled, signalType, DefaultAnnotations.EMPTY);
    }

    public static PortDescription otuPortDescription(PortNumber number, boolean isEnabled, OtuSignalType signalType, SparseAnnotations annotations) {
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        builder.putAll((Annotations)annotations);
        builder.set(SIGNAL_TYPE, signalType.toString());
        long portSpeed = 0L;
        return DefaultPortDescription.builder().withPortNumber(number).isEnabled(isEnabled).type(Port.Type.OTU).portSpeed(portSpeed).annotations((SparseAnnotations)builder.build()).build();
    }

    public static PortDescription otuPortDescription(PortDescription base, OtuSignalType signalType, SparseAnnotations annotations) {
        return OtuPortHelper.otuPortDescription(base.portNumber(), base.isEnabled(), signalType, annotations);
    }

    public static Optional<OtuPort> asOtuPort(Port port) {
        if (port instanceof OtuPort) {
            return Optional.of((OtuPort)port);
        }
        try {
            Annotations an = port.annotations();
            OtuSignalType signalType = Enum.valueOf(OtuSignalType.class, an.value(SIGNAL_TYPE));
            return Optional.of(new DefaultOtuPort(port, signalType));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.warn("{} was not well-formed Otu port.", (Object)port, (Object)e);
            return Optional.empty();
        }
    }

    public static Annotations stripHandledAnnotations(Annotations input) {
        return new FilteredAnnotation(input, (Set<String>)ImmutableSet.of((Object)SIGNAL_TYPE));
    }

    private OtuPortHelper() {
    }
}

