/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.device;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Set;
import org.onosproject.net.Annotations;

@Beta
public class FilteredAnnotation
implements Annotations {
    private final Annotations delegate;
    private final Set<String> filtered;

    public FilteredAnnotation(Annotations delegate, Set<String> keys) {
        this.delegate = (Annotations)Preconditions.checkNotNull((Object)delegate);
        this.filtered = ImmutableSet.copyOf(keys);
    }

    public String value(String key) {
        if (this.filtered.contains(key)) {
            return null;
        }
        return this.delegate.value(key);
    }

    public Set<String> keys() {
        return Sets.difference((Set)this.delegate.keys(), this.filtered);
    }

    public String toString() {
        HashMap mapView = new HashMap();
        this.keys().forEach(key -> mapView.put(key, this.delegate.value(key)));
        return ((Object)mapView).toString();
    }
}

