/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.device.port;

import com.google.common.annotations.Beta;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import org.onosproject.net.Port;
import org.onosproject.net.optical.device.port.PortMapper;

@Beta
public abstract class AbstractPortMapper<P extends Port>
implements PortMapper<P> {
    private final LoadingCache<Port, Optional<P>> cache = CacheBuilder.newBuilder().weakKeys().maximumSize(100L).build(CacheLoader.from(this::mapPort));

    @Override
    public boolean is(Port port) {
        return this.as(port).isPresent();
    }

    @Override
    public Optional<P> as(Port port) {
        if (port == null) {
            return Optional.empty();
        }
        return (Optional)this.cache.getUnchecked((Object)port);
    }

    protected abstract Optional<P> mapPort(Port var1);
}

