/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.EnumSet;
import org.apache.karaf.shell.commands.Command;
import org.onlab.util.Frequency;
import org.onosproject.cli.net.DevicePortsListCommand;
import org.onosproject.net.Annotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.optical.OchPort;
import org.onosproject.net.optical.OduCltPort;
import org.onosproject.net.optical.OmsPort;
import org.onosproject.net.optical.OtuPort;
import org.onosproject.net.optical.device.OpticalDeviceServiceView;

@Command(scope="onos", name="optical-ports", description="Lists all optical ports or all optical ports of a device")
public class OpticalPortsListCommand
extends DevicePortsListCommand {
    private static final String FMT = "  port=%s, state=%s, type=%s, speed=%s %s";
    private static final String FMT_OCH = "  port=%s, state=%s, type=%s, signalType=%s, isTunable=%s %s";
    private static final String FMT_ODUCLT_OTU = "  port=%s, state=%s, type=%s, signalType=%s %s";
    private static final String FMT_OMS = "  port=%s, state=%s, type=%s, freqs=%s / %s / %s GHz, totalChannels=%s %s";
    private static final EnumSet<Port.Type> OPTICAL = EnumSet.of(Port.Type.OCH, Port.Type.ODUCLT, Port.Type.OMS, Port.Type.OTU);

    protected void execute() {
        OpticalDeviceServiceView service = OpticalDeviceServiceView.opticalView((DeviceService)OpticalPortsListCommand.get(DeviceService.class));
        if (this.uri == null) {
            if (this.outputJson()) {
                this.print("%s", new Object[]{this.jsonPorts(service, OpticalPortsListCommand.getSortedDevices((DeviceService)service))});
            } else {
                for (Device device : OpticalPortsListCommand.getSortedDevices((DeviceService)service)) {
                    this.printDevice(service, device);
                    this.printPorts(service, device);
                }
            }
        } else {
            Device device = service.getDevice(DeviceId.deviceId((String)this.uri));
            if (device == null) {
                this.error("No such device %s", new Object[]{this.uri});
            } else if (this.outputJson()) {
                this.print("%s", new Object[]{this.jsonPorts(service, new ObjectMapper(), device)});
            } else {
                this.printDevice(service, device);
                this.printPorts(service, device);
            }
        }
    }

    protected boolean isIncluded(Port port) {
        return OPTICAL.contains(port.type()) && super.isIncluded(port);
    }

    protected void printPorts(DeviceService service, Device device) {
        ArrayList ports = new ArrayList(service.getPorts(device.id()));
        ports.sort((p1, p2) -> Long.signum(p1.number().toLong() - p2.number().toLong()));
        for (Port port : ports) {
            if (!this.isIncluded(port)) continue;
            String portName = port.number().toString();
            String portIsEnabled = port.isEnabled() ? "enabled" : "disabled";
            String portType = port.type().toString().toLowerCase();
            switch (port.type()) {
                case OCH: {
                    if (port instanceof OchPort) {
                        OchPort och = (OchPort)port;
                        this.print(FMT_OCH, new Object[]{portName, portIsEnabled, portType, och.signalType().toString(), och.isTunable() ? "yes" : "no", OpticalPortsListCommand.annotations((Annotations)och.unhandledAnnotations())});
                        break;
                    }
                    this.print("WARN: OchPort but not on OpticalDevice or ill-formed", new Object[0]);
                    this.print(FMT, new Object[]{portName, portIsEnabled, portType, port.portSpeed(), OpticalPortsListCommand.annotations((Annotations)port.annotations())});
                    break;
                }
                case ODUCLT: {
                    if (port instanceof OduCltPort) {
                        OduCltPort oduCltPort = (OduCltPort)port;
                        this.print(FMT_ODUCLT_OTU, new Object[]{portName, portIsEnabled, portType, oduCltPort.signalType().toString(), OpticalPortsListCommand.annotations((Annotations)oduCltPort.unhandledAnnotations())});
                        break;
                    }
                    this.print("WARN: OduCltPort but not on OpticalDevice or ill-formed", new Object[0]);
                    this.print(FMT, new Object[]{portName, portIsEnabled, portType, port.portSpeed(), OpticalPortsListCommand.annotations((Annotations)port.annotations())});
                    break;
                }
                case OMS: {
                    if (port instanceof OmsPort) {
                        OmsPort oms = (OmsPort)port;
                        this.print(FMT_OMS, new Object[]{portName, portIsEnabled, portType, oms.minFrequency().asHz() / Frequency.ofGHz((long)1L).asHz(), oms.maxFrequency().asHz() / Frequency.ofGHz((long)1L).asHz(), oms.grid().asHz() / Frequency.ofGHz((long)1L).asHz(), oms.totalChannels(), OpticalPortsListCommand.annotations((Annotations)oms.unhandledAnnotations())});
                        break;
                    }
                    this.print("WARN: OmsPort but not on OpticalDevice or ill-formed", new Object[0]);
                    this.print(FMT, new Object[]{portName, portIsEnabled, portType, port.portSpeed(), OpticalPortsListCommand.annotations((Annotations)port.annotations())});
                    break;
                }
                case OTU: {
                    if (port instanceof OtuPort) {
                        OtuPort otuPort = (OtuPort)port;
                        this.print(FMT_ODUCLT_OTU, new Object[]{portName, portIsEnabled, portType, otuPort.signalType().toString(), OpticalPortsListCommand.annotations((Annotations)otuPort.unhandledAnnotations())});
                        break;
                    }
                    this.print("WARN: OtuPort but not on OpticalDevice or ill-formed", new Object[0]);
                    this.print(FMT, new Object[]{portName, portIsEnabled, portType, port.portSpeed(), OpticalPortsListCommand.annotations((Annotations)port.annotations())});
                    break;
                }
            }
        }
    }
}

