/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.Annotations;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.Port;
import org.onosproject.net.optical.OduCltPort;
import org.onosproject.net.optical.device.OduCltPortHelper;
import org.onosproject.net.utils.ForwardingPort;

@Beta
public class DefaultOduCltPort
extends ForwardingPort
implements OduCltPort {
    private final CltSignalType signalType;

    public DefaultOduCltPort(Port delegate, CltSignalType signalType) {
        super(delegate);
        this.signalType = (CltSignalType)Preconditions.checkNotNull((Object)signalType);
    }

    public Port.Type type() {
        return Port.Type.ODUCLT;
    }

    public long portSpeed() {
        return this.signalType().bitRate();
    }

    @Override
    public Annotations unhandledAnnotations() {
        return OduCltPortHelper.stripHandledAnnotations(super.annotations());
    }

    @Override
    public CltSignalType signalType() {
        return this.signalType;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.signalType());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            DefaultOduCltPort that = (DefaultOduCltPort)obj;
            return super.toEqualsBuilder((Port)that).append((Object)this.signalType(), (Object)that.signalType()).isEquals();
        }
        return false;
    }

    public String toString() {
        return super.toStringHelper().add("signalType", (Object)this.signalType()).add("annotations", (Object)this.unhandledAnnotations()).toString();
    }
}

