/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.cli;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.app.AllApplicationNamesCompleter;
import org.onosproject.cli.net.ConnectPointCompleter;
import org.onosproject.cli.net.ConnectivityIntentCommand;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.GridType;
import org.onosproject.net.OchSignal;
import org.onosproject.net.Port;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.optical.util.OpticalIntentUtility;

@Command(scope="onos", name="add-optical-intent", description="Installs optical connectivity intent")
public class AddOpticalIntentCommand
extends ConnectivityIntentCommand {
    private static final String SIGNAL_FORMAT = "slotGranularity/channelSpacing(in GHz e.g 6.25,12.5,25,50,100)/spaceMultiplier/gridType(cwdm, flex, dwdm) e.g 1/6.25/1/flex";
    private static final String CH_6P25 = "6.25";
    private static final String CH_12P5 = "12.5";
    private static final String CH_25 = "25";
    private static final String CH_50 = "50";
    private static final String CH_100 = "100";
    private static final Map<String, ChannelSpacing> CHANNEL_SPACING_MAP = ImmutableMap.builder().put((Object)"6.25", (Object)ChannelSpacing.CHL_6P25GHZ).put((Object)"12.5", (Object)ChannelSpacing.CHL_12P5GHZ).put((Object)"25", (Object)ChannelSpacing.CHL_25GHZ).put((Object)"50", (Object)ChannelSpacing.CHL_50GHZ).put((Object)"100", (Object)ChannelSpacing.CHL_100GHZ).build();
    private ConnectPointCompleter cpCompleter;
    private AllApplicationNamesCompleter appCompleter;
    @Argument(index=0, name="ingress", description="Ingress Device/Port Description", required=true, multiValued=false)
    String ingressString = "";
    @Argument(index=1, name="egress", description="Egress Device/Port Description", required=true, multiValued=false)
    String egressString = "";
    @Option(name="-b", aliases={"--bidirectional"}, description="If this argument is passed the optical link created will be bidirectional, else the link will be unidirectional.", required=false, multiValued=false)
    private boolean bidirectional = false;
    @Option(name="-s", aliases={"--signal"}, description="Optical Signal. Format = slotGranularity/channelSpacing(in GHz e.g 6.25,12.5,25,50,100)/spaceMultiplier/gridType(cwdm, flex, dwdm) e.g 1/6.25/1/flex", required=false, multiValued=false)
    private String signal;

    private ConnectPoint createConnectPoint(String devicePortString) {
        String[] splitted = devicePortString.split("/");
        Preconditions.checkArgument((splitted.length == 2 ? 1 : 0) != 0, (Object)"Connect point must be in \"deviceUri/portNumber\" format");
        DeviceId deviceId = DeviceId.deviceId((String)splitted[0]);
        DeviceService deviceService = (DeviceService)AddOpticalIntentCommand.get(DeviceService.class);
        List ports = deviceService.getPorts(deviceId);
        for (Port port : ports) {
            if (!splitted[1].equals(port.number().name())) continue;
            return new ConnectPoint((ElementId)deviceId, port.number());
        }
        return null;
    }

    private OchSignal createOchSignal() throws IllegalArgumentException {
        if (this.signal == null) {
            return null;
        }
        try {
            String[] splitted = this.signal.split("/");
            Preconditions.checkArgument((splitted.length == 4 ? 1 : 0) != 0, (Object)"signal requires 4 parameters: slotGranularity/channelSpacing(in GHz e.g 6.25,12.5,25,50,100)/spaceMultiplier/gridType(cwdm, flex, dwdm) e.g 1/6.25/1/flex");
            int slotGranularity = Integer.parseInt(splitted[0]);
            String chSpacing = splitted[1];
            ChannelSpacing channelSpacing = (ChannelSpacing)Preconditions.checkNotNull((Object)CHANNEL_SPACING_MAP.get(chSpacing), (Object)String.format("invalid channel spacing: %s", chSpacing));
            int multiplier = Integer.parseInt(splitted[2]);
            String gdType = splitted[3].toUpperCase();
            GridType gridType = GridType.valueOf((String)gdType);
            return new OchSignal(gridType, channelSpacing, multiplier, slotGranularity);
        }
        catch (RuntimeException e) {
            String msg = String.format("Invalid signal format: %s, expected format is %s.", this.signal, SIGNAL_FORMAT);
            this.print(msg, new Object[0]);
            throw new IllegalArgumentException(msg, e);
        }
    }

    protected void execute() {
        IntentService service = (IntentService)AddOpticalIntentCommand.get(IntentService.class);
        DeviceService deviceService = (DeviceService)AddOpticalIntentCommand.get(DeviceService.class);
        ConnectPoint ingress = this.createConnectPoint(this.ingressString);
        ConnectPoint egress = this.createConnectPoint(this.egressString);
        Intent intent = OpticalIntentUtility.createOpticalIntent(ingress, egress, deviceService, this.key(), this.appId(), this.bidirectional, this.createOchSignal());
        service.submit(intent);
        this.print("Optical intent submitted:\n%s", new Object[]{intent.toString()});
    }
}

