/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.config;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.PortConfigOperator;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.optical.config.OpticalPortConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpticalPortOperator
implements PortConfigOperator {
    private static final Logger log = LoggerFactory.getLogger(OpticalPortOperator.class);
    private final Set<Port.Type> optical = Sets.immutableEnumSet((Enum)Port.Type.ODUCLT, (Enum[])new Port.Type[]{Port.Type.OMS, Port.Type.OCH, Port.Type.OTU, Port.Type.FIBER, Port.Type.PACKET});
    private NetworkConfigService networkConfigService;

    public void bindService(NetworkConfigService networkConfigService) {
        this.networkConfigService = networkConfigService;
    }

    private OpticalPortConfig lookupConfig(ConnectPoint cp) {
        if (this.networkConfigService == null) {
            return null;
        }
        return (OpticalPortConfig)this.networkConfigService.getConfig((Object)cp, OpticalPortConfig.class);
    }

    public PortDescription combine(ConnectPoint cp, PortDescription descr) {
        Preconditions.checkNotNull((Object)cp);
        if (descr != null && !this.optical.contains(descr.type())) {
            return descr;
        }
        OpticalPortConfig opc = this.lookupConfig(cp);
        if (descr == null || opc == null) {
            return descr;
        }
        PortNumber number = descr.portNumber();
        if (!opc.name().isEmpty()) {
            number = PortNumber.portNumber((long)descr.portNumber().toLong(), (String)opc.name());
        }
        SparseAnnotations annotations = OpticalPortOperator.combine(opc, descr.annotations());
        Port.Type type = (Port.Type)MoreObjects.firstNonNull((Object)opc.type(), (Object)descr.type());
        if (type != descr.type()) {
            log.warn("Port type overwrite requested for {}. Ignoring.", (Object)cp);
        }
        return OpticalPortOperator.updateDescription(number, annotations, descr);
    }

    private static PortDescription updateDescription(PortNumber port, SparseAnnotations sa, PortDescription descr) {
        if (port.exactlyEquals(descr.portNumber()) && sa.equals(descr.annotations())) {
            return descr;
        }
        return DefaultPortDescription.builder((PortDescription)descr).withPortNumber(port).annotations(sa).build();
    }

    private static SparseAnnotations combine(OpticalPortConfig opc, SparseAnnotations an) {
        DefaultAnnotations.Builder b = DefaultAnnotations.builder();
        b.putAll((Annotations)an);
        if (!opc.staticPort().isEmpty()) {
            b.set("staticPort", opc.staticPort());
        }
        if (opc.staticLambda().isPresent()) {
            b.set("staticLambda", String.valueOf(opc.staticLambda().get()));
        }
        if (!opc.name().isEmpty()) {
            b.set("portName", opc.name());
        }
        return b.build();
    }
}

