/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.device;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.onosproject.net.Annotations;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.optical.OduCltPort;
import org.onosproject.net.optical.device.FilteredAnnotation;
import org.onosproject.net.optical.impl.DefaultOduCltPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class OduCltPortHelper {
    private static final Logger log = LoggerFactory.getLogger(OduCltPortHelper.class);
    private static final String SIGNAL_TYPE = "signalType";

    public static PortDescription oduCltPortDescription(PortNumber number, boolean isEnabled, CltSignalType signalType) {
        return OduCltPortHelper.oduCltPortDescription(number, isEnabled, signalType, DefaultAnnotations.EMPTY);
    }

    public static PortDescription oduCltPortDescription(PortNumber number, boolean isEnabled, CltSignalType signalType, SparseAnnotations annotations) {
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        builder.putAll((Annotations)annotations);
        builder.set(SIGNAL_TYPE, signalType.toString());
        long portSpeed = signalType.bitRate();
        return DefaultPortDescription.builder().withPortNumber(number).isEnabled(isEnabled).type(Port.Type.ODUCLT).portSpeed(portSpeed).annotations((SparseAnnotations)builder.build()).build();
    }

    public static PortDescription oduCltPortDescription(PortDescription base, CltSignalType signalType, SparseAnnotations annotations) {
        return OduCltPortHelper.oduCltPortDescription(base.portNumber(), base.isEnabled(), signalType, annotations);
    }

    public static Optional<OduCltPort> asOduCltPort(Port port) {
        if (port instanceof OduCltPort) {
            return Optional.of((OduCltPort)port);
        }
        try {
            Annotations an = port.annotations();
            CltSignalType signalType = Enum.valueOf(CltSignalType.class, an.value(SIGNAL_TYPE));
            return Optional.of(new DefaultOduCltPort(port, signalType));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.warn("{} was not well-formed OduClt port.", (Object)port, (Object)e);
            return Optional.empty();
        }
    }

    public static Annotations stripHandledAnnotations(Annotations input) {
        return new FilteredAnnotation(input, (Set<String>)ImmutableSet.of((Object)SIGNAL_TYPE));
    }

    private OduCltPortHelper() {
    }
}

