/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.Annotations;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.Port;
import org.onosproject.net.optical.OchPort;
import org.onosproject.net.optical.device.OchPortHelper;
import org.onosproject.net.utils.ForwardingPort;

@Beta
public class DefaultOchPort
extends ForwardingPort
implements OchPort {
    private final OduSignalType signalType;
    private final boolean isTunable;
    private final OchSignal lambda;

    public DefaultOchPort(Port base, OduSignalType signalType, boolean isTunable, OchSignal lambda) {
        super(base);
        this.signalType = (OduSignalType)Preconditions.checkNotNull((Object)signalType);
        this.isTunable = isTunable;
        this.lambda = (OchSignal)Preconditions.checkNotNull((Object)lambda);
    }

    public Port.Type type() {
        return Port.Type.OCH;
    }

    public long portSpeed() {
        return this.signalType.bitRate();
    }

    @Override
    public Annotations unhandledAnnotations() {
        return OchPortHelper.stripHandledAnnotations(super.annotations());
    }

    @Override
    public OduSignalType signalType() {
        return this.signalType;
    }

    @Override
    public boolean isTunable() {
        return this.isTunable;
    }

    @Override
    public OchSignal lambda() {
        return this.lambda;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.signalType(), this.isTunable(), this.lambda());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            DefaultOchPort that = (DefaultOchPort)obj;
            return super.toEqualsBuilder((Port)that).append((Object)this.signalType(), (Object)that.signalType()).append(this.isTunable(), that.isTunable()).append((Object)this.lambda(), (Object)that.lambda()).isEquals();
        }
        return false;
    }

    public String toString() {
        return super.toStringHelper().add("signalType", (Object)this.signalType()).add("isTunable", this.isTunable()).add("lambda", (Object)this.lambda()).add("annotations", (Object)this.unhandledAnnotations()).toString();
    }
}

