/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.device;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.onlab.util.Frequency;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.optical.OmsPort;
import org.onosproject.net.optical.device.FilteredAnnotation;
import org.onosproject.net.optical.impl.DefaultOmsPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class OmsPortHelper {
    private static final Logger log = LoggerFactory.getLogger(OmsPortHelper.class);

    public static PortDescription omsPortDescription(PortNumber number, boolean isEnabled, Frequency minFrequency, Frequency maxFrequency, Frequency grid, SparseAnnotations annotations) {
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        builder.putAll((Annotations)annotations);
        builder.set("minFrequency", String.valueOf(minFrequency.asHz()));
        builder.set("maxFrequency", String.valueOf(maxFrequency.asHz()));
        builder.set("grid", String.valueOf(grid.asHz()));
        long portSpeed = 0L;
        return DefaultPortDescription.builder().withPortNumber(number).isEnabled(isEnabled).type(Port.Type.OMS).portSpeed(portSpeed).annotations((SparseAnnotations)builder.build()).build();
    }

    public static PortDescription omsPortDescription(PortNumber number, boolean isEnabled, Frequency minFrequency, Frequency maxFrequency, Frequency grid) {
        return OmsPortHelper.omsPortDescription(number, isEnabled, minFrequency, maxFrequency, grid, DefaultAnnotations.EMPTY);
    }

    public static PortDescription omsPortDescription(PortDescription base, Frequency minFrequency, Frequency maxFrequency, Frequency grid, SparseAnnotations annotations) {
        return OmsPortHelper.omsPortDescription(base.portNumber(), base.isEnabled(), minFrequency, maxFrequency, grid, annotations);
    }

    public static Optional<OmsPort> asOmsPort(Port port) {
        if (port instanceof OmsPort) {
            return Optional.of((OmsPort)port);
        }
        try {
            Annotations an = port.annotations();
            Frequency minFrequency = Frequency.ofHz((long)Long.parseLong(an.value("minFrequency")));
            Frequency maxFrequency = Frequency.ofHz((long)Long.parseLong(an.value("maxFrequency")));
            Frequency grid = Frequency.ofHz((long)Long.parseLong(an.value("grid")));
            return Optional.of(new DefaultOmsPort(port, minFrequency, maxFrequency, grid));
        }
        catch (NumberFormatException e) {
            log.warn("{} was not well-formed OMS port.", (Object)port, (Object)e);
            return Optional.empty();
        }
    }

    public static Annotations stripHandledAnnotations(Annotations input) {
        return new FilteredAnnotation(input, (Set<String>)ImmutableSet.of((Object)"minFrequency", (Object)"maxFrequency", (Object)"grid"));
    }

    private OmsPortHelper() {
    }
}

