/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.util;

import org.onosproject.core.ApplicationId;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.Port;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.OpticalCircuitIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.intent.OpticalOduIntent;
import org.onosproject.net.optical.OchPort;
import org.onosproject.net.optical.OduCltPort;
import org.onosproject.net.optical.device.OpticalDeviceServiceView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpticalIntentUtility {
    private static final Logger log = LoggerFactory.getLogger(OpticalIntentUtility.class);

    private OpticalIntentUtility() {
    }

    public static Intent createOpticalIntent(ConnectPoint ingress, ConnectPoint egress, DeviceService deviceService, Key key, ApplicationId appId, boolean bidirectional, OchSignal signal) {
        OpticalConnectivityIntent intent = null;
        if (ingress == null || egress == null) {
            log.debug("Invalid endpoint(s); could not create optical intent");
            return intent;
        }
        OpticalDeviceServiceView ds = OpticalDeviceServiceView.opticalView(deviceService);
        Port srcPort = ds.getPort(ingress.deviceId(), ingress.port());
        Port dstPort = ds.getPort(egress.deviceId(), egress.port());
        if (srcPort instanceof OduCltPort && dstPort instanceof OduCltPort) {
            Device srcDevice = ds.getDevice(ingress.deviceId());
            Device dstDevice = ds.getDevice(egress.deviceId());
            if (!srcDevice.type().equals((Object)dstDevice.type())) {
                log.debug("Devices without same deviceType: SRC=%s and DST=%s", (Object)srcDevice.type(), (Object)dstDevice.type());
                return intent;
            }
            CltSignalType signalType = ((OduCltPort)srcPort).signalType();
            if (Device.Type.ROADM.equals((Object)srcDevice.type()) || Device.Type.ROADM_OTN.equals((Object)srcDevice.type())) {
                intent = OpticalCircuitIntent.builder().appId(appId).key(key).src(ingress).dst(egress).signalType(signalType).bidirectional(bidirectional).build();
            } else if (Device.Type.OTN.equals((Object)srcDevice.type())) {
                intent = OpticalOduIntent.builder().appId(appId).key(key).src(ingress).dst(egress).signalType(signalType).bidirectional(bidirectional).build();
            } else {
                log.debug("Wrong Device Type for connect points %s and %s", (Object)ingress, (Object)egress);
            }
        } else if (srcPort instanceof OchPort && dstPort instanceof OchPort) {
            OduSignalType signalType = ((OchPort)srcPort).signalType();
            intent = OpticalConnectivityIntent.builder().appId(appId).key(key).src(ingress).dst(egress).signalType(signalType).bidirectional(bidirectional).ochSignal(signal).build();
        } else {
            log.debug("Unable to create optical intent between connect points %s and %s", (Object)ingress, (Object)egress);
        }
        return intent;
    }
}

