/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.device;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.optical.OchPort;
import org.onosproject.net.optical.device.FilteredAnnotation;
import org.onosproject.net.optical.impl.DefaultOchPort;
import org.onosproject.net.optical.json.OchSignalCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class OchPortHelper {
    private static final Logger log = LoggerFactory.getLogger(OchPortHelper.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String SIGNAL_TYPE = "signalType";
    private static final String TUNABLE = "tunable";
    private static final String LAMBDA = "lambda";

    public static PortDescription ochPortDescription(PortNumber number, boolean isEnabled, OduSignalType signalType, boolean isTunable, OchSignal lambda) {
        return OchPortHelper.ochPortDescription(number, isEnabled, signalType, isTunable, lambda, DefaultAnnotations.EMPTY);
    }

    public static PortDescription ochPortDescription(PortNumber number, boolean isEnabled, OduSignalType signalType, boolean isTunable, OchSignal lambda, SparseAnnotations annotationsIn) {
        DefaultAnnotations.Builder builder = DefaultAnnotations.builder();
        builder.putAll((Annotations)annotationsIn);
        builder.set(TUNABLE, String.valueOf(isTunable));
        builder.set(LAMBDA, OchSignalCodec.encode(lambda).toString());
        builder.set(SIGNAL_TYPE, signalType.toString());
        DefaultAnnotations annotations = builder.build();
        long portSpeed = signalType.bitRate();
        return DefaultPortDescription.builder().withPortNumber(number).isEnabled(isEnabled).type(Port.Type.OCH).portSpeed(portSpeed).annotations((SparseAnnotations)annotations).build();
    }

    public static PortDescription ochPortDescription(PortDescription base, OduSignalType signalType, boolean isTunable, OchSignal lambda, SparseAnnotations annotations) {
        return OchPortHelper.ochPortDescription(base.portNumber(), base.isEnabled(), signalType, isTunable, lambda, annotations);
    }

    public static Optional<OchPort> asOchPort(Port port) {
        if (port instanceof OchPort) {
            return Optional.of((OchPort)port);
        }
        try {
            Annotations an = port.annotations();
            OduSignalType signalType = Enum.valueOf(OduSignalType.class, an.value(SIGNAL_TYPE));
            boolean isTunable = Boolean.valueOf(an.value(TUNABLE));
            ObjectNode obj = (ObjectNode)MAPPER.readTree(an.value(LAMBDA));
            OchSignal lambda = OchSignalCodec.decode(obj);
            return Optional.of(new DefaultOchPort(port, signalType, isTunable, lambda));
        }
        catch (IOException | ClassCastException | IllegalArgumentException | NullPointerException e) {
            log.warn("{} was not well-formed OCh port.", (Object)port, (Object)e);
            return Optional.empty();
        }
    }

    public static Annotations stripHandledAnnotations(Annotations input) {
        return new FilteredAnnotation(input, (Set<String>)ImmutableSet.of((Object)SIGNAL_TYPE, (Object)TUNABLE, (Object)LAMBDA));
    }

    private OchPortHelper() {
    }
}

