/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.NetworkConfigServiceAdapter;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.optical.config.OpticalPortConfig;
import org.onosproject.net.optical.config.OpticalPortOperator;
import org.onosproject.net.optical.device.OduCltPortHelper;

public class OpticalPortOperatorTest {
    private static final DeviceId DID = DeviceId.deviceId((String)"op-test");
    private static final long PORT_NUMBER = 100L;
    private static final String CFG_KEY = "optical";
    private static final String CFG_PORT_NAME = "cfg-name";
    private static final long CFG_STATIC_LAMBDA = 300L;
    private static final String DESC_PORT_NAME = "test-port-100";
    private static final PortNumber NAMED = PortNumber.portNumber((long)100L, (String)"test-port-100");
    private static final PortNumber UNNAMED = PortNumber.portNumber((long)100L);
    private static final String DESC_STATIC_PORT = "out-port-200";
    private static final SparseAnnotations SA = DefaultAnnotations.builder().set("staticPort", "out-port-200").build();
    private static final PortDescription N_DESC = OduCltPortHelper.oduCltPortDescription((PortNumber)NAMED, (boolean)true, (CltSignalType)CltSignalType.CLT_100GBE, (SparseAnnotations)SA);
    private static final PortDescription U_DESC = OduCltPortHelper.oduCltPortDescription((PortNumber)UNNAMED, (boolean)true, (CltSignalType)CltSignalType.CLT_100GBE, (SparseAnnotations)SA);
    private final ConfigApplyDelegate delegate = new MockCfgDelegate();
    private final ObjectMapper mapper = new ObjectMapper();
    private static final ConnectPoint CP = new ConnectPoint((ElementId)DID, UNNAMED);
    private OpticalPortConfig opc;
    private OpticalPortOperator oper;

    @Before
    public void setUp() {
        this.opc = new OpticalPortConfig();
        this.opc.init((Object)CP, CFG_KEY, (JsonNode)JsonNodeFactory.instance.objectNode(), this.mapper, this.delegate);
        this.oper = new OpticalPortOperator();
        this.oper.bindService((NetworkConfigService)new MockNetworkConfigService());
    }

    @Test
    public void testConfigPortName() {
        this.opc.portType(Port.Type.ODUCLT).portNumberName(Long.valueOf(100L)).portName(CFG_PORT_NAME);
        PortDescription res = this.oper.combine(CP, N_DESC);
        Assert.assertEquals((String)"Configured port name expected", (Object)CFG_PORT_NAME, (Object)res.portNumber().name());
        Assert.assertEquals((Object)DESC_STATIC_PORT, (Object)res.annotations().value("staticPort"));
        res = this.oper.combine(CP, U_DESC);
        Assert.assertEquals((String)"Configured port name expected", (Object)CFG_PORT_NAME, (Object)res.portNumber().name());
        Assert.assertEquals((Object)DESC_STATIC_PORT, (Object)res.annotations().value("staticPort"));
    }

    @Test
    public void testConfigAddStaticLambda() {
        this.opc.portType(Port.Type.ODUCLT).portNumberName(Long.valueOf(100L)).staticLambda(Long.valueOf(300L));
        PortDescription res = this.oper.combine(CP, N_DESC);
        Assert.assertEquals((String)"Original port name expected", (Object)DESC_PORT_NAME, (Object)res.portNumber().name());
        Assert.assertEquals((Object)DESC_STATIC_PORT, (Object)res.annotations().value("staticPort"));
        long sl = Long.valueOf(res.annotations().value("staticLambda"));
        Assert.assertEquals((long)300L, (long)sl);
    }

    @Test
    public void testEmptyConfig() {
        this.opc.portType(Port.Type.ODUCLT).portNumberName(Long.valueOf(100L));
        PortDescription res = this.oper.combine(CP, N_DESC);
        Assert.assertEquals((String)"Configured port name expected", (Object)DESC_PORT_NAME, (Object)res.portNumber().name());
        Assert.assertEquals((Object)DESC_STATIC_PORT, (Object)res.annotations().value("staticPort"));
    }

    private class MockCfgDelegate
    implements ConfigApplyDelegate {
        private MockCfgDelegate() {
        }

        public void onApply(Config config) {
            config.apply();
        }
    }

    private class MockNetworkConfigService
    extends NetworkConfigServiceAdapter {
        private MockNetworkConfigService() {
        }

        public <S, C extends Config<S>> C getConfig(S subject, Class<C> configClass) {
            if (configClass == OpticalPortConfig.class) {
                return (C)OpticalPortOperatorTest.this.opc;
            }
            return null;
        }
    }
}

