/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.intent.impl.compiler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.TestApplicationId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.OchSignalType;
import org.onosproject.net.Path;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.MockIdGenerator;
import org.onosproject.net.intent.OpticalPathIntent;
import org.onosproject.net.optical.intent.impl.compiler.OpticalPathIntentCompiler;

public class OpticalPathIntentCompilerTest {
    private CoreService coreService;
    private IntentExtensionService intentExtensionService;
    private final IdGenerator idGenerator = new MockIdGenerator();
    private OpticalPathIntentCompiler sut;
    private final ApplicationId appId = new TestApplicationId("test");
    private final ConnectPoint d1p1 = NetTestTools.connectPoint((String)"s1", (int)0);
    private final ConnectPoint d2p0 = NetTestTools.connectPoint((String)"s2", (int)0);
    private final ConnectPoint d2p1 = NetTestTools.connectPoint((String)"s2", (int)1);
    private final ConnectPoint d3p1 = NetTestTools.connectPoint((String)"s3", (int)1);
    private final List<Link> links = Arrays.asList(DefaultLink.builder().providerId(NetTestTools.PID).src(this.d1p1).dst(this.d2p0).type(Link.Type.DIRECT).build(), DefaultLink.builder().providerId(NetTestTools.PID).src(this.d2p1).dst(this.d3p1).type(Link.Type.DIRECT).build());
    private final int hops = this.links.size() + 1;
    private OpticalPathIntent intent;

    @Before
    public void setUp() {
        this.sut = new OpticalPathIntentCompiler();
        this.coreService = (CoreService)EasyMock.createMock(CoreService.class);
        EasyMock.expect((Object)this.coreService.registerApplication("org.onosproject.net.intent")).andReturn((Object)this.appId);
        this.sut.coreService = this.coreService;
        Intent.bindIdGenerator((IdGenerator)this.idGenerator);
        this.intent = OpticalPathIntent.builder().appId(this.appId).src(this.d1p1).dst(this.d3p1).path((Path)new DefaultPath(NetTestTools.PID, this.links, (double)this.hops, new Annotations[0])).lambda(NetTestTools.createLambda()).signalType(OchSignalType.FIXED_GRID).build();
        this.intentExtensionService = (IntentExtensionService)EasyMock.createMock(IntentExtensionService.class);
        this.intentExtensionService.registerCompiler(OpticalPathIntent.class, (IntentCompiler)this.sut);
        this.intentExtensionService.unregisterCompiler(OpticalPathIntent.class);
        this.sut.intentManager = this.intentExtensionService;
        EasyMock.replay((Object[])new Object[]{this.coreService, this.intentExtensionService});
    }

    @After
    public void tearDown() {
        Intent.unbindIdGenerator((IdGenerator)this.idGenerator);
    }

    @Test
    public void testCompiler() {
        this.sut.activate();
        List compiled = this.sut.compile(this.intent, Collections.emptyList());
        MatcherAssert.assertThat((Object)compiled, (Matcher)Matchers.hasSize((int)1));
        Collection rules = ((FlowRuleIntent)compiled.get(0)).flowRules();
        rules.stream().filter(x -> x.deviceId().equals((Object)this.d1p1.deviceId())).findFirst().get();
        rules.stream().filter(x -> x.deviceId().equals((Object)this.d2p1.deviceId())).findFirst().get();
        rules.stream().filter(x -> x.deviceId().equals((Object)this.d3p1.deviceId())).findFirst().get();
        rules.forEach(rule -> Assert.assertEquals((String)"FlowRule priority is incorrect", (long)this.intent.priority(), (long)rule.priority()));
        this.sut.deactivate();
    }
}

