/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.intent.impl.compiler;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.OduSignalId;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.OduSignalUtils;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.TributarySlot;
import org.onosproject.net.behaviour.TributarySlotQuery;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentSetMultimap;
import org.onosproject.net.intent.OpticalCircuitIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.optical.OchPort;
import org.onosproject.net.optical.OduCltPort;
import org.onosproject.net.optical.device.OpticalDeviceServiceView;
import org.onosproject.net.optical.intent.impl.compiler.OpticalIntentCompilationException;
import org.onosproject.net.optical.intent.impl.compiler.ResourceHelper;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceId;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.Resources;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpticalCircuitIntentCompiler
implements IntentCompiler<OpticalCircuitIntent> {
    private static final Logger log = LoggerFactory.getLogger(OpticalCircuitIntentCompiler.class);
    private static final int DEFAULT_MAX_CAPACITY = 10;
    @Property(name="maxCapacity", intValue={10}, label="Maximum utilization of an optical connection.")
    private int maxCapacity = 10;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService cfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentExtensionService intentManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceService resourceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentSetMultimap intentSetMultimap;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    private ApplicationId appId;

    @Modified
    public void modified(ComponentContext context) {
        if (context == null) {
            return;
        }
        Dictionary properties = context.getProperties();
        String propertyString = Tools.get((Dictionary)properties, (String)"maxCapacity");
        if (!Strings.isNullOrEmpty((String)propertyString)) {
            try {
                int temp = Integer.parseInt(propertyString);
                if (temp >= 0) {
                    this.maxCapacity = temp;
                }
            }
            catch (NumberFormatException e) {
                log.error("The value '{}' for maxCapacity was not parsable as an integer.", (Object)propertyString, (Object)e);
            }
        } else {
            log.error("The value for maxCapacity was set to an empty value.");
        }
    }

    @Activate
    public void activate(ComponentContext context) {
        this.deviceService = OpticalDeviceServiceView.opticalView(this.deviceService);
        this.appId = this.coreService.registerApplication("org.onosproject.net.intent");
        this.intentManager.registerCompiler(OpticalCircuitIntent.class, (IntentCompiler)this);
        this.cfgService.registerProperties(this.getClass());
        this.modified(context);
    }

    @Deactivate
    public void deactivate() {
        this.intentManager.unregisterCompiler(OpticalCircuitIntent.class);
        this.cfgService.unregisterProperties(this.getClass(), false);
    }

    public List<Intent> compile(OpticalCircuitIntent intent, List<Intent> installable) {
        ConnectPoint src = intent.getSrc();
        ConnectPoint dst = intent.getDst();
        Port srcPort = this.deviceService.getPort(src.deviceId(), src.port());
        Port dstPort = this.deviceService.getPort(dst.deviceId(), dst.port());
        Preconditions.checkArgument((boolean)(srcPort instanceof OduCltPort));
        Preconditions.checkArgument((boolean)(dstPort instanceof OduCltPort));
        log.debug("Compiling optical circuit intent between {} and {}", (Object)src, (Object)dst);
        this.resourceService.release((ResourceConsumer)intent.id());
        DiscreteResource srcPortResource = Resources.discrete((DeviceId)src.deviceId(), (PortNumber)src.port(), (Object[])new Object[0]).resource();
        DiscreteResource dstPortResource = Resources.discrete((DeviceId)dst.deviceId(), (PortNumber)dst.port(), (Object[])new Object[0]).resource();
        if (!Stream.of(srcPortResource, dstPortResource).allMatch(arg_0 -> ((ResourceService)this.resourceService).isAvailable(arg_0))) {
            throw new OpticalIntentCompilationException("Ports for the intent are not available. Intent: " + intent);
        }
        ImmutableList ports = ImmutableList.of((Object)srcPortResource, (Object)dstPortResource);
        boolean multiplexingSupported = this.isMultiplexingSupported(intent.getSrc()) && this.isMultiplexingSupported(intent.getDst());
        OpticalConnectivityIntent connIntent = this.findOpticalConnectivityIntent(intent.getSrc(), intent.getDst(), intent.getSignalType(), multiplexingSupported);
        if (connIntent != null && !multiplexingSupported) {
            return this.compile(intent, src, dst, Optional.of(connIntent), (List<Resource>)ports, false);
        }
        if (connIntent == null) {
            return this.compile(intent, src, dst, Optional.empty(), (List<Resource>)ports, multiplexingSupported);
        }
        List<Resource> slots = this.availableSlotResources(connIntent.getSrc(), connIntent.getDst(), intent.getSignalType());
        if (slots.isEmpty()) {
            return this.compile(intent, src, dst, Optional.empty(), (List<Resource>)ports, true);
        }
        return this.compile(intent, src, dst, Optional.of(connIntent), (List<Resource>)ImmutableList.builder().addAll((Iterable)ports).addAll(slots).build(), false);
    }

    private List<Intent> compile(OpticalCircuitIntent intent, ConnectPoint src, ConnectPoint dst, Optional<OpticalConnectivityIntent> existingConnectivity, List<Resource> resources, boolean supportsMultiplexing) {
        ImmutableList required;
        OpticalConnectivityIntent connectivityIntent;
        if (existingConnectivity.isPresent()) {
            connectivityIntent = existingConnectivity.get();
            required = resources;
        } else {
            Pair<OchPort, OchPort> ochPorts = this.findPorts(intent.getSrc(), intent.getDst(), intent.getSignalType());
            if (ochPorts == null) {
                throw new OpticalIntentCompilationException("Unable to find suitable OCH ports for intent " + intent);
            }
            ConnectPoint srcCP = new ConnectPoint(src.elementId(), ((OchPort)ochPorts.getLeft()).number());
            ConnectPoint dstCP = new ConnectPoint(dst.elementId(), ((OchPort)ochPorts.getRight()).number());
            connectivityIntent = OpticalConnectivityIntent.builder().appId(this.appId).src(srcCP).dst(dstCP).signalType(((OchPort)ochPorts.getLeft()).signalType()).bidirectional(intent.isBidirectional()).build();
            if (!supportsMultiplexing) {
                required = resources;
            } else {
                List<Resource> slots = this.availableSlotResources(srcCP, dstCP, intent.getSignalType());
                if (slots.isEmpty()) {
                    throw new OpticalIntentCompilationException("Unable to find Tributary Slots for intent " + intent);
                }
                required = ImmutableList.builder().addAll(resources).addAll(slots).build();
            }
        }
        if (this.resourceService.allocate((ResourceConsumer)intent.id(), required).isEmpty()) {
            throw new OpticalIntentCompilationException("Unable to allocate resources for intent " + intent + ": resources=" + required);
        }
        this.intentService.submit((Intent)connectivityIntent);
        this.intentSetMultimap.allocateMapping(connectivityIntent.id(), intent.id());
        FlowRuleIntent circuitIntent = this.createFlowRule(intent, connectivityIntent, required.stream().flatMap(x -> Tools.stream((Optional)x.valueAs(TributarySlot.class))).collect(Collectors.toSet()));
        return ImmutableList.of((Object)circuitIntent);
    }

    private List<Resource> availableSlotResources(ConnectPoint src, ConnectPoint dst, CltSignalType signalType) {
        OduSignalType oduSignalType = OduSignalUtils.mappingCltSignalTypeToOduSignalType((CltSignalType)signalType);
        int requestedTsNum = oduSignalType.tributarySlots();
        Set<TributarySlot> commonTributarySlots = this.findCommonTributarySlotsOnCps(src, dst);
        if (commonTributarySlots.isEmpty()) {
            return Collections.emptyList();
        }
        if (commonTributarySlots.size() < requestedTsNum) {
            return Collections.emptyList();
        }
        Set tributarySlots = commonTributarySlots.stream().limit(requestedTsNum).collect(Collectors.toSet());
        ImmutableList portsList = ImmutableList.of((Object)src, (Object)dst);
        List<Resource> tributarySlotResources = portsList.stream().flatMap(cp -> tributarySlots.stream().map(ts -> Resources.discrete((DeviceId)cp.deviceId(), (PortNumber)cp.port(), (Object[])new Object[0]).resource().child(ts))).collect(Collectors.toList());
        if (!tributarySlotResources.stream().allMatch(arg_0 -> ((ResourceService)this.resourceService).isAvailable(arg_0))) {
            log.debug("Resource allocation for {} on {} and {} failed (resource request: {})", new Object[]{signalType, src, dst, tributarySlotResources});
            return Collections.emptyList();
        }
        return tributarySlotResources;
    }

    private FlowRuleIntent createFlowRule(OpticalCircuitIntent higherIntent, OpticalConnectivityIntent lowerIntent, Set<TributarySlot> slots) {
        LinkedList<FlowRule> rules = new LinkedList<FlowRule>();
        rules.add(this.connectPorts(higherIntent.getSrc(), lowerIntent.getSrc(), higherIntent.priority(), slots));
        rules.add(this.connectPorts(lowerIntent.getDst(), higherIntent.getDst(), higherIntent.priority(), slots));
        if (higherIntent.isBidirectional()) {
            rules.add(this.connectPorts(lowerIntent.getSrc(), higherIntent.getSrc(), higherIntent.priority(), slots));
            rules.add(this.connectPorts(higherIntent.getDst(), lowerIntent.getDst(), higherIntent.priority(), slots));
        }
        return new FlowRuleIntent(this.appId, rules, higherIntent.resources());
    }

    private OpticalConnectivityIntent findOpticalConnectivityIntent(ConnectPoint src, ConnectPoint dst, CltSignalType signalType, boolean multiplexingSupported) {
        OduSignalType oduSignalType = OduSignalUtils.mappingCltSignalTypeToOduSignalType((CltSignalType)signalType);
        return Tools.stream((Iterable)this.intentService.getIntents()).filter(x -> x instanceof OpticalConnectivityIntent).map(x -> (OpticalConnectivityIntent)x).filter(x -> src.deviceId().equals((Object)x.getSrc().deviceId())).filter(x -> dst.deviceId().equals((Object)x.getDst().deviceId())).filter(x -> this.isAllowed(src, x.getSrc())).filter(x -> this.isAllowed(dst, x.getDst())).filter(x -> this.isAvailable(x.id())).filter(x -> !multiplexingSupported || this.isAvailableTributarySlots(x.getSrc(), x.getDst(), oduSignalType.tributarySlots())).findFirst().orElse(null);
    }

    private boolean isAllowed(ConnectPoint circuitCp, ConnectPoint connectivityCp) {
        ConnectPoint staticPort = this.staticPort(circuitCp);
        return staticPort == null || staticPort.equals((Object)connectivityCp);
    }

    private boolean isAvailable(IntentId resource) {
        if (resource == null) {
            return true;
        }
        Set mapping = this.intentSetMultimap.getMapping(resource);
        if (mapping == null) {
            return true;
        }
        return mapping.size() < this.maxCapacity;
    }

    private boolean isAvailableTributarySlots(ConnectPoint src, ConnectPoint dst, int requestedTsNum) {
        Set<TributarySlot> common = this.findCommonTributarySlotsOnCps(src, dst);
        if (common.isEmpty()) {
            log.debug("No available TributarySlots");
            return false;
        }
        if (common.size() < requestedTsNum) {
            log.debug("Not enough available TributarySlots={} < requestedTsNum={}", (Object)common.size(), (Object)requestedTsNum);
            return false;
        }
        return true;
    }

    private ConnectPoint staticPort(ConnectPoint connectPoint) {
        Port port = this.deviceService.getPort(connectPoint.deviceId(), connectPoint.port());
        String staticPort = port.annotations().value("staticPort");
        if (staticPort != null) {
            for (Port p : this.deviceService.getPorts(connectPoint.deviceId())) {
                if (!staticPort.equals(p.number().name())) continue;
                return new ConnectPoint(p.element().id(), p.number());
            }
        }
        return null;
    }

    private Pair<OchPort, OchPort> findPorts(ConnectPoint src, ConnectPoint dst, CltSignalType signalType) {
        switch (signalType) {
            case CLT_1GBE: 
            case CLT_10GBE: {
                return this.findPorts(src, dst, OduSignalType.ODU2).orElse(this.findPorts(src, dst, OduSignalType.ODU4).orElse(null));
            }
            case CLT_100GBE: {
                return this.findPorts(src, dst, OduSignalType.ODU4).orElse(null);
            }
        }
        return null;
    }

    private Optional<Pair<OchPort, OchPort>> findPorts(ConnectPoint src, ConnectPoint dst, OduSignalType ochPortSignalType) {
        return this.findAvailableOchPort(src, ochPortSignalType).flatMap(srcOch -> this.findAvailableOchPort(dst, ochPortSignalType).map(dstOch -> Pair.of((Object)srcOch, (Object)dstOch)));
    }

    private Optional<OchPort> findAvailableOchPort(ConnectPoint oduPort, OduSignalType ochPortSignalType) {
        ConnectPoint ochCP = this.staticPort(oduPort);
        if (ochCP != null) {
            OchPort ochPort = (OchPort)this.deviceService.getPort(ochCP.deviceId(), ochCP.port());
            Optional intentId = this.resourceService.getResourceAllocations((ResourceId)Resources.discrete((DeviceId)ochCP.deviceId(), (PortNumber)ochCP.port(), (Object[])new Object[0]).id()).stream().map(ResourceAllocation::consumerId).map(ResourceHelper::getIntentId).flatMap(Tools::stream).findAny();
            if (this.isAvailable(intentId.orElse(null))) {
                return Optional.of(ochPort);
            }
            return Optional.empty();
        }
        List ports = this.deviceService.getPorts(oduPort.deviceId());
        for (Port port : ports) {
            Optional intentId;
            if (!(port instanceof OchPort) || !this.resourceService.isAvailable((Resource)Resources.discrete((DeviceId)oduPort.deviceId(), (PortNumber)port.number(), (Object[])new Object[0]).resource()) || ((OchPort)port).signalType() != ochPortSignalType || !this.isAvailable((intentId = this.resourceService.getResourceAllocations((ResourceId)Resources.discrete((DeviceId)oduPort.deviceId(), (PortNumber)port.number(), (Object[])new Object[0]).id()).stream().map(ResourceAllocation::consumerId).map(ResourceHelper::getIntentId).flatMap(Tools::stream).findAny()).orElse(null))) continue;
            return Optional.of((OchPort)port);
        }
        return Optional.empty();
    }

    private FlowRule connectPorts(ConnectPoint src, ConnectPoint dst, int priority, Set<TributarySlot> slots) {
        Preconditions.checkArgument((boolean)src.deviceId().equals((Object)dst.deviceId()));
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
        selectorBuilder.matchInPort(src.port());
        if (!slots.isEmpty()) {
            Port srcPort = this.deviceService.getPort(src.deviceId(), src.port());
            Port dstPort = this.deviceService.getPort(dst.deviceId(), dst.port());
            if (srcPort instanceof OduCltPort) {
                OduSignalType oduCltPortOduSignalType = OduSignalUtils.mappingCltSignalTypeToOduSignalType((CltSignalType)((OduCltPort)srcPort).signalType());
                OduSignalType ochPortOduSignalType = ((OchPort)dstPort).signalType();
                selectorBuilder.add(Criteria.matchOduSignalType((OduSignalType)oduCltPortOduSignalType));
                if (oduCltPortOduSignalType != ochPortOduSignalType) {
                    OduSignalId oduSignalId = OduSignalUtils.buildOduSignalId((OduSignalType)ochPortOduSignalType, slots);
                    treatmentBuilder.add((Instruction)Instructions.modL1OduSignalId((OduSignalId)oduSignalId));
                }
            } else {
                OduSignalType oduCltPortOduSignalType = OduSignalUtils.mappingCltSignalTypeToOduSignalType((CltSignalType)((OduCltPort)dstPort).signalType());
                OduSignalType ochPortOduSignalType = ((OchPort)srcPort).signalType();
                selectorBuilder.add(Criteria.matchOduSignalType((OduSignalType)oduCltPortOduSignalType));
                if (oduCltPortOduSignalType != ochPortOduSignalType) {
                    OduSignalId oduSignalId = OduSignalUtils.buildOduSignalId((OduSignalType)ochPortOduSignalType, slots);
                    selectorBuilder.add(Criteria.matchOduSignalId((OduSignalId)oduSignalId));
                }
            }
        }
        treatmentBuilder.setOutput(dst.port());
        FlowRule flowRule = DefaultFlowRule.builder().forDevice(src.deviceId()).withSelector(selectorBuilder.build()).withTreatment(treatmentBuilder.build()).withPriority(priority).fromApp(this.appId).makePermanent().build();
        return flowRule;
    }

    private boolean isMultiplexingSupported(ConnectPoint cp) {
        Driver driver = this.driverService.getDriver(cp.deviceId());
        return driver != null && driver.hasBehaviour(TributarySlotQuery.class) && this.staticPort(cp) == null;
    }

    Set<TributarySlot> findCommonTributarySlotsOnCps(ConnectPoint src, ConnectPoint dst) {
        Set<TributarySlot> forward = this.findTributarySlotsOnCp(src);
        Set<TributarySlot> backward = this.findTributarySlotsOnCp(dst);
        return Sets.intersection(forward, backward);
    }

    Set<TributarySlot> findTributarySlotsOnCp(ConnectPoint cp) {
        return this.resourceService.getAvailableResourceValues(Resources.discrete((DeviceId)cp.deviceId(), (PortNumber)cp.port(), (Object[])new Object[0]).id(), TributarySlot.class);
    }

    protected void bindCfgService(ComponentConfigService componentConfigService) {
        this.cfgService = componentConfigService;
    }

    protected void unbindCfgService(ComponentConfigService componentConfigService) {
        if (this.cfgService == componentConfigService) {
            this.cfgService = null;
        }
    }

    protected void bindIntentManager(IntentExtensionService intentExtensionService) {
        this.intentManager = intentExtensionService;
    }

    protected void unbindIntentManager(IntentExtensionService intentExtensionService) {
        if (this.intentManager == intentExtensionService) {
            this.intentManager = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }

    protected void bindIntentSetMultimap(IntentSetMultimap intentSetMultimap) {
        this.intentSetMultimap = intentSetMultimap;
    }

    protected void unbindIntentSetMultimap(IntentSetMultimap intentSetMultimap) {
        if (this.intentSetMultimap == intentSetMultimap) {
            this.intentSetMultimap = null;
        }
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }
}

