/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.optical.config.OpticalPortConfig;

public class OpticalPortConfigTest {
    private static final String FIELD = "ports";
    private static final String KEY = "opc-test";
    private static final DeviceId DID = DeviceId.deviceId((String)"opc-test");
    private static final PortNumber PN = PortNumber.portNumber((long)100L);
    private static final ConnectPoint CPT = new ConnectPoint((ElementId)DID, PN);
    private static final String DEMOTREE = "{\"ports\": [{\"name\": \"1-10-E1_WPORT\",\"type\": \"OMS\"},{\"type\": \"OCH\",\"speed\": 0,\"port\": 10},{\"name\": \"1-1-E1_LPORT\",\"type\": \"OCH\",\"annotations\": {\"staticLambda\": 1,\"staticPort\": \"1-22-E1_WPORT\"}}]}";
    private final ConfigApplyDelegate delegate = new MockCfgDelegate();
    private final ObjectMapper mapper = new ObjectMapper();
    private List<OpticalPortConfig> opcl = Lists.newArrayList();
    private List<JsonNode> testNodes = Lists.newArrayList();

    @Before
    public void setUp() {
        try {
            JsonNode tree = new ObjectMapper().readTree(DEMOTREE);
            Iterator pitr = tree.get(FIELD).elements();
            while (pitr.hasNext()) {
                JsonNode jn = (JsonNode)pitr.next();
                OpticalPortConfig opc = new OpticalPortConfig();
                ObjectNode node = JsonNodeFactory.instance.objectNode();
                opc.init((Object)CPT, KEY, (JsonNode)node, this.mapper, this.delegate);
                this.testNodes.add(jn);
                this.opcl.add(opc);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testBaseAttrs() {
        OpticalPortConfig op0 = this.opcl.get(0);
        OpticalPortConfig op1 = this.opcl.get(1);
        OpticalPortConfig op2 = this.opcl.get(2);
        JsonNode jn0 = this.testNodes.get(0);
        JsonNode jn1 = this.testNodes.get(1);
        op0.portType(Port.Type.valueOf((String)jn0.path("type").asText())).portName(jn0.path("name").asText());
        op1.portType(Port.Type.valueOf((String)jn1.path("type").asText())).portNumberName(Long.valueOf(jn1.path("port").asLong()));
        Assert.assertEquals((Object)Port.Type.OMS, (Object)op0.type());
        Assert.assertEquals((Object)jn0.path("name").asText(), (Object)op0.name());
        Assert.assertEquals((Object)jn1.path("port").asText(), (Object)op1.numberName());
        Assert.assertEquals((Object)"", (Object)op1.name());
        Assert.assertEquals((Object)"", (Object)op2.name());
    }

    @Test
    public void testAdditionalAttrs() {
        OpticalPortConfig op1 = this.opcl.get(1);
        OpticalPortConfig op2 = this.opcl.get(2);
        JsonNode jn2 = this.testNodes.get(2);
        Long sl = 1L;
        op2.staticLambda(Long.valueOf(jn2.path("annotations").path("staticLambda").asLong()));
        op2.staticPort(jn2.path("annotations").path("staticPort").asText());
        Assert.assertEquals((Object)sl, op2.staticLambda().get());
        Assert.assertFalse((boolean)op1.staticLambda().isPresent());
        Assert.assertEquals((Object)"1-22-E1_WPORT", (Object)op2.staticPort());
        Assert.assertEquals((Object)"", (Object)op1.staticPort());
        op2.staticLambda(null);
        Assert.assertFalse((boolean)op2.staticLambda().isPresent());
    }

    private class MockCfgDelegate
    implements ConfigApplyDelegate {
        private MockCfgDelegate() {
        }

        public void onApply(Config config) {
            config.apply();
        }
    }
}

