/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.device;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onlab.util.Frequency;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.optical.OmsPort;
import org.onosproject.net.optical.device.OmsPortHelper;
import org.onosproject.net.provider.ProviderId;

public class OmsPortHelperTest {
    private static final ProviderId PID = new ProviderId("test", "id");
    private static final DeviceId DID = DeviceId.deviceId((String)"test:00123");
    private static final String MFC = "MFC";
    private static final String HW = "HW V";
    private static final String SW = "SW V";
    private static final String SER = "SER";
    private static final ChassisId CHS = new ChassisId(42L);
    private static final Annotations DEV_ANON = DefaultAnnotations.EMPTY;
    private static final Device DEV = new DefaultDevice(PID, DID, Device.Type.ROADM, "MFC", "HW V", "SW V", "SER", CHS, new Annotations[]{DEV_ANON});

    @Test
    public void testOmsPortDescriptionCanBeConvertedToOmsPort() {
        PortNumber pn = PortNumber.portNumber((long)4900L);
        boolean isEnabled = true;
        String anKey = "Base";
        String anValue = "value";
        DefaultAnnotations an = DefaultAnnotations.builder().set(anKey, anValue).build();
        Frequency minF = Frequency.ofGHz((long)3L);
        Frequency maxF = Frequency.ofGHz((long)33L);
        Frequency grid = Frequency.ofGHz((long)2L);
        PortDescription portDescription = OmsPortHelper.omsPortDescription((PortNumber)pn, (boolean)isEnabled, (Frequency)minF, (Frequency)maxF, (Frequency)grid, (SparseAnnotations)an);
        DefaultPort port = new DefaultPort((Element)DEV, portDescription.portNumber(), portDescription.isEnabled(), portDescription.type(), portDescription.portSpeed(), new Annotations[]{portDescription.annotations()});
        Optional maybeOms = OmsPortHelper.asOmsPort((Port)port);
        Assert.assertTrue((boolean)maybeOms.isPresent());
        OmsPort oms = (OmsPort)maybeOms.get();
        Assert.assertThat((Object)oms.isEnabled(), (Matcher)Matchers.is((Object)isEnabled));
        Assert.assertThat((Object)oms.number(), (Matcher)Matchers.is((Object)pn));
        Assert.assertThat((Object)oms.annotations().value(anKey), (Matcher)Matchers.is((Object)anValue));
        Assert.assertThat((String)"type is always OMS", (Object)oms.type(), (Matcher)Matchers.is((Object)Port.Type.OMS));
        Assert.assertThat((String)"port speed is undefined", (Object)oms.portSpeed(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
        Assert.assertThat((Object)oms.maxFrequency(), (Matcher)Matchers.is((Object)maxF));
        Assert.assertThat((Object)oms.minFrequency(), (Matcher)Matchers.is((Object)minF));
        Assert.assertThat((Object)oms.grid(), (Matcher)Matchers.is((Object)grid));
        Assert.assertThat((String)"((33-3)/2)+1 = 16", (Object)oms.totalChannels(), (Matcher)Matchers.is((Object)16));
    }
}

