/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.intent.impl.compiler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onosproject.TestApplicationId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.net.AbstractProjectableModel;
import org.onosproject.net.Annotations;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.OduSignalId;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.OduSignalUtils;
import org.onosproject.net.OtuSignalType;
import org.onosproject.net.Path;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.TributarySlot;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.driver.DriverServiceAdapter;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.MockIdGenerator;
import org.onosproject.net.intent.OpticalOduIntent;
import org.onosproject.net.optical.OduCltPort;
import org.onosproject.net.optical.OtuPort;
import org.onosproject.net.optical.impl.DefaultOduCltPort;
import org.onosproject.net.optical.impl.DefaultOtuPort;
import org.onosproject.net.optical.intent.impl.compiler.OpticalOduIntentCompiler;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.resource.MockResourceService;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyServiceAdapter;

public class OpticalOduIntentCompilerTest {
    private static final String DEV1 = "of:1";
    private static final String DEV2 = "of:2";
    private static final String DEV3 = "of:3";
    static final Key KEY1 = Key.of((long)5L, (ApplicationId)NetTestTools.APP_ID);
    private static final String STATIC_TRUE = "true";
    private static final String PNAME = "p2";
    private CoreService coreService;
    private IntentExtensionService intentExtensionService;
    private final IdGenerator idGenerator = new MockIdGenerator();
    private OpticalOduIntentCompiler sut;
    private final ApplicationId appId = new TestApplicationId("test");
    private static Device device1 = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)"of:1"), Device.Type.OTN, "m", "h", "s", "n", new ChassisId(0L), new Annotations[0]);
    private static Device device2 = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)"of:2"), Device.Type.OTN, "m", "h", "s", "n", new ChassisId(1L), new Annotations[0]);
    private static Device device3 = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)"of:3"), Device.Type.OTN, "m", "h", "s", "n", new ChassisId(2L), new Annotations[0]);
    private static Annotations annotations1 = DefaultAnnotations.builder().set("staticPort", "true").build();
    private static Annotations annotations2 = DefaultAnnotations.builder().set("portName", "p2").build();
    private static final OduCltPort D1P1 = new DefaultOduCltPort((Port)new DefaultPort((Element)device1, PortNumber.portNumber((long)1L), true, new Annotations[]{annotations1}), CltSignalType.CLT_1GBE);
    private static final OduCltPort D3P2 = new DefaultOduCltPort((Port)new DefaultPort((Element)device3, PortNumber.portNumber((long)2L), true, new Annotations[]{annotations1}), CltSignalType.CLT_1GBE);
    private static final OtuPort D1P2 = new DefaultOtuPort((Port)new DefaultPort((Element)device1, PortNumber.portNumber((long)2L), true, new Annotations[]{annotations2}), OtuSignalType.OTU2);
    private static final OtuPort D2P1 = new DefaultOtuPort((Port)new DefaultPort((Element)device2, PortNumber.portNumber((long)1L), true, new Annotations[]{annotations2}), OtuSignalType.OTU2);
    private static final OtuPort D2P2 = new DefaultOtuPort((Port)new DefaultPort((Element)device2, PortNumber.portNumber((long)2L), true, new Annotations[]{annotations2}), OtuSignalType.OTU2);
    private static final OtuPort D3P1 = new DefaultOtuPort((Port)new DefaultPort((Element)device3, PortNumber.portNumber((long)1L), true, new Annotations[]{annotations2}), OtuSignalType.OTU2);
    private static final OduCltPort D1P3 = new DefaultOduCltPort((Port)new DefaultPort((Element)device1, PortNumber.portNumber((long)3L), true, new Annotations[]{annotations1}), CltSignalType.CLT_10GBE);
    private static final OduCltPort D3P3 = new DefaultOduCltPort((Port)new DefaultPort((Element)device3, PortNumber.portNumber((long)3L), true, new Annotations[]{annotations1}), CltSignalType.CLT_10GBE);
    private final ConnectPoint d1p1 = new ConnectPoint((ElementId)device1.id(), D1P1.number());
    private final ConnectPoint d1p3 = new ConnectPoint((ElementId)device1.id(), D1P3.number());
    private final ConnectPoint d3p2 = new ConnectPoint((ElementId)device3.id(), D3P2.number());
    private final ConnectPoint d3p3 = new ConnectPoint((ElementId)device3.id(), D3P3.number());
    private final ConnectPoint d1p2 = new ConnectPoint((ElementId)device1.id(), D1P2.number());
    private final ConnectPoint d2p1 = new ConnectPoint((ElementId)device2.id(), D2P1.number());
    private final ConnectPoint d2p2 = new ConnectPoint((ElementId)device2.id(), D2P2.number());
    private final ConnectPoint d3p1 = new ConnectPoint((ElementId)device3.id(), D3P1.number());
    private final List<Link> links = Arrays.asList(DefaultLink.builder().providerId(NetTestTools.PID).src(this.d1p2).dst(this.d2p1).type(Link.Type.OPTICAL).build(), DefaultLink.builder().providerId(NetTestTools.PID).src(this.d2p2).dst(this.d3p1).type(Link.Type.OPTICAL).build());
    private final Path path = new DefaultPath(NetTestTools.PID, this.links, 3.0, new Annotations[0]);
    private OpticalOduIntent intent;

    @Before
    public void setUp() {
        AbstractProjectableModel.setDriverService(null, (DriverService)new MockDriverService());
        this.sut = new OpticalOduIntentCompiler();
        this.coreService = (CoreService)EasyMock.createMock(CoreService.class);
        EasyMock.expect((Object)this.coreService.registerApplication("org.onosproject.net.intent")).andReturn((Object)this.appId);
        this.sut.coreService = this.coreService;
        this.sut.deviceService = new MockDeviceService();
        this.sut.resourceService = new MockResourceService();
        this.sut.topologyService = new MockTopologyService();
        Intent.bindIdGenerator((IdGenerator)this.idGenerator);
        this.intentExtensionService = (IntentExtensionService)EasyMock.createMock(IntentExtensionService.class);
        this.intentExtensionService.registerCompiler(OpticalOduIntent.class, (IntentCompiler)this.sut);
        this.intentExtensionService.unregisterCompiler(OpticalOduIntent.class);
        this.sut.intentManager = this.intentExtensionService;
        EasyMock.replay((Object[])new Object[]{this.coreService, this.intentExtensionService});
    }

    @After
    public void tearDown() {
        Intent.unbindIdGenerator((IdGenerator)this.idGenerator);
    }

    @Test
    public void test1GbeMultiplexOverOdu2() {
        this.intent = OpticalOduIntent.builder().appId(NetTestTools.APP_ID).key(KEY1).src(this.d1p1).dst(this.d3p2).signalType(D1P1.signalType()).bidirectional(false).build();
        this.sut.activate();
        List compiled = this.sut.compile(this.intent, Collections.emptyList());
        MatcherAssert.assertThat((Object)compiled, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((String)"key is inherited", compiled.stream().map(Intent::key).collect(Collectors.toList()), (Matcher)Matchers.everyItem((Matcher)Matchers.is((Object)this.intent.key())));
        Collection rules = ((FlowRuleIntent)compiled.get(0)).flowRules();
        FlowRule rule1 = rules.stream().filter(x -> x.deviceId().equals((Object)device1.id())).findFirst().get();
        TrafficSelector.Builder selectorBuilder1 = DefaultTrafficSelector.builder();
        selectorBuilder1.matchInPort(this.d1p1.port());
        selectorBuilder1.add(Criteria.matchOduSignalType((OduSignalType)OduSignalType.ODU0));
        MatcherAssert.assertThat((Object)rule1.selector(), (Matcher)Matchers.is((Object)selectorBuilder1.build()));
        TrafficTreatment.Builder treatmentBuilder1 = DefaultTrafficTreatment.builder();
        HashSet<TributarySlot> slots = new HashSet<TributarySlot>();
        slots.add(TributarySlot.of((long)1L));
        OduSignalId oduSignalId = OduSignalUtils.buildOduSignalId((OduSignalType)OduSignalType.ODU2, slots);
        treatmentBuilder1.add((Instruction)Instructions.modL1OduSignalId((OduSignalId)oduSignalId));
        treatmentBuilder1.setOutput(this.d1p2.port());
        MatcherAssert.assertThat((Object)rule1.treatment(), (Matcher)Matchers.is((Object)treatmentBuilder1.build()));
        FlowRule rule2 = rules.stream().filter(x -> x.deviceId().equals((Object)device2.id())).findFirst().get();
        TrafficSelector.Builder selectorBuilder2 = DefaultTrafficSelector.builder();
        selectorBuilder2.matchInPort(this.d2p1.port());
        selectorBuilder2.add(Criteria.matchOduSignalType((OduSignalType)OduSignalType.ODU0));
        selectorBuilder2.add(Criteria.matchOduSignalId((OduSignalId)oduSignalId));
        MatcherAssert.assertThat((Object)rule2.selector(), (Matcher)Matchers.is((Object)selectorBuilder2.build()));
        TrafficTreatment.Builder treatmentBuilder2 = DefaultTrafficTreatment.builder();
        treatmentBuilder2.add((Instruction)Instructions.modL1OduSignalId((OduSignalId)oduSignalId));
        treatmentBuilder2.setOutput(this.d2p2.port());
        MatcherAssert.assertThat((Object)rule2.treatment(), (Matcher)Matchers.is((Object)treatmentBuilder2.build()));
        FlowRule rule3 = rules.stream().filter(x -> x.deviceId().equals((Object)device3.id())).findFirst().get();
        TrafficSelector.Builder selectorBuilder3 = DefaultTrafficSelector.builder();
        selectorBuilder3.matchInPort(this.d3p1.port());
        selectorBuilder3.add(Criteria.matchOduSignalType((OduSignalType)OduSignalType.ODU0));
        selectorBuilder3.add(Criteria.matchOduSignalId((OduSignalId)oduSignalId));
        MatcherAssert.assertThat((Object)rule3.selector(), (Matcher)Matchers.is((Object)selectorBuilder3.build()));
        MatcherAssert.assertThat((Object)rule3.treatment(), (Matcher)Matchers.is((Object)DefaultTrafficTreatment.builder().setOutput(this.d3p2.port()).build()));
        rules.forEach(rule -> Assert.assertEquals((String)"FlowRule priority is incorrect", (long)this.intent.priority(), (long)rule.priority()));
        this.sut.deactivate();
    }

    @Test
    public void test10GbeMultiplexOverOdu2() {
        this.intent = OpticalOduIntent.builder().appId(NetTestTools.APP_ID).key(KEY1).src(this.d1p3).dst(this.d3p3).signalType(D1P3.signalType()).bidirectional(false).build();
        this.sut.activate();
        List compiled = this.sut.compile(this.intent, Collections.emptyList());
        MatcherAssert.assertThat((Object)compiled, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((String)"key is inherited", compiled.stream().map(Intent::key).collect(Collectors.toList()), (Matcher)Matchers.everyItem((Matcher)Matchers.is((Object)this.intent.key())));
        Collection rules = ((FlowRuleIntent)compiled.get(0)).flowRules();
        FlowRule rule1 = rules.stream().filter(x -> x.deviceId().equals((Object)device1.id())).findFirst().get();
        TrafficSelector.Builder selectorBuilder1 = DefaultTrafficSelector.builder();
        selectorBuilder1.matchInPort(this.d1p3.port());
        selectorBuilder1.add(Criteria.matchOduSignalType((OduSignalType)OduSignalType.ODU2));
        MatcherAssert.assertThat((Object)rule1.selector(), (Matcher)Matchers.is((Object)selectorBuilder1.build()));
        TrafficTreatment.Builder treatmentBuilder1 = DefaultTrafficTreatment.builder();
        treatmentBuilder1.setOutput(this.d1p2.port());
        MatcherAssert.assertThat((Object)rule1.treatment(), (Matcher)Matchers.is((Object)treatmentBuilder1.build()));
        FlowRule rule2 = rules.stream().filter(x -> x.deviceId().equals((Object)device2.id())).findFirst().get();
        TrafficSelector.Builder selectorBuilder2 = DefaultTrafficSelector.builder();
        selectorBuilder2.matchInPort(this.d2p1.port());
        selectorBuilder2.add(Criteria.matchOduSignalType((OduSignalType)OduSignalType.ODU2));
        MatcherAssert.assertThat((Object)rule2.selector(), (Matcher)Matchers.is((Object)selectorBuilder2.build()));
        TrafficTreatment.Builder treatmentBuilder2 = DefaultTrafficTreatment.builder();
        treatmentBuilder2.setOutput(this.d2p2.port());
        MatcherAssert.assertThat((Object)rule2.treatment(), (Matcher)Matchers.is((Object)treatmentBuilder2.build()));
        FlowRule rule3 = rules.stream().filter(x -> x.deviceId().equals((Object)device3.id())).findFirst().get();
        TrafficSelector.Builder selectorBuilder3 = DefaultTrafficSelector.builder();
        selectorBuilder3.matchInPort(this.d3p1.port());
        selectorBuilder3.add(Criteria.matchOduSignalType((OduSignalType)OduSignalType.ODU2));
        MatcherAssert.assertThat((Object)rule3.selector(), (Matcher)Matchers.is((Object)selectorBuilder3.build()));
        MatcherAssert.assertThat((Object)rule3.treatment(), (Matcher)Matchers.is((Object)DefaultTrafficTreatment.builder().setOutput(this.d3p3.port()).build()));
        rules.forEach(rule -> Assert.assertEquals((String)"FlowRule priority is incorrect", (long)this.intent.priority(), (long)rule.priority()));
        this.sut.deactivate();
    }

    private static class MockDriverService
    extends DriverServiceAdapter
    implements DriverService {
        private MockDriverService() {
        }
    }

    private static class MockDeviceService
    extends DeviceServiceAdapter {
        private MockDeviceService() {
        }

        public boolean isAvailable(DeviceId deviceId) {
            return true;
        }

        public List<Port> getPorts(DeviceId deviceId) {
            if (deviceId.equals((Object)DeviceId.deviceId((String)OpticalOduIntentCompilerTest.DEV1))) {
                return ImmutableList.of((Object)D1P1, (Object)D1P2, (Object)D1P3);
            }
            if (deviceId.equals((Object)DeviceId.deviceId((String)OpticalOduIntentCompilerTest.DEV2))) {
                return ImmutableList.of((Object)D2P1, (Object)D2P2);
            }
            if (deviceId.equals((Object)DeviceId.deviceId((String)OpticalOduIntentCompilerTest.DEV3))) {
                return ImmutableList.of((Object)D3P1, (Object)D3P2, (Object)D3P3);
            }
            return Collections.emptyList();
        }

        public Port getPort(DeviceId deviceId, PortNumber portNumber) {
            if (deviceId.equals((Object)DeviceId.deviceId((String)OpticalOduIntentCompilerTest.DEV1))) {
                switch (portNumber.toString()) {
                    case "1": {
                        return D1P1;
                    }
                    case "2": {
                        return D1P2;
                    }
                    case "3": {
                        return D1P3;
                    }
                }
                return null;
            }
            if (deviceId.equals((Object)DeviceId.deviceId((String)OpticalOduIntentCompilerTest.DEV2))) {
                switch (portNumber.toString()) {
                    case "1": {
                        return D2P1;
                    }
                    case "2": {
                        return D2P2;
                    }
                }
                return null;
            }
            if (deviceId.equals((Object)DeviceId.deviceId((String)OpticalOduIntentCompilerTest.DEV3))) {
                switch (portNumber.toString()) {
                    case "1": {
                        return D3P1;
                    }
                    case "2": {
                        return D3P2;
                    }
                    case "3": {
                        return D3P3;
                    }
                }
                return null;
            }
            return null;
        }
    }

    private class MockTopologyService
    extends TopologyServiceAdapter {
        Set<Path> paths;

        private MockTopologyService() {
            this.paths = Sets.newHashSet((Object[])new Path[]{OpticalOduIntentCompilerTest.this.path});
        }

        public Topology currentTopology() {
            return null;
        }

        public Set<Path> getPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeight weight) {
            return this.paths;
        }
    }
}

