/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.intent.impl.compiler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.OduSignalId;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.OduSignalUtils;
import org.onosproject.net.OtuSignalType;
import org.onosproject.net.Path;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.TributarySlot;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.OpticalOduIntent;
import org.onosproject.net.optical.OduCltPort;
import org.onosproject.net.optical.OtuPort;
import org.onosproject.net.optical.device.OpticalDeviceServiceView;
import org.onosproject.net.optical.intent.impl.compiler.OpticalIntentCompilationException;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.Resources;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpticalOduIntentCompiler
implements IntentCompiler<OpticalOduIntent> {
    private static final Logger log = LoggerFactory.getLogger(OpticalOduIntentCompiler.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentExtensionService intentManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceService resourceService;
    private ApplicationId appId;

    @Activate
    public void activate() {
        this.deviceService = OpticalDeviceServiceView.opticalView(this.deviceService);
        this.appId = this.coreService.registerApplication("org.onosproject.net.intent");
        this.intentManager.registerCompiler(OpticalOduIntent.class, (IntentCompiler)this);
    }

    @Deactivate
    public void deactivate() {
        this.intentManager.unregisterCompiler(OpticalOduIntent.class);
    }

    public List<Intent> compile(OpticalOduIntent intent, List<Intent> installable) {
        ConnectPoint src = intent.getSrc();
        ConnectPoint dst = intent.getDst();
        Port srcPort = this.deviceService.getPort(src.deviceId(), src.port());
        Port dstPort = this.deviceService.getPort(dst.deviceId(), dst.port());
        Preconditions.checkArgument((boolean)(srcPort instanceof OduCltPort));
        Preconditions.checkArgument((boolean)(dstPort instanceof OduCltPort));
        log.debug("Compiling optical ODU intent between {} and {}", (Object)src, (Object)dst);
        this.resourceService.release((ResourceConsumer)intent.id());
        DiscreteResource srcPortResource = Resources.discrete((DeviceId)src.deviceId(), (PortNumber)src.port(), (Object[])new Object[0]).resource();
        DiscreteResource dstPortResource = Resources.discrete((DeviceId)dst.deviceId(), (PortNumber)dst.port(), (Object[])new Object[0]).resource();
        if (!Stream.of(srcPortResource, dstPortResource).allMatch(arg_0 -> ((ResourceService)this.resourceService).isAvailable(arg_0))) {
            throw new OpticalIntentCompilationException("Ports for the intent are not available. Intent: " + intent);
        }
        ArrayList<Resource> intentResources = new ArrayList<Resource>();
        intentResources.add((Resource)srcPortResource);
        intentResources.add((Resource)dstPortResource);
        Set<Path> paths = this.getOpticalPaths(intent);
        if (paths.isEmpty()) {
            throw new OpticalIntentCompilationException("Unable to find suitable lightpath for intent " + intent);
        }
        for (Path path : paths) {
            Map<LinkKey, Set<TributarySlot>> slotsMap = this.findAvailableTributarySlots(intent, path);
            if (slotsMap.isEmpty()) continue;
            List<Resource> tributarySlotResources = this.convertToResources(slotsMap);
            if (!tributarySlotResources.stream().allMatch(arg_0 -> ((ResourceService)this.resourceService).isAvailable(arg_0))) continue;
            intentResources.addAll(tributarySlotResources);
            this.allocateResources((Intent)intent, intentResources);
            List<Object> rules = new LinkedList();
            rules = this.createRules(intent, intent.getSrc(), intent.getDst(), path, slotsMap, false);
            if (intent.isBidirectional()) {
                rules.addAll(this.createRules(intent, intent.getDst(), intent.getSrc(), path, slotsMap, true));
            }
            return Collections.singletonList(new FlowRuleIntent(this.appId, intent.key(), rules, (Collection)ImmutableSet.copyOf((Collection)path.links())));
        }
        throw new OpticalIntentCompilationException("Unable to find suitable lightpath for intent " + intent);
    }

    private Map<LinkKey, Set<TributarySlot>> findAvailableTributarySlots(OpticalOduIntent intent, Path path) {
        HashSet linkRequest = Sets.newHashSetWithExpectedSize((int)path.links().size());
        for (int i = 0; i < path.links().size(); ++i) {
            LinkKey link = LinkKey.linkKey((Link)((Link)path.links().get(i)));
            linkRequest.add(link);
        }
        return this.findTributarySlots(intent, linkRequest);
    }

    private List<Resource> convertToResources(Map<LinkKey, Set<TributarySlot>> slotsMap) {
        Set resources = slotsMap.entrySet().stream().flatMap(x -> ((Set)x.getValue()).stream().flatMap(ts -> Stream.of(Resources.discrete((DeviceId)((LinkKey)x.getKey()).src().deviceId(), (PortNumber)((LinkKey)x.getKey()).src().port(), (Object[])new Object[0]).resource().child(ts), Resources.discrete((DeviceId)((LinkKey)x.getKey()).dst().deviceId(), (PortNumber)((LinkKey)x.getKey()).dst().port(), (Object[])new Object[0]).resource().child(ts)))).collect(Collectors.toSet());
        return ImmutableList.copyOf(resources);
    }

    private void allocateResources(Intent intent, List<Resource> resources) {
        List allocations = this.resourceService.allocate((ResourceConsumer)intent.id(), resources);
        if (allocations.isEmpty()) {
            log.info("Resource allocation for {} failed (resource request: {})", (Object)intent, resources);
            throw new OpticalIntentCompilationException("Unable to allocate resources: " + resources);
        }
    }

    private Map<LinkKey, Set<TributarySlot>> findTributarySlots(OpticalOduIntent intent, Set<LinkKey> links) {
        OduSignalType oduSignalType = OduSignalUtils.mappingCltSignalTypeToOduSignalType((CltSignalType)intent.getSignalType());
        int requestedTsNum = oduSignalType.tributarySlots();
        HashMap<LinkKey, Set<TributarySlot>> slotsMap = new HashMap<LinkKey, Set<TributarySlot>>();
        for (LinkKey link : links) {
            Set<TributarySlot> common = this.findCommonTributarySlotsOnCps(link.src(), link.dst());
            if (common.isEmpty() || common.size() < requestedTsNum) {
                log.debug("Failed to find TributarySlots on link {} requestedTsNum={}", (Object)link, (Object)requestedTsNum);
                return Collections.emptyMap();
            }
            slotsMap.put(link, common.stream().limit(requestedTsNum).collect(Collectors.toSet()));
        }
        return slotsMap;
    }

    private Set<Path> getOpticalPaths(OpticalOduIntent intent) {
        Topology topology = this.topologyService.currentTopology();
        LinkWeight weight = edge -> {
            if (edge.link().state() == Link.State.INACTIVE) {
                return -1.0;
            }
            if (edge.link().type() != Link.Type.OPTICAL) {
                return -1.0;
            }
            if (!this.isAvailableTributarySlots(intent, edge.link())) {
                return -1.0;
            }
            return 1.0;
        };
        ConnectPoint start = intent.getSrc();
        ConnectPoint end = intent.getDst();
        return this.topologyService.getPaths(topology, start.deviceId(), end.deviceId(), weight);
    }

    private boolean isAvailableTributarySlots(OpticalOduIntent intent, Link link) {
        OduSignalType oduSignalType = OduSignalUtils.mappingCltSignalTypeToOduSignalType((CltSignalType)intent.getSignalType());
        int requestedTsNum = oduSignalType.tributarySlots();
        Set<TributarySlot> common = this.findCommonTributarySlotsOnCps(link.src(), link.dst());
        if (common.isEmpty() || common.size() < requestedTsNum) {
            log.debug("Not enough available TributarySlots on link {} requestedTsNum={}", (Object)link, (Object)requestedTsNum);
            return false;
        }
        return true;
    }

    private List<FlowRule> createRules(OpticalOduIntent intent, ConnectPoint src, ConnectPoint dst, Path path, Map<LinkKey, Set<TributarySlot>> slotsMap, boolean reverse) {
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchInPort(src.port());
        OduSignalType oduCltPortOduSignalType = OduSignalUtils.mappingCltSignalTypeToOduSignalType((CltSignalType)intent.getSignalType());
        selector.add(Criteria.matchOduSignalType((OduSignalType)oduCltPortOduSignalType));
        LinkedList<FlowRule> rules = new LinkedList<FlowRule>();
        ConnectPoint current = src;
        List links = !reverse ? path.links() : Lists.reverse((List)path.links());
        for (Link link : links) {
            Set<TributarySlot> slots = slotsMap.get(LinkKey.linkKey((Link)link));
            OtuPort otuPort = (OtuPort)this.deviceService.getPort(link.src().deviceId(), link.src().port());
            OduSignalType otuPortOduSignalType = OduSignalUtils.mappingOtuSignalTypeToOduSignalType((OtuSignalType)otuPort.signalType());
            TrafficTreatment.Builder treat = DefaultTrafficTreatment.builder();
            OduSignalId oduSignalId = null;
            if (oduCltPortOduSignalType != otuPortOduSignalType) {
                oduSignalId = OduSignalUtils.buildOduSignalId((OduSignalType)otuPortOduSignalType, slots);
                treat.add((Instruction)Instructions.modL1OduSignalId((OduSignalId)oduSignalId));
            }
            ConnectPoint next = !reverse ? link.src() : link.dst();
            treat.setOutput(next.port());
            FlowRule rule = this.createFlowRule(intent, current.deviceId(), selector.build(), treat.build());
            rules.add(rule);
            current = !reverse ? link.dst() : link.src();
            selector = DefaultTrafficSelector.builder();
            selector.matchInPort(current.port());
            selector.add(Criteria.matchOduSignalType((OduSignalType)oduCltPortOduSignalType));
            if (oduCltPortOduSignalType == otuPortOduSignalType) continue;
            selector.add(Criteria.matchOduSignalId((OduSignalId)oduSignalId));
        }
        TrafficTreatment.Builder treatLast = DefaultTrafficTreatment.builder();
        treatLast.setOutput(dst.port());
        FlowRule rule = this.createFlowRule(intent, dst.deviceId(), selector.build(), treatLast.build());
        rules.add(rule);
        return rules;
    }

    private FlowRule createFlowRule(OpticalOduIntent intent, DeviceId deviceId, TrafficSelector selector, TrafficTreatment treat) {
        return DefaultFlowRule.builder().forDevice(deviceId).withSelector(selector).withTreatment(treat).withPriority(intent.priority()).fromApp(this.appId).makePermanent().build();
    }

    Set<TributarySlot> findCommonTributarySlotsOnCps(ConnectPoint src, ConnectPoint dst) {
        Set<TributarySlot> forward = this.findTributarySlotsOnCp(src);
        Set<TributarySlot> backward = this.findTributarySlotsOnCp(dst);
        return Sets.intersection(forward, backward);
    }

    Set<TributarySlot> findTributarySlotsOnCp(ConnectPoint cp) {
        return this.resourceService.getAvailableResourceValues(Resources.discrete((DeviceId)cp.deviceId(), (PortNumber)cp.port(), (Object[])new Object[0]).id(), TributarySlot.class);
    }

    protected void bindIntentManager(IntentExtensionService intentExtensionService) {
        this.intentManager = intentExtensionService;
    }

    protected void unbindIntentManager(IntentExtensionService intentExtensionService) {
        if (this.intentManager == intentExtensionService) {
            this.intentManager = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }
}

