/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.impl;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onlab.util.Frequency;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.optical.impl.DefaultOmsPort;
import org.onosproject.net.provider.ProviderId;

public class DefaultOmsPortTest {
    private static final ProviderId PID = new ProviderId("test", "id");
    private static final DeviceId DID = DeviceId.deviceId((String)"test:00123");
    private static final String MFC = "MFC";
    private static final String HW = "HW V";
    private static final String SW = "SW V";
    private static final String SER = "SER";
    private static final ChassisId CHS = new ChassisId(42L);
    private static final Annotations DEV_ANON = DefaultAnnotations.EMPTY;
    private static final Device DEV = new DefaultDevice(PID, DID, Device.Type.ROADM, "MFC", "HW V", "SW V", "SER", CHS, new Annotations[]{DEV_ANON});

    @Test
    public void testEquality() {
        PortNumber pn = PortNumber.portNumber((long)4900L);
        DefaultAnnotations an = DefaultAnnotations.builder().set("Base", "value").build();
        DefaultAnnotations an2 = DefaultAnnotations.builder().set("Base", "value2").build();
        DefaultPort base = new DefaultPort((Element)DEV, pn, true, Port.Type.VIRTUAL, 2L, new Annotations[]{an});
        Frequency minF = Frequency.ofGHz((long)3L);
        Frequency maxF = Frequency.ofGHz((long)33L);
        Frequency grid = Frequency.ofGHz((long)2L);
        DefaultOmsPort oms = new DefaultOmsPort((Port)base, minF, maxF, grid);
        new EqualsTester().addEqualityGroup(new Object[]{oms, new DefaultOmsPort((Port)new DefaultPort((Element)DEV, pn, true, new Annotations[]{an}), minF, maxF, grid)}).addEqualityGroup(new Object[]{new DefaultOmsPort((Port)new DefaultPort((Element)DEV, PortNumber.portNumber((long)1L), true, new Annotations[]{an}), minF, maxF, grid)}).addEqualityGroup(new Object[]{new DefaultOmsPort((Port)new DefaultPort((Element)DEV, pn, false, new Annotations[]{an}), minF, maxF, grid)}).addEqualityGroup(new Object[]{new DefaultOmsPort((Port)new DefaultPort((Element)DEV, pn, true, new Annotations[]{an2}), minF, maxF, grid)}).addEqualityGroup(new Object[]{new DefaultOmsPort((Port)base, Frequency.ofKHz((long)3L), maxF, grid)}).addEqualityGroup(new Object[]{new DefaultOmsPort((Port)base, minF, Frequency.ofKHz((long)33L), grid)}).addEqualityGroup(new Object[]{new DefaultOmsPort((Port)base, minF, maxF, Frequency.ofKHz((long)2L))}).testEquals();
    }

    @Test
    public void basicTests() {
        PortNumber pn = PortNumber.portNumber((long)4900L);
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("Base", "value").build();
        boolean isEnabled = true;
        DefaultPort base = new DefaultPort((Element)DEV, pn, isEnabled, Port.Type.VIRTUAL, 2L, new Annotations[]{annotations});
        Frequency minFrequency = Frequency.ofGHz((long)3L);
        Frequency maxFrequency = Frequency.ofGHz((long)33L);
        Frequency grid = Frequency.ofGHz((long)2L);
        DefaultOmsPort oms = new DefaultOmsPort((Port)base, minFrequency, maxFrequency, grid);
        Assert.assertThat((Object)oms.element(), (Matcher)Matchers.is((Object)DEV));
        Assert.assertThat((Object)oms.isEnabled(), (Matcher)Matchers.is((Object)isEnabled));
        Assert.assertThat((Object)oms.number(), (Matcher)Matchers.is((Object)pn));
        Assert.assertThat((Object)oms.annotations(), (Matcher)Matchers.is((Object)annotations));
        Assert.assertThat((String)"type is always OMS", (Object)oms.type(), (Matcher)Matchers.is((Object)Port.Type.OMS));
        Assert.assertThat((String)"port speed is undefined", (Object)oms.portSpeed(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)0L)));
        Assert.assertThat((Object)oms.maxFrequency(), (Matcher)Matchers.is((Object)maxFrequency));
        Assert.assertThat((Object)oms.minFrequency(), (Matcher)Matchers.is((Object)minFrequency));
        Assert.assertThat((Object)oms.grid(), (Matcher)Matchers.is((Object)grid));
        Assert.assertThat((String)"((33-3)/2)+1 = 16", (Object)oms.totalChannels(), (Matcher)Matchers.is((Object)16));
    }
}

