/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.intent.impl.compiler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onosproject.TestApplicationId;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.net.AbstractProjectableModel;
import org.onosproject.net.Annotations;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.ElementId;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalId;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.OduSignalUtils;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.TributarySlot;
import org.onosproject.net.behaviour.TributarySlotQuery;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.driver.DefaultDriver;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.driver.DriverServiceAdapter;
import org.onosproject.net.driver.TestBehaviourImpl;
import org.onosproject.net.driver.TestBehaviourTwoImpl;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.intent.IntentServiceAdapter;
import org.onosproject.net.intent.IntentSetMultimap;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.MockIdGenerator;
import org.onosproject.net.intent.OpticalCircuitIntent;
import org.onosproject.net.optical.OchPort;
import org.onosproject.net.optical.OduCltPort;
import org.onosproject.net.optical.impl.DefaultOchPort;
import org.onosproject.net.optical.impl.DefaultOduCltPort;
import org.onosproject.net.optical.intent.impl.compiler.OpticalCircuitIntentCompiler;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.resource.MockResourceService;

public class OpticalCircuitIntentCompilerTest {
    private static final String DEV1 = "of:1";
    private static final String DEV2 = "of:2";
    static final Key KEY1 = Key.of((long)5L, (ApplicationId)NetTestTools.APP_ID);
    private static final String STATIC_TRUE = "true";
    private static final String PNAME = "p2";
    private CoreService coreService;
    private IntentExtensionService intentExtensionService;
    private final IdGenerator idGenerator = new MockIdGenerator();
    private OpticalCircuitIntentCompiler sut;
    private final ApplicationId appId = new TestApplicationId("test");
    private static Device device1 = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)"of:1"), Device.Type.ROADM, "m", "h", "s", "n", new ChassisId(0L), new Annotations[0]);
    private static Device device2 = new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)"of:2"), Device.Type.ROADM, "m", "h", "s", "n", new ChassisId(1L), new Annotations[0]);
    private static Annotations annotations1 = DefaultAnnotations.builder().set("staticPort", "true").build();
    private static Annotations annotations2 = DefaultAnnotations.builder().set("portName", "p2").build();
    private static final OduCltPort D1P1 = new DefaultOduCltPort((Port)new DefaultPort((Element)device1, PortNumber.portNumber((long)1L), true, new Annotations[]{annotations1}), CltSignalType.CLT_1GBE);
    private static final OduCltPort D2P1 = new DefaultOduCltPort((Port)new DefaultPort((Element)device2, PortNumber.portNumber((long)1L), true, new Annotations[]{annotations1}), CltSignalType.CLT_1GBE);
    private static final OchPort D1P2 = new DefaultOchPort((Port)new DefaultPort((Element)device1, PortNumber.portNumber((long)2L), true, new Annotations[]{annotations2}), OduSignalType.ODU2, true, OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_50GHZ, (int)1));
    private static final OchPort D2P2 = new DefaultOchPort((Port)new DefaultPort((Element)device2, PortNumber.portNumber((long)2L), true, new Annotations[]{annotations2}), OduSignalType.ODU2, true, OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_50GHZ, (int)1));
    private static final OduCltPort D1P3 = new DefaultOduCltPort((Port)new DefaultPort((Element)device1, PortNumber.portNumber((long)3L), true, new Annotations[]{annotations1}), CltSignalType.CLT_10GBE);
    private static final OduCltPort D2P3 = new DefaultOduCltPort((Port)new DefaultPort((Element)device2, PortNumber.portNumber((long)3L), true, new Annotations[]{annotations1}), CltSignalType.CLT_10GBE);
    private OpticalCircuitIntent intent;

    @BeforeClass
    public static void setUpClass() {
        AbstractProjectableModel.setDriverService((Object)"key", (DriverService)new DriverServiceAdapter());
    }

    @Before
    public void setUp() {
        this.sut = new OpticalCircuitIntentCompiler();
        this.coreService = (CoreService)EasyMock.createMock(CoreService.class);
        EasyMock.expect((Object)this.coreService.registerApplication("org.onosproject.net.intent")).andReturn((Object)this.appId);
        this.sut.coreService = this.coreService;
        this.sut.deviceService = new MockDeviceService();
        this.sut.resourceService = new MockResourceService();
        this.sut.intentService = new TestIntentService();
        this.sut.intentSetMultimap = new MockIntentSetMultimap();
        Intent.bindIdGenerator((IdGenerator)this.idGenerator);
        this.intentExtensionService = (IntentExtensionService)EasyMock.createMock(IntentExtensionService.class);
        this.intentExtensionService.registerCompiler(OpticalCircuitIntent.class, (IntentCompiler)this.sut);
        this.intentExtensionService.unregisterCompiler(OpticalCircuitIntent.class);
        this.sut.intentManager = this.intentExtensionService;
        EasyMock.replay((Object[])new Object[]{this.coreService, this.intentExtensionService});
        ComponentConfigService mockConfigService = (ComponentConfigService)EasyMock.createMock(ComponentConfigService.class);
        EasyMock.expect((Object)mockConfigService.getProperties((String)EasyMock.anyObject())).andReturn((Object)ImmutableSet.of());
        mockConfigService.registerProperties(this.sut.getClass());
        EasyMock.expectLastCall();
        mockConfigService.unregisterProperties(this.sut.getClass(), false);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)mockConfigService.getProperties((String)EasyMock.anyObject())).andReturn((Object)ImmutableSet.of());
        this.sut.cfgService = mockConfigService;
        EasyMock.replay((Object[])new Object[]{mockConfigService});
    }

    @After
    public void tearDown() {
        Intent.unbindIdGenerator((IdGenerator)this.idGenerator);
    }

    @Test
    public void test1GbeMultiplexOverOdu2() {
        this.sut.driverService = new MockDriverServiceWithTs();
        ConnectPoint oduCltSrcCP = new ConnectPoint((ElementId)device1.id(), D1P1.number());
        ConnectPoint oduCltDstCP = new ConnectPoint((ElementId)device2.id(), D2P1.number());
        ConnectPoint ochSrcCP = new ConnectPoint((ElementId)device1.id(), D1P2.number());
        ConnectPoint ochDstCP = new ConnectPoint((ElementId)device2.id(), D2P2.number());
        this.intent = OpticalCircuitIntent.builder().appId(NetTestTools.APP_ID).key(KEY1).src(oduCltSrcCP).dst(oduCltDstCP).signalType(D1P1.signalType()).bidirectional(false).build();
        this.sut.activate(null);
        List compiled = this.sut.compile(this.intent, Collections.emptyList());
        MatcherAssert.assertThat((Object)compiled, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((String)"key is inherited", compiled.stream().map(Intent::key).collect(Collectors.toList()), (Matcher)Matchers.everyItem((Matcher)Matchers.is((Object)this.intent.key())));
        Collection rules = ((FlowRuleIntent)compiled.get(0)).flowRules();
        FlowRule rule1 = rules.stream().filter(x -> x.deviceId().equals((Object)device1.id())).findFirst().get();
        TrafficSelector.Builder selectorBuilder1 = DefaultTrafficSelector.builder();
        selectorBuilder1.matchInPort(oduCltSrcCP.port());
        selectorBuilder1.add(Criteria.matchOduSignalType((OduSignalType)OduSignalType.ODU0));
        MatcherAssert.assertThat((Object)rule1.selector(), (Matcher)Matchers.is((Object)selectorBuilder1.build()));
        TrafficTreatment.Builder treatmentBuilder1 = DefaultTrafficTreatment.builder();
        HashSet<TributarySlot> slots = new HashSet<TributarySlot>();
        slots.add(TributarySlot.of((long)1L));
        OduSignalId oduSignalId = OduSignalUtils.buildOduSignalId((OduSignalType)D1P2.signalType(), slots);
        treatmentBuilder1.add((Instruction)Instructions.modL1OduSignalId((OduSignalId)oduSignalId));
        treatmentBuilder1.setOutput(ochSrcCP.port());
        MatcherAssert.assertThat((Object)rule1.treatment(), (Matcher)Matchers.is((Object)treatmentBuilder1.build()));
        FlowRule rule2 = rules.stream().filter(x -> x.deviceId().equals((Object)device2.id())).findFirst().get();
        TrafficSelector.Builder selectorBuilder2 = DefaultTrafficSelector.builder();
        selectorBuilder2.matchInPort(ochDstCP.port());
        selectorBuilder2.add(Criteria.matchOduSignalType((OduSignalType)OduSignalType.ODU0));
        selectorBuilder2.add(Criteria.matchOduSignalId((OduSignalId)oduSignalId));
        MatcherAssert.assertThat((Object)rule2.selector(), (Matcher)Matchers.is((Object)selectorBuilder2.build()));
        MatcherAssert.assertThat((Object)rule2.treatment(), (Matcher)Matchers.is((Object)DefaultTrafficTreatment.builder().setOutput(oduCltDstCP.port()).build()));
        rules.forEach(rule -> Assert.assertEquals((String)"FlowRule priority is incorrect", (long)this.intent.priority(), (long)rule.priority()));
        this.sut.deactivate();
    }

    @Test
    public void test10GbeMultiplexOverOdu2() {
        this.sut.driverService = new MockDriverServiceWithTs();
        ConnectPoint oduCltSrcCP = new ConnectPoint((ElementId)device1.id(), D1P3.number());
        ConnectPoint oduCltDstCP = new ConnectPoint((ElementId)device2.id(), D2P3.number());
        ConnectPoint ochSrcCP = new ConnectPoint((ElementId)device1.id(), D1P2.number());
        ConnectPoint ochDstCP = new ConnectPoint((ElementId)device2.id(), D2P2.number());
        this.intent = OpticalCircuitIntent.builder().appId(NetTestTools.APP_ID).key(KEY1).src(oduCltSrcCP).dst(oduCltDstCP).signalType(D1P3.signalType()).bidirectional(false).build();
        this.sut.activate(null);
        List compiled = this.sut.compile(this.intent, Collections.emptyList());
        MatcherAssert.assertThat((Object)compiled, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((String)"key is inherited", compiled.stream().map(Intent::key).collect(Collectors.toList()), (Matcher)Matchers.everyItem((Matcher)Matchers.is((Object)this.intent.key())));
        Collection rules = ((FlowRuleIntent)compiled.get(0)).flowRules();
        FlowRule rule1 = rules.stream().filter(x -> x.deviceId().equals((Object)device1.id())).findFirst().get();
        TrafficSelector.Builder selectorBuilder1 = DefaultTrafficSelector.builder();
        selectorBuilder1.matchInPort(oduCltSrcCP.port());
        selectorBuilder1.add(Criteria.matchOduSignalType((OduSignalType)OduSignalType.ODU2));
        MatcherAssert.assertThat((Object)rule1.selector(), (Matcher)Matchers.is((Object)selectorBuilder1.build()));
        TrafficTreatment.Builder treatmentBuilder1 = DefaultTrafficTreatment.builder();
        treatmentBuilder1.setOutput(ochSrcCP.port());
        MatcherAssert.assertThat((Object)rule1.treatment(), (Matcher)Matchers.is((Object)treatmentBuilder1.build()));
        FlowRule rule2 = rules.stream().filter(x -> x.deviceId().equals((Object)device2.id())).findFirst().get();
        TrafficSelector.Builder selectorBuilder2 = DefaultTrafficSelector.builder();
        selectorBuilder2.matchInPort(ochDstCP.port());
        selectorBuilder2.add(Criteria.matchOduSignalType((OduSignalType)OduSignalType.ODU2));
        MatcherAssert.assertThat((Object)rule2.selector(), (Matcher)Matchers.is((Object)selectorBuilder2.build()));
        MatcherAssert.assertThat((Object)rule2.treatment(), (Matcher)Matchers.is((Object)DefaultTrafficTreatment.builder().setOutput(oduCltDstCP.port()).build()));
        rules.forEach(rule -> Assert.assertEquals((String)"FlowRule priority is incorrect", (long)this.intent.priority(), (long)rule.priority()));
        this.sut.deactivate();
    }

    @Test
    public void test10GbeNoMuxOverOdu2() {
        this.sut.driverService = new MockDriverServiceNoTs();
        ConnectPoint oduCltSrcCP = new ConnectPoint((ElementId)device1.id(), D1P3.number());
        ConnectPoint oduCltDstCP = new ConnectPoint((ElementId)device2.id(), D2P3.number());
        ConnectPoint ochSrcCP = new ConnectPoint((ElementId)device1.id(), D1P2.number());
        ConnectPoint ochDstCP = new ConnectPoint((ElementId)device2.id(), D2P2.number());
        this.intent = OpticalCircuitIntent.builder().appId(NetTestTools.APP_ID).key(KEY1).src(oduCltSrcCP).dst(oduCltDstCP).signalType(D1P3.signalType()).bidirectional(false).build();
        this.sut.activate(null);
        List compiled = this.sut.compile(this.intent, Collections.emptyList());
        MatcherAssert.assertThat((Object)compiled, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((String)"key is inherited", compiled.stream().map(Intent::key).collect(Collectors.toList()), (Matcher)Matchers.everyItem((Matcher)Matchers.is((Object)this.intent.key())));
        Collection rules = ((FlowRuleIntent)compiled.get(0)).flowRules();
        FlowRule rule1 = rules.stream().filter(x -> x.deviceId().equals((Object)device1.id())).findFirst().get();
        TrafficSelector.Builder selectorBuilder1 = DefaultTrafficSelector.builder();
        selectorBuilder1.matchInPort(oduCltSrcCP.port());
        MatcherAssert.assertThat((Object)rule1.selector(), (Matcher)Matchers.is((Object)selectorBuilder1.build()));
        TrafficTreatment.Builder treatmentBuilder1 = DefaultTrafficTreatment.builder();
        treatmentBuilder1.setOutput(ochSrcCP.port());
        MatcherAssert.assertThat((Object)rule1.treatment(), (Matcher)Matchers.is((Object)treatmentBuilder1.build()));
        FlowRule rule2 = rules.stream().filter(x -> x.deviceId().equals((Object)device2.id())).findFirst().get();
        TrafficSelector.Builder selectorBuilder2 = DefaultTrafficSelector.builder();
        selectorBuilder2.matchInPort(ochDstCP.port());
        MatcherAssert.assertThat((Object)rule2.selector(), (Matcher)Matchers.is((Object)selectorBuilder2.build()));
        MatcherAssert.assertThat((Object)rule2.treatment(), (Matcher)Matchers.is((Object)DefaultTrafficTreatment.builder().setOutput(oduCltDstCP.port()).build()));
        rules.forEach(rule -> Assert.assertEquals((String)"FlowRule priority is incorrect", (long)this.intent.priority(), (long)rule.priority()));
        this.sut.deactivate();
    }

    private class TestIntentService
    extends IntentServiceAdapter {
        private Set<Intent> intents = Sets.newHashSet();

        public void submit(Intent intent) {
            this.intents.add(intent);
        }

        public long getIntentCount() {
            return this.intents.size();
        }

        public Iterable<Intent> getIntents() {
            return this.intents;
        }

        public Intent getIntent(Key intentKey) {
            for (Intent intent : this.intents) {
                if (!intent.key().equals((Object)intentKey)) continue;
                return intent;
            }
            return null;
        }
    }

    private static class MockIntentSetMultimap
    implements IntentSetMultimap {
        private MockIntentSetMultimap() {
        }

        public boolean allocateMapping(IntentId keyIntentId, IntentId valIntentId) {
            return false;
        }

        public Set<IntentId> getMapping(IntentId intentId) {
            return null;
        }

        public void releaseMapping(IntentId intentId) {
        }
    }

    private static class MockDriverServiceNoTs
    implements DriverService {
        private MockDriverServiceNoTs() {
        }

        public Driver getDriver(String driverName) {
            return null;
        }

        public Set<Driver> getDrivers() {
            return null;
        }

        public Set<Driver> getDrivers(Class<? extends Behaviour> withBehaviour) {
            return null;
        }

        public Driver getDriver(String mfr, String hw, String sw) {
            return null;
        }

        public Driver getDriver(DeviceId deviceId) {
            DefaultDriver ddp = new DefaultDriver("foo.base", new ArrayList(), "Circus", "lux", "1.2a", (Map)ImmutableMap.of(Behaviour.class, TestBehaviourImpl.class), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
            return ddp;
        }

        public DriverHandler createHandler(DeviceId deviceId, String ... credentials) {
            return null;
        }
    }

    private static class MockDriverServiceWithTs
    implements DriverService {
        private MockDriverServiceWithTs() {
        }

        public Driver getDriver(String driverName) {
            return null;
        }

        public Set<Driver> getDrivers() {
            return null;
        }

        public Set<Driver> getDrivers(Class<? extends Behaviour> withBehaviour) {
            return null;
        }

        public Driver getDriver(String mfr, String hw, String sw) {
            return null;
        }

        public Driver getDriver(DeviceId deviceId) {
            DefaultDriver ddp = new DefaultDriver("foo.base", new ArrayList(), "Circus", "lux", "1.2a", (Map)ImmutableMap.of(Behaviour.class, TestBehaviourImpl.class, TributarySlotQuery.class, TestBehaviourTwoImpl.class), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
            return ddp;
        }

        public DriverHandler createHandler(DeviceId deviceId, String ... credentials) {
            return null;
        }
    }

    private static class MockDeviceService
    extends DeviceServiceAdapter {
        private MockDeviceService() {
        }

        public boolean isAvailable(DeviceId deviceId) {
            return true;
        }

        public List<Port> getPorts(DeviceId deviceId) {
            if (deviceId.equals((Object)DeviceId.deviceId((String)OpticalCircuitIntentCompilerTest.DEV1))) {
                return ImmutableList.of((Object)D1P1, (Object)D1P2, (Object)D1P3);
            }
            if (deviceId.equals((Object)DeviceId.deviceId((String)OpticalCircuitIntentCompilerTest.DEV2))) {
                return ImmutableList.of((Object)D2P1, (Object)D2P2, (Object)D2P3);
            }
            return Collections.emptyList();
        }

        public Port getPort(DeviceId deviceId, PortNumber portNumber) {
            if (deviceId.equals((Object)DeviceId.deviceId((String)OpticalCircuitIntentCompilerTest.DEV1))) {
                switch (portNumber.toString()) {
                    case "1": {
                        return D1P1;
                    }
                    case "2": {
                        return D1P2;
                    }
                    case "3": {
                        return D1P3;
                    }
                }
                return null;
            }
            if (deviceId.equals((Object)DeviceId.deviceId((String)OpticalCircuitIntentCompilerTest.DEV2))) {
                switch (portNumber.toString()) {
                    case "1": {
                        return D2P1;
                    }
                    case "2": {
                        return D2P2;
                    }
                    case "3": {
                        return D2P3;
                    }
                }
                return null;
            }
            return null;
        }
    }
}

