/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.intent.impl.compiler;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Lambda;
import org.onosproject.net.Link;
import org.onosproject.net.OchSignalType;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.OpticalPathIntent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpticalPathIntentCompiler
implements IntentCompiler<OpticalPathIntent> {
    private static final Logger log = LoggerFactory.getLogger(OpticalPathIntentCompiler.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentExtensionService intentManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private ApplicationId appId;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication("org.onosproject.net.intent");
        this.intentManager.registerCompiler(OpticalPathIntent.class, (IntentCompiler)this);
    }

    @Deactivate
    public void deactivate() {
        this.intentManager.unregisterCompiler(OpticalPathIntent.class);
    }

    public List<Intent> compile(OpticalPathIntent intent, List<Intent> installable) {
        log.debug("Compiling optical path intent between {} and {}", (Object)intent.src(), (Object)intent.dst());
        List<FlowRule> rules = this.createRules(intent);
        if (intent.isBidirectional()) {
            rules.addAll(this.createReverseRules(intent));
        }
        return Collections.singletonList(new FlowRuleIntent(this.appId, intent.key(), rules, intent.resources()));
    }

    private List<FlowRule> createRules(OpticalPathIntent intent) {
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchInPort(intent.src().port());
        LinkedList<FlowRule> rules = new LinkedList<FlowRule>();
        ConnectPoint current = intent.src();
        for (Link link : intent.path().links()) {
            TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
            treatmentBuilder.add((Instruction)Instructions.modL0Lambda((Lambda)intent.lambda()));
            treatmentBuilder.setOutput(link.src().port());
            FlowRule rule = DefaultFlowRule.builder().forDevice(current.deviceId()).withSelector(selectorBuilder.build()).withTreatment(treatmentBuilder.build()).withPriority(intent.priority()).fromApp(this.appId).makePermanent().build();
            rules.add(rule);
            current = link.dst();
            selectorBuilder.matchInPort(link.dst().port());
            selectorBuilder.add(Criteria.matchLambda((Lambda)intent.lambda()));
            selectorBuilder.add(Criteria.matchOchSignalType((OchSignalType)intent.signalType()));
        }
        TrafficTreatment.Builder treatmentLast = DefaultTrafficTreatment.builder();
        treatmentLast.setOutput(intent.dst().port());
        FlowRule rule = new DefaultFlowRule.Builder().forDevice(intent.dst().deviceId()).withSelector(selectorBuilder.build()).withTreatment(treatmentLast.build()).withPriority(intent.priority()).fromApp(this.appId).makePermanent().build();
        rules.add(rule);
        return rules;
    }

    private List<FlowRule> createReverseRules(OpticalPathIntent intent) {
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchInPort(intent.dst().port());
        LinkedList<FlowRule> rules = new LinkedList<FlowRule>();
        ConnectPoint current = intent.dst();
        for (Link link : Lists.reverse((List)intent.path().links())) {
            TrafficTreatment.Builder treatmentBuilder = DefaultTrafficTreatment.builder();
            treatmentBuilder.add((Instruction)Instructions.modL0Lambda((Lambda)intent.lambda()));
            treatmentBuilder.setOutput(link.dst().port());
            FlowRule rule = DefaultFlowRule.builder().forDevice(current.deviceId()).withSelector(selectorBuilder.build()).withTreatment(treatmentBuilder.build()).withPriority(intent.priority()).fromApp(this.appId).makePermanent().build();
            rules.add(rule);
            current = link.src();
            selectorBuilder.matchInPort(link.src().port());
            selectorBuilder.add(Criteria.matchLambda((Lambda)intent.lambda()));
            selectorBuilder.add(Criteria.matchOchSignalType((OchSignalType)intent.signalType()));
        }
        TrafficTreatment.Builder treatmentLast = DefaultTrafficTreatment.builder();
        treatmentLast.setOutput(intent.src().port());
        FlowRule rule = new DefaultFlowRule.Builder().forDevice(intent.src().deviceId()).withSelector(selectorBuilder.build()).withTreatment(treatmentLast.build()).withPriority(intent.priority()).fromApp(this.appId).makePermanent().build();
        rules.add(rule);
        return rules;
    }

    protected void bindIntentManager(IntentExtensionService intentExtensionService) {
        this.intentManager = intentExtensionService;
    }

    protected void unbindIntentManager(IntentExtensionService intentExtensionService) {
        if (this.intentManager == intentExtensionService) {
            this.intentManager = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }
}

