/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.intent.impl.compiler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.util.Frequency;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultOchSignalComparator;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OchSignalType;
import org.onosproject.net.Path;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentExtensionService;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.intent.OpticalPathIntent;
import org.onosproject.net.optical.OchPort;
import org.onosproject.net.optical.device.OpticalDeviceServiceView;
import org.onosproject.net.optical.intent.impl.compiler.OpticalIntentCompilationException;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.Resources;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyEdge;
import org.onosproject.net.topology.TopologyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class OpticalConnectivityIntentCompiler
implements IntentCompiler<OpticalConnectivityIntent> {
    protected static final Logger log = LoggerFactory.getLogger(OpticalConnectivityIntentCompiler.class);
    private static final int SLOT_COUNT = 4;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentExtensionService intentManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceService resourceService;

    @Activate
    public void activate() {
        this.deviceService = OpticalDeviceServiceView.opticalView(this.deviceService);
        this.intentManager.registerCompiler(OpticalConnectivityIntent.class, (IntentCompiler)this);
    }

    @Deactivate
    public void deactivate() {
        this.intentManager.unregisterCompiler(OpticalConnectivityIntent.class);
    }

    public List<Intent> compile(OpticalConnectivityIntent intent, List<Intent> installable) {
        ConnectPoint src = intent.getSrc();
        ConnectPoint dst = intent.getDst();
        Port srcPort = this.deviceService.getPort(src.deviceId(), src.port());
        Port dstPort = this.deviceService.getPort(dst.deviceId(), dst.port());
        Preconditions.checkArgument((boolean)(srcPort instanceof OchPort));
        Preconditions.checkArgument((boolean)(dstPort instanceof OchPort));
        log.debug("Compiling optical connectivity intent between {} and {}", (Object)src, (Object)dst);
        this.resourceService.release((ResourceConsumer)intent.id());
        DiscreteResource srcPortResource = Resources.discrete((DeviceId)src.deviceId(), (PortNumber)src.port(), (Object[])new Object[0]).resource();
        DiscreteResource dstPortResource = Resources.discrete((DeviceId)dst.deviceId(), (PortNumber)dst.port(), (Object[])new Object[0]).resource();
        if (!Stream.of(srcPortResource, dstPortResource).allMatch(arg_0 -> ((ResourceService)this.resourceService).isAvailable(arg_0))) {
            throw new OpticalIntentCompilationException("Ports for the intent are not available. Intent: " + intent);
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add((Resource)srcPortResource);
        resources.add((Resource)dstPortResource);
        Set<Path> paths = this.getOpticalPaths(intent);
        if (paths.isEmpty()) {
            throw new OpticalIntentCompilationException("Unable to find suitable lightpath for intent " + intent);
        }
        String staticLambda = srcPort.annotations().value("staticLambda");
        OchPort srcOchPort = (OchPort)srcPort;
        OchPort dstOchPort = (OchPort)dstPort;
        Path firstPath = paths.iterator().next();
        if (staticLambda != null) {
            this.allocateResources((Intent)intent, resources);
            OchSignal lambda = new OchSignal(Frequency.ofHz((long)Long.parseLong(staticLambda)), srcOchPort.lambda().channelSpacing(), srcOchPort.lambda().slotGranularity());
            return ImmutableList.of((Object)this.createIntent(intent, firstPath, lambda));
        }
        if (!srcOchPort.isTunable() || !dstOchPort.isTunable()) {
            this.allocateResources((Intent)intent, resources);
            OchSignal lambda = srcOchPort.lambda();
            return ImmutableList.of((Object)this.createIntent(intent, firstPath, lambda));
        }
        Optional<Map.Entry> found = paths.stream().map(path -> Maps.immutableEntry((Object)path, this.findFirstAvailableOch((Path)path))).filter(entry -> !((List)entry.getValue()).isEmpty()).filter(entry -> this.convertToResources(((Path)entry.getKey()).links(), (List)entry.getValue()).stream().allMatch(arg_0 -> ((ResourceService)this.resourceService).isAvailable(arg_0))).findFirst();
        if (found.isPresent()) {
            resources.addAll(this.convertToResources(((Path)found.get().getKey()).links(), (List)found.get().getValue()));
            this.allocateResources((Intent)intent, resources);
            OchSignal ochSignal = OchSignal.toFixedGrid((List)((List)found.get().getValue()), (ChannelSpacing)ChannelSpacing.CHL_50GHZ);
            return ImmutableList.of((Object)this.createIntent(intent, (Path)found.get().getKey(), ochSignal));
        }
        throw new OpticalIntentCompilationException("Unable to find suitable lightpath for intent " + intent);
    }

    private Intent createIntent(OpticalConnectivityIntent parentIntent, Path path, OchSignal lambda) {
        OchSignalType signalType = OchSignalType.FIXED_GRID;
        return OpticalPathIntent.builder().appId(parentIntent.appId()).key(parentIntent.key()).src(parentIntent.getSrc()).dst(parentIntent.getDst()).path(path).lambda(lambda).signalType(signalType).bidirectional(parentIntent.isBidirectional()).resourceGroup(parentIntent.resourceGroup()).build();
    }

    private void allocateResources(Intent intent, List<Resource> resources) {
        List allocations = this.resourceService.allocate((ResourceConsumer)intent.id(), resources);
        if (allocations.isEmpty()) {
            log.info("Resource allocation for {} failed (resource request: {})", (Object)intent, resources);
            throw new OpticalIntentCompilationException("Unable to allocate resources: " + resources);
        }
    }

    private List<OchSignal> findFirstAvailableOch(Path path) {
        Set<OchSignal> lambdas = this.findCommonLambdasOverLinks(path.links());
        if (lambdas.isEmpty()) {
            return Collections.emptyList();
        }
        return this.findFirstLambda(lambdas, this.slotCount());
    }

    private List<Resource> convertToResources(List<Link> links, List<OchSignal> lambda) {
        return links.stream().flatMap(x -> Stream.of(Resources.discrete((DeviceId)x.src().deviceId(), (PortNumber)x.src().port(), (Object[])new Object[0]).resource(), Resources.discrete((DeviceId)x.dst().deviceId(), (PortNumber)x.dst().port(), (Object[])new Object[0]).resource())).flatMap(x -> lambda.stream().map(arg_0 -> ((DiscreteResource)x).child(arg_0))).collect(Collectors.toList());
    }

    private int slotCount() {
        return 4;
    }

    private Set<OchSignal> findCommonLambdasOverLinks(List<Link> links) {
        return links.stream().flatMap(x -> Stream.of(Resources.discrete((DeviceId)x.src().deviceId(), (PortNumber)x.src().port(), (Object[])new Object[0]).id(), Resources.discrete((DeviceId)x.dst().deviceId(), (PortNumber)x.dst().port(), (Object[])new Object[0]).id())).map(x -> this.resourceService.getAvailableResourceValues(x, OchSignal.class)).map(x -> ImmutableSet.copyOf((Collection)x)).reduce(Sets::intersection).orElse(Collections.emptySet());
    }

    private List<OchSignal> findFirstLambda(Set<OchSignal> lambdas, int count) {
        ArrayList<OchSignal> lambdaList = new ArrayList<OchSignal>(lambdas);
        lambdaList.sort((Comparator<OchSignal>)new DefaultOchSignalComparator());
        for (int i = 0; i < lambdaList.size() - count; ++i) {
            if (((OchSignal)lambdaList.get(i)).spacingMultiplier() + 2 * count != ((OchSignal)lambdaList.get(i + count)).spacingMultiplier()) continue;
            return lambdaList.subList(i, i + count);
        }
        return Collections.emptyList();
    }

    private ConnectPoint staticPort(ConnectPoint connectPoint) {
        Port port = this.deviceService.getPort(connectPoint.deviceId(), connectPoint.port());
        String staticPort = port.annotations().value("staticPort");
        if (staticPort != null) {
            for (Port p : this.deviceService.getPorts(connectPoint.deviceId())) {
                if (!staticPort.equals(p.number().name())) continue;
                return new ConnectPoint(p.element().id(), p.number());
            }
        }
        return null;
    }

    private Set<Path> getOpticalPaths(final OpticalConnectivityIntent intent) {
        Topology topology = this.topologyService.currentTopology();
        LinkWeight weight = new LinkWeight(){

            public double weight(TopologyEdge edge) {
                ConnectPoint dstStaticPort;
                ConnectPoint srcStaticPort;
                if (edge.link().state() == Link.State.INACTIVE) {
                    return -1.0;
                }
                if (edge.link().type() != Link.Type.OPTICAL) {
                    return -1.0;
                }
                DeviceId srcDeviceId = edge.link().src().deviceId();
                if (srcDeviceId.equals((Object)intent.getSrc().deviceId()) && (srcStaticPort = OpticalConnectivityIntentCompiler.this.staticPort(intent.getSrc())) != null) {
                    return srcStaticPort.equals((Object)edge.link().src()) ? 1.0 : -1.0;
                }
                DeviceId dstDeviceId = edge.link().dst().deviceId();
                if (dstDeviceId.equals((Object)intent.getDst().deviceId()) && (dstStaticPort = OpticalConnectivityIntentCompiler.this.staticPort(intent.getDst())) != null) {
                    return dstStaticPort.equals((Object)edge.link().dst()) ? 1.0 : -1.0;
                }
                return 1.0;
            }
        };
        ConnectPoint start = intent.getSrc();
        ConnectPoint end = intent.getDst();
        Set paths = this.topologyService.getPaths(topology, start.deviceId(), end.deviceId(), weight);
        return paths;
    }

    protected void bindIntentManager(IntentExtensionService intentExtensionService) {
        this.intentManager = intentExtensionService;
    }

    protected void unbindIntentManager(IntentExtensionService intentExtensionService) {
        if (this.intentManager == intentExtensionService) {
            this.intentManager = null;
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }
}

