/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pim.cli;

import java.util.Set;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.pim.impl.PimInterface;
import org.onosproject.pim.impl.PimInterfaceService;

@Command(scope="onos", name="pim-interfaces", description="Lists the interfaces where PIM is enabled")
public class PimInterfacesListCommand
extends AbstractShellCommand {
    private static final String FORMAT = "interfaceName=%s, holdTime=%s, priority=%s, genId=%s";
    private static final String ROUTE_FORMAT = "    %s";

    protected void execute() {
        PimInterfaceService interfaceService = (PimInterfaceService)PimInterfacesListCommand.get(PimInterfaceService.class);
        Set<PimInterface> interfaces = interfaceService.getPimInterfaces();
        interfaces.forEach(pimIntf -> {
            this.print(FORMAT, new Object[]{pimIntf.getInterface().name(), pimIntf.getHoldtime(), pimIntf.getPriority(), pimIntf.getGenerationId()});
            pimIntf.getRoutes().forEach(route -> this.print(ROUTE_FORMAT, new Object[]{route}));
        });
    }
}

