/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pim.impl;

import java.util.Optional;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.Config;

public class PimInterfaceConfig
extends Config<ConnectPoint> {
    private static final String INTERFACE_NAME = "interfaceName";
    private static final String ENABLED = "enabled";
    private static final String HELLO_INTERVAL = "helloInterval";
    private static final String HOLD_TIME = "holdTime";
    private static final String PRIORITY = "priority";
    private static final String PROPAGATION_DELAY = "propagationDelay";
    private static final String OVERRIDE_INTERVAL = "overrideInterval";

    public String getInterfaceName() {
        return this.node.path(INTERFACE_NAME).asText();
    }

    public boolean isEnabled() {
        return this.node.path(ENABLED).asBoolean(false);
    }

    public Optional<Integer> getHelloInterval() {
        if (this.node.path(HELLO_INTERVAL).isMissingNode()) {
            return Optional.empty();
        }
        return Optional.of(Integer.parseInt(this.node.path(HELLO_INTERVAL).asText()));
    }

    public Optional<Short> getHoldTime() {
        if (this.node.path(HOLD_TIME).isMissingNode()) {
            return Optional.empty();
        }
        return Optional.of(Short.parseShort(this.node.path(HOLD_TIME).asText()));
    }

    public Optional<Integer> getPriority() {
        if (this.node.path(PRIORITY).isMissingNode()) {
            return Optional.empty();
        }
        return Optional.of(this.node.path(PRIORITY).asInt());
    }

    public Optional<Short> getPropagationDelay() {
        if (this.node.path(PROPAGATION_DELAY).isMissingNode()) {
            return Optional.empty();
        }
        return Optional.of(Short.parseShort(this.node.path(PROPAGATION_DELAY).asText()));
    }

    public Optional<Short> getOverrideInterval() {
        if (this.node.path(OVERRIDE_INTERVAL).isMissingNode()) {
            return Optional.empty();
        }
        return Optional.of(Short.parseShort(this.node.path(OVERRIDE_INTERVAL).asText()));
    }

    public boolean isValid() {
        if (!this.hasOnlyFields(new String[]{INTERFACE_NAME, ENABLED, HELLO_INTERVAL, HOLD_TIME, PRIORITY, PROPAGATION_DELAY, OVERRIDE_INTERVAL})) {
            return false;
        }
        return this.isString(INTERFACE_NAME, Config.FieldPresence.MANDATORY, new String[0]) && this.isBoolean(ENABLED, Config.FieldPresence.MANDATORY) && this.isIntegralNumber(HELLO_INTERVAL, Config.FieldPresence.OPTIONAL, new long[0]) && this.isIntegralNumber(HOLD_TIME, Config.FieldPresence.OPTIONAL, new long[0]) && this.isIntegralNumber(PRIORITY, Config.FieldPresence.OPTIONAL, new long[0]) && this.isIntegralNumber(PROPAGATION_DELAY, Config.FieldPresence.OPTIONAL, new long[0]) && this.isIntegralNumber(OVERRIDE_INTERVAL, Config.FieldPresence.OPTIONAL, new long[0]);
    }
}

