/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pim.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.pim.PIMHelloOption;

public class PimNeighbor {
    private final IpAddress ipAddr;
    private final MacAddress macAddr;
    private final short holdTime;
    private final int pruneDelay;
    private final int priority;
    private final int genId;
    private final long upTime;
    private long lastRefresh;

    public PimNeighbor(IpAddress ipAddress, MacAddress macAddress, short holdTime, int pruneDelay, int priority, int genId) {
        this.ipAddr = (IpAddress)Preconditions.checkNotNull((Object)ipAddress);
        this.macAddr = (MacAddress)Preconditions.checkNotNull((Object)macAddress);
        this.holdTime = holdTime;
        this.pruneDelay = pruneDelay;
        this.priority = priority;
        this.genId = genId;
        this.upTime = System.currentTimeMillis();
    }

    public IpAddress ipAddress() {
        return this.ipAddr;
    }

    public MacAddress macAddress() {
        return this.macAddr;
    }

    public short holdtime() {
        return this.holdTime;
    }

    public int pruneDelay() {
        return this.pruneDelay;
    }

    public int priority() {
        return this.priority;
    }

    public int generationId() {
        return this.genId;
    }

    public long lastRefresh() {
        return this.lastRefresh;
    }

    public long upTime() {
        return this.upTime;
    }

    public void refreshTimestamp() {
        this.lastRefresh = System.currentTimeMillis();
    }

    public boolean isExpired() {
        return this.lastRefresh + TimeUnit.SECONDS.toMillis(this.holdTime) < System.currentTimeMillis();
    }

    public static PimNeighbor createPimNeighbor(IpAddress ipAddress, MacAddress macAddress, Collection<PIMHelloOption> opts) {
        int generationID = 0;
        short holdTime = 105;
        int priority = 1;
        int pruneDelay = 500;
        for (PIMHelloOption opt : opts) {
            short type = opt.getOptType();
            ByteBuffer value = ByteBuffer.wrap(opt.getValue());
            if (type == 20) {
                generationID = value.getInt();
                continue;
            }
            if (type == 1) {
                holdTime = value.getShort();
                continue;
            }
            if (type == 19) {
                priority = value.getInt();
                continue;
            }
            if (type == 2) {
                pruneDelay = value.getInt();
                continue;
            }
            if (type != 24) continue;
        }
        return new PimNeighbor(ipAddress, macAddress, holdTime, pruneDelay, priority, generationID);
    }

    public boolean equals(Object other) {
        if (!(other instanceof PimNeighbor)) {
            return false;
        }
        PimNeighbor that = (PimNeighbor)other;
        return this.ipAddr.equals((Object)that.ipAddress()) && this.macAddr.equals((Object)that.macAddress()) && this.genId == that.genId && this.holdTime == that.holdTime && this.priority == that.priority;
    }

    public int hashCode() {
        return Objects.hash(this.ipAddr, this.macAddr, this.genId, this.holdTime, this.priority);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ipAddress", (Object)this.ipAddr).add("macAddress", (Object)this.macAddr).add("generationId", this.genId).add("holdTime", (int)this.holdTime).add("priority", this.priority).add("pruneDelay", this.pruneDelay).toString();
    }
}

